/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.jutsu.byakugan;

import com.f1njo.sre.chakra.api.IChakra;
import com.f1njo.sre.chakra.impl.ChakraProvider;
import com.f1njo.sre.items.jutsu.ItemJutsu;
import com.f1njo.sre.items.jutsu.taijutsu.ITaijutsuRequirement;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemByakuganJutsu1
extends ItemJutsu
implements ITaijutsuRequirement {
    private static final int REQUIRED_TAIJUTSU = 25;

    @Override
    public int getRequiredTaijutsu() {
        return 25;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @Override
    protected void performJutsu(World world, EntityPlayer player) {
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            if (!player.field_70170_p.field_72995_K) {
                this.ensureOwner(stack, player);
                if (!this.isOwner(stack, player)) {
                    player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"tooltip.owner", (Object[])new Object[]{this.getOwnerName(stack)})));
                    return super.func_77644_a(stack, target, attacker);
                }
                IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
                if (stats == null || stats.getTaijutsu() < 25) {
                    player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.not_enough_skill", (Object[])new Object[0])));
                    return super.func_77644_a(stack, target, attacker);
                }
                if (!stats.isByakuganActive()) {
                    player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.byakugan.deactivated", (Object[])new Object[0])));
                    return super.func_77644_a(stack, target, attacker);
                }
                if (player.func_184811_cZ().func_185141_a((Item)this)) {
                    return super.func_77644_a(stack, target, attacker);
                }
                if (!this.canUseJutsu(player)) {
                    player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.not_enough_chakra", (Object[])new Object[0])));
                    return super.func_77644_a(stack, target, attacker);
                }
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 4.0f);
                double dx = player.field_70165_t - target.field_70165_t;
                double dz = player.field_70161_v - target.field_70161_v;
                double dist = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                if (dist > 0.0) {
                    target.func_70653_a((Entity)player, 0.7f, dx / dist, dz / dist);
                }
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187727_dV, SoundCategory.PLAYERS, 0.7f, 1.2f);
                this.onJutsuUsed(player);
                player.func_184609_a(EnumHand.MAIN_HAND);
                return true;
            }
        }
        return super.func_77644_a(stack, target, attacker);
    }

    @Override
    protected void onJutsuUsed(EntityPlayer player) {
        IChakra chakra = (IChakra)player.getCapability(ChakraProvider.CHAKRA_CAP, null);
        if (chakra != null) {
            chakra.consumeChakra(this.getChakraCost());
        }
        if (!player.field_70170_p.field_72995_K) {
            TextComponentString msg = new TextComponentString(this.getJutsuName());
            msg.func_150256_b().func_150238_a(this.getChatColor());
            player.func_145747_a((ITextComponent)msg);
            player.func_184811_cZ().func_185145_a((Item)this, this.getCooldown());
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)"item.byakugan_jutsu_1.desc1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.byakugan_jutsu_1.desc2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tooltip.chakra_cost", (Object[])new Object[]{String.valueOf(this.getChakraCost())}));
    }

    @Override
    protected int getChakraCost() {
        return 5;
    }

    @Override
    protected int getCooldown() {
        return 40;
    }
}

