/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.jutsu.byakugan;

import com.f1njo.sre.chakra.api.IChakra;
import com.f1njo.sre.chakra.impl.ChakraProvider;
import com.f1njo.sre.core.ModPotions;
import com.f1njo.sre.items.jutsu.ItemJutsu;
import com.f1njo.sre.items.jutsu.taijutsu.ITaijutsuRequirement;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemByakuganJutsu2
extends ItemJutsu
implements ITaijutsuRequirement {
    private static final int REQUIRED_TAIJUTSU = 150;
    private static final int MAX_STACKS = 18;
    private static final int ADDITIONAL_DURATION_TICKS = 300;
    private static final String NBT_REMAINDER = "chakraChannelsDamageRemainder";

    @Override
    public int getRequiredTaijutsu() {
        return 150;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @Override
    protected void performJutsu(World world, EntityPlayer player) {
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            if (!player.field_70170_p.field_72995_K) {
                this.ensureOwner(stack, player);
                if (!this.isOwner(stack, player)) {
                    player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"tooltip.owner", (Object[])new Object[]{this.getOwnerName(stack)})));
                    return super.func_77644_a(stack, target, attacker);
                }
                IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
                if (stats == null || stats.getTaijutsu() < 150) {
                    player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.not_enough_skill", (Object[])new Object[0])));
                    return super.func_77644_a(stack, target, attacker);
                }
                if (!stats.isByakuganActive()) {
                    player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.byakugan.deactivated", (Object[])new Object[0])));
                    return super.func_77644_a(stack, target, attacker);
                }
                if (player.func_184811_cZ().func_185141_a((Item)this)) {
                    return super.func_77644_a(stack, target, attacker);
                }
                if (!this.canUseJutsu(player)) {
                    player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.not_enough_chakra", (Object[])new Object[0])));
                    return super.func_77644_a(stack, target, attacker);
                }
                this.applyGentleFistEffects(player, target);
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187727_dV, SoundCategory.PLAYERS, 0.7f, 1.2f);
                this.onJutsuUsed(player);
                player.func_184609_a(EnumHand.MAIN_HAND);
                return true;
            }
        }
        return super.func_77644_a(stack, target, attacker);
    }

    private void applyGentleFistEffects(EntityPlayer attacker, EntityLivingBase target) {
        target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)attacker), 1.0f);
        if (!(target instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer targetPlayer = (EntityPlayer)target;
        IChakra chakra = (IChakra)targetPlayer.getCapability(ChakraProvider.CHAKRA_CAP, null);
        if (chakra == null) {
            return;
        }
        PotionEffect existing = targetPlayer.func_70660_b(ModPotions.CHAKRA_CHANNELS_DAMAGED);
        int existingStacks = existing != null ? existing.func_76458_c() + 1 : 0;
        int newStacks = Math.min(existingStacks + 1, 18);
        double existingFraction = Math.min((double)existingStacks * 0.05, 0.9);
        double newFraction = Math.min((double)newStacks * 0.05, 0.9);
        double deltaFraction = newFraction - existingFraction;
        int maxChakra = chakra.getMaxChakra();
        int currentChakra = chakra.getChakra();
        if (deltaFraction > 0.0 && maxChakra > 0) {
            int minChakra;
            double storedRemainder = targetPlayer.getEntityData().func_74769_h(NBT_REMAINDER);
            double chakraToRemove = (double)maxChakra * deltaFraction + storedRemainder;
            int removeNow = (int)Math.floor(chakraToRemove);
            int newChakra = Math.max(currentChakra - removeNow, 0);
            if (newFraction >= 0.9 && newChakra < (minChakra = (int)Math.ceil((double)maxChakra * 0.1))) {
                newChakra = minChakra;
            }
            int actualRemoved = currentChakra - newChakra;
            double newRemainder = chakraToRemove - (double)actualRemoved;
            if (currentChakra > newChakra) {
                chakra.setChakra(newChakra);
                currentChakra = newChakra;
            }
            if (newFraction >= 0.9) {
                newRemainder = 0.0;
            }
            targetPlayer.getEntityData().func_74780_a(NBT_REMAINDER, Math.max(0.0, newRemainder));
        } else if (deltaFraction > 0.0) {
            targetPlayer.getEntityData().func_74780_a(NBT_REMAINDER, 0.0);
        } else if (newFraction >= 0.9 && maxChakra > 0) {
            int minChakra = (int)Math.ceil((double)maxChakra * 0.1);
            if (currentChakra > minChakra) {
                chakra.setChakra(minChakra);
                currentChakra = minChakra;
            }
            targetPlayer.getEntityData().func_74780_a(NBT_REMAINDER, 0.0);
        }
        if (deltaFraction <= 0.0) {
            targetPlayer.getEntityData().func_74780_a(NBT_REMAINDER, 0.0);
        }
        int newDuration = 300 + (existing != null ? existing.func_76459_b() : 0);
        targetPlayer.func_70690_d(new PotionEffect(ModPotions.CHAKRA_CHANNELS_DAMAGED, newDuration, newStacks - 1, false, true));
    }

    @Override
    protected void onJutsuUsed(EntityPlayer player) {
        IChakra chakra = (IChakra)player.getCapability(ChakraProvider.CHAKRA_CAP, null);
        if (chakra != null) {
            chakra.consumeChakra(this.getChakraCost());
        }
        if (!player.field_70170_p.field_72995_K) {
            TextComponentString msg = new TextComponentString(this.getJutsuName());
            msg.func_150256_b().func_150238_a(this.getChatColor());
            player.func_145747_a((ITextComponent)msg);
            player.func_184811_cZ().func_185145_a((Item)this, this.getCooldown());
        }
        if (player instanceof EntityPlayerMP) {
            player.field_71069_bz.func_75142_b();
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)"item.byakugan_jutsu_2.desc1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.byakugan_jutsu_2.desc2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tooltip.chakra_cost", (Object[])new Object[]{String.valueOf(this.getChakraCost())}));
    }

    @Override
    protected int getChakraCost() {
        return 15;
    }

    @Override
    protected int getCooldown() {
        return 60;
    }
}

