/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.jutsu.earthrelease;

import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.network.jutsu.MessageStoneFistSync;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class StoneFistHandler {
    public StoneFistHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayer player = event.player;
        int ticks = player.getEntityData().func_74762_e("stoneFistTicks");
        if (ticks > 0) {
            player.getEntityData().func_74768_a("stoneFistTicks", ticks - 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttackEntity(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.getEntityData().func_74762_e("stoneFistTicks") > 0 && player.func_184614_ca().func_190926_b()) {
            Entity target = event.getTarget();
            if (target instanceof EntityLivingBase) {
                EntityLivingBase livingTarget = (EntityLivingBase)target;
                livingTarget.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 15.0f);
                float sin = MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180)));
                float cos = -MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)));
                livingTarget.func_70653_a((Entity)player, 0.5f, (double)sin, (double)cos);
                livingTarget.func_70604_c((EntityLivingBase)player);
                if (livingTarget instanceof EntityCreature) {
                    ((EntityCreature)livingTarget).func_70624_b((EntityLivingBase)player);
                }
            } else {
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 15.0f);
            }
            event.setCanceled(true);
            player.getEntityData().func_74768_a("stoneFistTicks", 0);
            ModNetwork.sendTo(new MessageStoneFistSync(0), (EntityPlayerMP)player);
        }
    }
}

