/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.jutsu.genjutsu.sharingan;

import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.items.jutsu.ItemJutsu;
import com.f1njo.sre.items.jutsu.genjutsu.IGenjutsuRequirement;
import com.f1njo.sre.main.ShinobiTab;
import com.f1njo.sre.network.jutsu.MessageSharinganGenjutsuSync;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemSharinganJutsu2
extends ItemJutsu
implements IGenjutsuRequirement {
    private static final int REQUIRED_GENJUTSU = 75;

    public ItemSharinganJutsu2() {
        this.func_77637_a(ShinobiTab.INSTANCE);
        this.func_77625_d(1);
    }

    @Override
    public int getRequiredGenjutsu() {
        return 75;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        this.ensureOwner(stack, player);
        if (!this.isOwner(stack, player)) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"tooltip.owner", (Object[])new Object[]{this.getOwnerName(stack)})));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null || stats.getGenjutsu() < 75) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.not_enough_skill", (Object[])new Object[0])));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (stats == null || !stats.isSharinganActive()) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.sharingan.deactivated", (Object[])new Object[0])));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (this.canUseJutsu(player)) {
            this.performJutsu(world, player);
            if (!world.field_72995_K) {
                this.onJutsuUsed(player);
            }
        } else if (!world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.not_enough_chakra", (Object[])new Object[0])));
        }
        player.func_184609_a(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    protected void performJutsu(World world, EntityPlayer player) {
        double distance = 20.0;
        Vec3d start = player.func_174824_e(1.0f);
        Vec3d look = player.func_70676_i(1.0f);
        Vec3d end = start.func_178787_e(look.func_186678_a(distance));
        Entity pointed = null;
        double best = distance;
        AxisAlignedBB search = player.func_174813_aQ().func_72321_a(look.field_72450_a * distance, look.field_72448_b * distance, look.field_72449_c * distance).func_186662_g(1.0);
        List entities = world.func_72839_b((Entity)player, search);
        for (Entity e : entities) {
            double d;
            if (!e.func_70067_L()) continue;
            float border = e.func_70111_Y();
            AxisAlignedBB aabb = e.func_174813_aQ().func_186662_g((double)border);
            RayTraceResult intercept = aabb.func_72327_a(start, end);
            if (aabb.func_72318_a(start)) {
                if (!(0.0 < best)) continue;
                pointed = e;
                best = 0.0;
                continue;
            }
            if (intercept == null || !((d = start.func_72438_d(intercept.field_72307_f)) < best)) continue;
            pointed = e;
            best = d;
        }
        if (pointed instanceof EntityLivingBase && (double)player.func_70032_d(pointed) <= distance) {
            EntityLivingBase target = (EntityLivingBase)pointed;
            target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 80, 1));
            if (target instanceof EntityPlayer) {
                EntityPlayer targetPlayer = (EntityPlayer)target;
                targetPlayer.getEntityData().func_74768_a("sharinganGenjutsuTicks", 80);
                if (!world.field_72995_K) {
                    ModNetwork.sendTo(new MessageSharinganGenjutsuSync(80), (EntityPlayerMP)targetPlayer);
                }
            }
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)"item.sharingan_jutsu_2.desc1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tooltip.chakra_cost", (Object[])new Object[]{String.valueOf(this.getChakraCost())}));
    }

    @Override
    protected int getChakraCost() {
        return 50;
    }

    @Override
    protected int getCooldown() {
        return 600;
    }
}

