/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.jutsu.medical;

import com.f1njo.sre.chakra.api.IChakra;
import com.f1njo.sre.chakra.impl.ChakraProvider;
import com.f1njo.sre.items.jutsu.ItemJutsu;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemMedicalJutsu1
extends ItemJutsu {
    private static final int REQUIRED_CHAKRA_CONTROL = 50;
    private static final int REQUIRED_IRYO = 100;
    private static final int MAX_USE_DURATION = 100;
    private static final int COOLDOWN_TICKS = 900;
    private static final int CHAKRA_PER_TICK = 1;
    private static final double TARGET_RANGE = 3.0;
    private static final double FRONT_DOT_THRESHOLD = 0.5;

    public int func_77626_a(ItemStack stack) {
        return 100;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        this.ensureOwner(stack, player);
        if (!this.isOwner(stack, player)) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"tooltip.owner", (Object[])new Object[]{this.getOwnerName(stack)})));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null || stats.getIryo() < 100) {
            if (!world.field_72995_K) {
                TextComponentString msg = new TextComponentString(I18n.func_135052_a((String)"message.not_enough_iryo", (Object[])new Object[0]));
                msg.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)msg);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (stats.getChakraControl() < 50) {
            if (!world.field_72995_K) {
                TextComponentString msg = new TextComponentString(I18n.func_135052_a((String)"message.not_enough_control", (Object[])new Object[0]));
                msg.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)msg);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        IChakra chakra = (IChakra)player.getCapability(ChakraProvider.CHAKRA_CAP, null);
        if (chakra == null || chakra.getChakra() < 1) {
            if (!world.field_72995_K) {
                TextComponentString msg = new TextComponentString(I18n.func_135052_a((String)"message.not_enough_chakra", (Object[])new Object[0]));
                msg.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)msg);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (!world.field_72995_K) {
            TextComponentString msg = new TextComponentString(this.getJutsuName());
            msg.func_150256_b().func_150238_a(this.getChatColor());
            player.func_145747_a((ITextComponent)msg);
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entityLiving, int count) {
        super.onUsingTick(stack, entityLiving, count);
        if (!(entityLiving instanceof EntityPlayer)) {
            entityLiving.func_184597_cx();
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        if (!player.field_70170_p.field_72995_K) {
            IChakra chakra = (IChakra)player.getCapability(ChakraProvider.CHAKRA_CAP, null);
            if (chakra == null) {
                player.func_184597_cx();
                return;
            }
            if (chakra.getChakra() < 1) {
                TextComponentString msg = new TextComponentString(I18n.func_135052_a((String)"message.not_enough_chakra", (Object[])new Object[0]));
                msg.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)msg);
                player.func_184597_cx();
                return;
            }
            chakra.consumeChakra(1);
            EntityLivingBase target = this.findHealingTarget(player);
            if (target != null && target.func_70089_S()) {
                target.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 25, 2, false, true));
            }
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        super.func_77615_a(stack, world, entityLiving, timeLeft);
        if (!world.field_72995_K && entityLiving instanceof EntityPlayer) {
            this.applyCooldown((EntityPlayer)entityLiving);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (!world.field_72995_K && entityLiving instanceof EntityPlayer) {
            this.applyCooldown((EntityPlayer)entityLiving);
        }
        return stack;
    }

    private void applyCooldown(EntityPlayer player) {
        player.func_184811_cZ().func_185145_a((Item)this, this.getCooldown());
    }

    @Nullable
    private EntityLivingBase findHealingTarget(EntityPlayer player) {
        Vec3d eyePos = player.func_174824_e(1.0f);
        Vec3d look = player.func_70040_Z().func_72432_b();
        AxisAlignedBB searchBox = player.func_174813_aQ().func_72321_a(look.field_72450_a * 3.0, look.field_72448_b * 3.0, look.field_72449_c * 3.0).func_186662_g(1.0);
        List candidates = player.field_70170_p.func_175647_a(EntityLivingBase.class, searchBox, entity -> entity != player && entity.func_70089_S());
        return candidates.stream().min(Comparator.comparingDouble(entity -> {
            Vec3d targetPos = this.getEntityCenter((EntityLivingBase)entity);
            return targetPos.func_72436_e(eyePos);
        })).filter(entity -> {
            Vec3d targetPos = this.getEntityCenter((EntityLivingBase)entity);
            Vec3d toEntity = targetPos.func_178788_d(eyePos);
            double distanceSq = toEntity.func_189985_c();
            if (distanceSq > 9.0) {
                return false;
            }
            if (distanceSq < 1.0E-4) {
                return true;
            }
            return look.func_72430_b(toEntity = toEntity.func_72432_b()) >= 0.5;
        }).orElse(null);
    }

    private Vec3d getEntityCenter(EntityLivingBase entity) {
        return new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O * 0.5, entity.field_70161_v);
    }

    @Override
    protected void performJutsu(World world, EntityPlayer player) {
    }

    @Override
    protected int getCooldown() {
        return 900;
    }

    @Override
    protected int getChakraCost() {
        return 0;
    }

    @Override
    protected TextFormatting getChatColor() {
        return TextFormatting.GREEN;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)"item.medical_jutsu_1.desc1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.medical_jutsu_1.desc2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tooltip.chakra_drain", (Object[])new Object[]{20}));
    }
}

