/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.jutsu.taijutsu;

import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.core.ModPotions;
import com.f1njo.sre.network.jutsu.MessageEightGatePunch;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EightGatesHandler {
    public static final int SHOCKWAVE_DURATION = 10;
    public static double PUNCH_RADIUS = 1.0;
    public static double PUNCH_RANGE = 15.0;
    private static final int PUNCH_COOLDOWN = 20;
    private static final UUID STRENGTH_MODIFIER_UUID = UUID.fromString("7a0b81ab-5f93-4ac5-bd78-5e4af30c5f85");
    private static final UUID SPEED_MODIFIER_UUID = UUID.fromString("0faac091-2d74-4c47-9b4d-ec54abf0e93b");

    public EightGatesHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayer player = event.player;
        NBTTagCompound data = player.getEntityData();
        int level = data.func_74762_e("eightGatesLevel");
        if (level > 0) {
            Potion potion;
            int time = data.func_74762_e("eightGatesTime") + 1;
            int strength = 0;
            int speed = 0;
            int jump = 0;
            int resistance = -1;
            switch (level) {
                case 1: {
                    strength = 0;
                    speed = 0;
                    jump = 0;
                    break;
                }
                case 2: {
                    strength = 1;
                    speed = 1;
                    jump = 0;
                    resistance = 0;
                    break;
                }
                case 3: {
                    strength = 2;
                    speed = 2;
                    jump = 0;
                    resistance = 0;
                    break;
                }
                case 4: {
                    strength = 3;
                    speed = 3;
                    jump = 1;
                    resistance = 0;
                    if (time <= 900 || time % 100 != 0) break;
                    player.func_70097_a(DamageSource.field_76377_j, 4.0f);
                    break;
                }
                case 5: {
                    strength = 4;
                    speed = 4;
                    jump = 1;
                    resistance = 0;
                    if (time <= 900 || time % 80 != 0) break;
                    player.func_70097_a(DamageSource.field_76377_j, 6.0f);
                    break;
                }
                case 6: {
                    strength = 5;
                    speed = 5;
                    jump = 1;
                    resistance = 2;
                    if (time <= 700 || time % 80 != 0) break;
                    player.func_70097_a(DamageSource.field_76377_j, 10.0f);
                    break;
                }
                case 7: {
                    strength = 7;
                    speed = 7;
                    jump = 2;
                    resistance = 3;
                    if (time <= 600 || time % 60 != 0) break;
                    player.func_70097_a(DamageSource.field_76377_j, 15.0f);
                    break;
                }
                case 8: {
                    strength = 11;
                    speed = 11;
                    jump = 4;
                    resistance = 4;
                    if (time < 500) break;
                    player.func_70097_a(DamageSource.field_76380_i, Float.MAX_VALUE);
                }
            }
            this.applyGateAttributes(player, strength, speed);
            data.func_74768_a("eightGatesResistanceLevel", resistance);
            data.func_74768_a("eightGatesJumpLevel", jump);
            if (!player.field_70170_p.field_72995_K && (potion = this.getGatePotion(level)) != null) {
                player.func_70690_d(new PotionEffect(potion, 5, 0, false, false));
            }
            data.func_74768_a("eightGatesTime", time);
            int cd = data.func_74762_e("punchCooldown");
            if (cd > 0) {
                data.func_74768_a("punchCooldown", cd - 1);
            }
            if (player.field_70170_p.field_72995_K) {
                if (level >= 4 && level <= 6) {
                    int count;
                    switch (level) {
                        case 4: {
                            count = 5;
                            break;
                        }
                        case 5: {
                            count = 8;
                            break;
                        }
                        default: {
                            count = 12;
                        }
                    }
                    for (int i = 0; i < count; ++i) {
                        double offsetX = (player.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)player.field_70130_N;
                        double offsetY = player.field_70170_p.field_73012_v.nextDouble() * (double)player.field_70131_O;
                        double offsetZ = (player.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)player.field_70130_N;
                        player.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, player.field_70165_t + offsetX, player.field_70163_u + offsetY, player.field_70161_v + offsetZ, 0.2, 1.0, 0.2, new int[0]);
                    }
                }
                if (level == 7 || level == 8) {
                    for (int i = 0; i < 10; ++i) {
                        double offsetX = (player.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)player.field_70130_N;
                        double offsetY = player.field_70170_p.field_73012_v.nextDouble() * (double)player.field_70131_O;
                        double offsetZ = (player.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)player.field_70130_N;
                        if (level == 8) {
                            player.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, player.field_70165_t + offsetX, player.field_70163_u + offsetY, player.field_70161_v + offsetZ, 1.0, 0.0, 0.0, new int[0]);
                            continue;
                        }
                        player.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, player.field_70165_t + offsetX, player.field_70163_u + offsetY, player.field_70161_v + offsetZ, 0.3, 0.6, 1.0, new int[0]);
                    }
                }
            }
        } else if (data.func_74762_e("eightGatesResistanceLevel") != -1 || data.func_74762_e("eightGatesJumpLevel") != -1) {
            this.clearGateBonuses(player);
        } else {
            this.clearGateAttributes(player);
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        EntityPlayer player;
        NBTTagCompound data;
        if (event.getEntity() instanceof EntityPlayer && (data = (player = (EntityPlayer)event.getEntity()).getEntityData()).func_74762_e("eightGatesLevel") > 0) {
            data.func_74768_a("eightGatesLevel", 0);
            data.func_74768_a("eightGatesTime", 0);
            data.func_74768_a("shockwaveProgress", 10);
            this.clearGateBonuses(player);
        }
    }

    private void spawnShockwaveRing(EntityPlayer player, double radius) {
        int points = 72;
        for (int i = 0; i < points; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)points;
            double x = player.field_70165_t + Math.cos(angle) * radius;
            double z = player.field_70161_v + Math.sin(angle) * radius;
            player.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, x, player.field_70163_u + 0.1, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SubscribeEvent
    public void onAttackEntity(AttackEntityEvent event) {
        EntityLivingBase target;
        Entity entity = event.getTarget();
        EntityLivingBase entityLivingBase = target = entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        if (EightGatesHandler.handleEightGatePunch(event.getEntityPlayer(), target)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        EntityPlayer player = event.getEntityPlayer();
        EightGatesHandler.handleEightGatePunch(player, null);
        if (player.field_70170_p.field_72995_K) {
            ModNetwork.sendToServer(new MessageEightGatePunch());
        }
    }

    public static void handlePunchFromPacket(EntityPlayer player) {
        EightGatesHandler.handleEightGatePunch(player, null);
    }

    private void applyGateAttributes(EntityPlayer player, int strengthLevel, int speedLevel) {
        double strengthAmount = strengthLevel >= 0 ? 3.0 * (double)(strengthLevel + 1) : 0.0;
        double speedAmount = speedLevel >= 0 ? 0.2 * (double)(speedLevel + 1) : 0.0;
        this.updateAttribute(player, SharedMonsterAttributes.field_111264_e, STRENGTH_MODIFIER_UUID, "EightGatesStrength", strengthAmount, 0);
        this.updateAttribute(player, SharedMonsterAttributes.field_111263_d, SPEED_MODIFIER_UUID, "EightGatesSpeed", speedAmount, 2);
    }

    private void clearGateBonuses(EntityPlayer player) {
        this.clearGateAttributes(player);
        NBTTagCompound data = player.getEntityData();
        data.func_74768_a("eightGatesResistanceLevel", -1);
        data.func_74768_a("eightGatesJumpLevel", -1);
    }

    private void clearGateAttributes(EntityPlayer player) {
        this.updateAttribute(player, SharedMonsterAttributes.field_111264_e, STRENGTH_MODIFIER_UUID, "EightGatesStrength", 0.0, 0);
        this.updateAttribute(player, SharedMonsterAttributes.field_111263_d, SPEED_MODIFIER_UUID, "EightGatesSpeed", 0.0, 2);
    }

    private void updateAttribute(EntityPlayer player, IAttribute attribute, UUID uuid, String name, double amount, int operation) {
        IAttributeInstance instance = player.func_110148_a(attribute);
        if (instance == null) {
            return;
        }
        AttributeModifier modifier = instance.func_111127_a(uuid);
        if (modifier != null) {
            if (Double.compare(modifier.func_111164_d(), amount) == 0 && modifier.func_111169_c() == operation) {
                return;
            }
            instance.func_111124_b(modifier);
        }
        if (amount != 0.0) {
            instance.func_111121_a(new AttributeModifier(uuid, name, amount, operation));
        }
    }

    private Potion getGatePotion(int level) {
        switch (level) {
            case 1: {
                return ModPotions.EIGHT_GATE_BEGINNING;
            }
            case 2: {
                return ModPotions.EIGHT_GATE_HEALING;
            }
            case 3: {
                return ModPotions.EIGHT_GATE_LIFE;
            }
            case 4: {
                return ModPotions.EIGHT_GATE_PAIN;
            }
            case 5: {
                return ModPotions.EIGHT_GATE_LIMIT;
            }
            case 6: {
                return ModPotions.EIGHT_GATE_VIEW;
            }
            case 7: {
                return ModPotions.EIGHT_GATE_WONDER;
            }
            case 8: {
                return ModPotions.EIGHT_GATE_DEATH;
            }
        }
        return null;
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        NBTTagCompound data = entity.getEntityData();
        if (!data.func_74764_b("eightGatesResistanceLevel")) {
            return;
        }
        int resistance = data.func_74762_e("eightGatesResistanceLevel");
        if (resistance >= 0 && !event.getSource().func_151517_h() && event.getSource() != DamageSource.field_76380_i) {
            float reduction = (float)(resistance + 1) * 0.2f;
            if (reduction > 1.0f) {
                reduction = 1.0f;
            }
            event.setAmount(event.getAmount() * (1.0f - reduction));
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        NBTTagCompound data = entity.getEntityData();
        if (!data.func_74764_b("eightGatesJumpLevel")) {
            return;
        }
        int jumpLevel = data.func_74762_e("eightGatesJumpLevel");
        if (jumpLevel >= 0) {
            entity.field_70181_x += 0.1 * (double)(jumpLevel + 1);
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        NBTTagCompound data = entity.getEntityData();
        if (!data.func_74764_b("eightGatesJumpLevel")) {
            return;
        }
        int jumpLevel = data.func_74762_e("eightGatesJumpLevel");
        if (jumpLevel >= 0) {
            float reduction = jumpLevel + 1;
            float newDistance = event.getDistance() - reduction;
            if (newDistance < 0.0f) {
                newDistance = 0.0f;
            }
            event.setDistance(newDistance);
        }
    }

    private static boolean handleEightGatePunch(EntityPlayer player, @Nullable EntityLivingBase initialTarget) {
        NBTTagCompound data = player.getEntityData();
        if (data.func_74762_e("eightGatesLevel") != 8) {
            return false;
        }
        int cd = data.func_74762_e("punchCooldown");
        if (cd > 0) {
            return true;
        }
        data.func_74768_a("punchCooldown", 20);
        float attackAttribute = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        float cooldown = player.func_184825_o(0.5f);
        float baseDamage = EightGatesHandler.calculateMeleeDamage(player, initialTarget, attackAttribute, cooldown);
        player.func_184821_cY();
        Vec3d look = player.func_70040_Z().func_72432_b();
        Vec3d start = player.func_174791_d().func_178787_e(new Vec3d(0.0, (double)player.func_70047_e(), 0.0));
        double maxDist = PUNCH_RANGE;
        double step = 0.5;
        HashSet<EntityLivingBase> hit = new HashSet<EntityLivingBase>();
        Vec3d up = new Vec3d(0.0, 1.0, 0.0);
        if (Math.abs(look.func_72430_b(up)) > 0.99) {
            up = new Vec3d(1.0, 0.0, 0.0);
        }
        Vec3d right = up.func_72431_c(look).func_72432_b();
        Vec3d forward = look.func_72431_c(right).func_72432_b();
        for (double d = 1.0; d <= maxDist; d += step) {
            Vec3d pos = start.func_178787_e(new Vec3d(look.field_72450_a * d, look.field_72448_b * d, look.field_72449_c * d));
            if (player.field_70170_p.field_72995_K) {
                int points = 12;
                for (int i = 0; i < points; ++i) {
                    double ang = Math.PI * 2 * (double)i / (double)points;
                    double cos = Math.cos(ang) * PUNCH_RADIUS;
                    double sin = Math.sin(ang) * PUNCH_RADIUS;
                    Vec3d offset = right.func_186678_a(cos).func_178787_e(forward.func_186678_a(sin));
                    player.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, pos.field_72450_a + offset.field_72450_a, pos.field_72448_b + offset.field_72448_b, pos.field_72449_c + offset.field_72449_c, look.field_72450_a * 0.1, look.field_72448_b * 0.1, look.field_72449_c * 0.1, new int[0]);
                }
                continue;
            }
            AxisAlignedBB box = new AxisAlignedBB(pos.field_72450_a - PUNCH_RADIUS, pos.field_72448_b - PUNCH_RADIUS, pos.field_72449_c - PUNCH_RADIUS, pos.field_72450_a + PUNCH_RADIUS, pos.field_72448_b + PUNCH_RADIUS, pos.field_72449_c + PUNCH_RADIUS);
            List entities = player.field_70170_p.func_175647_a(EntityLivingBase.class, box, e -> e != player && !hit.contains(e));
            for (EntityLivingBase target : entities) {
                float damage = target == initialTarget ? baseDamage : EightGatesHandler.calculateMeleeDamage(player, target, attackAttribute, cooldown);
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), damage);
                target.func_70604_c((EntityLivingBase)player);
                if (target instanceof EntityCreature) {
                    ((EntityCreature)target).func_70624_b((EntityLivingBase)player);
                }
                hit.add(target);
            }
        }
        return true;
    }

    private static float calculateMeleeDamage(EntityPlayer player, @Nullable EntityLivingBase target, float attackDamage, float cooldown) {
        boolean isCritical;
        float damage = attackDamage * (0.2f + cooldown * cooldown * 0.8f);
        if (target != null) {
            damage += EnchantmentHelper.func_152377_a((ItemStack)player.func_184614_ca(), (EnumCreatureAttribute)target.func_70668_bt());
        }
        boolean bl = isCritical = cooldown > 0.9f && player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(MobEffects.field_76440_q) && !player.func_184218_aH();
        if (isCritical && target != null) {
            damage *= 1.5f;
        }
        return Math.max(damage, 0.0f);
    }
}

