/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.jutsu.taijutsu;

import com.f1njo.sre.items.jutsu.ItemJutsu;
import com.f1njo.sre.items.jutsu.taijutsu.ITaijutsuRequirement;
import com.f1njo.sre.main.ShinobiTab;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemTaijutsu4
extends ItemJutsu
implements ITaijutsuRequirement {
    private static final int REQUIRED_TAIJUTSU = 150;

    @Override
    public int getRequiredTaijutsu() {
        return 150;
    }

    public ItemTaijutsu4() {
        this.func_77637_a(ShinobiTab.INSTANCE);
        this.func_77625_d(1);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        this.ensureOwner(stack, player);
        if (!this.isOwner(stack, player)) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"tooltip.owner", (Object[])new Object[]{this.getOwnerName(stack)})));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null || stats.getTaijutsu() < 150) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.not_enough_skill", (Object[])new Object[0])));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (this.canUseJutsu(player)) {
            this.performJutsu(world, player);
            if (!world.field_72995_K) {
                this.onJutsuUsed(player);
            }
        } else if (!world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.not_enough_chakra", (Object[])new Object[0])));
        }
        player.func_184609_a(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    protected void performJutsu(World world, EntityPlayer player) {
        Vec3d look = player.func_70040_Z();
        AxisAlignedBB box = player.func_174813_aQ().func_72321_a(look.field_72450_a * 3.0, 0.5, look.field_72449_c * 3.0).func_186662_g(1.5);
        List entities = world.func_72839_b((Entity)player, box);
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLivingBase) || !entity.func_174813_aQ().func_72326_a(box)) continue;
            EntityLivingBase target = (EntityLivingBase)entity;
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 10.0f);
            float sin = MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180)));
            float cos = -MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)));
            target.func_70653_a((Entity)player, 4.0f, (double)sin, (double)cos);
            break;
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)"item.taijutsu4.desc1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.taijutsu4.desc2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tooltip.chakra_cost", (Object[])new Object[]{String.valueOf(this.getChakraCost())}));
    }

    @Override
    protected int getChakraCost() {
        return 25;
    }

    @Override
    protected int getCooldown() {
        return 400;
    }
}

