/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.jutsu.taijutsu;

import com.f1njo.sre.items.jutsu.ItemJutsu;
import com.f1njo.sre.items.jutsu.taijutsu.ITaijutsuRequirement;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemTaijutsu6
extends ItemJutsu
implements ITaijutsuRequirement {
    private static final int REQUIRED_TAIJUTSU = 300;

    @Override
    public int getRequiredTaijutsu() {
        return 300;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        this.ensureOwner(stack, player);
        if (!this.isOwner(stack, player)) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"tooltip.owner", (Object[])new Object[]{this.getOwnerName(stack)})));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null || stats.getTaijutsu() < 300) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.not_enough_skill", (Object[])new Object[0])));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        this.performJutsu(world, player);
        if (!world.field_72995_K) {
            this.onJutsuUsed(player);
        }
        player.func_184609_a(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    protected void performJutsu(World world, EntityPlayer player) {
        Vec3d look = player.func_70040_Z();
        Vec3d start = player.func_174824_e(1.0f);
        double distance = 8.0;
        Vec3d end = start.func_178787_e(look.func_186678_a(distance));
        Entity pointed = null;
        double best = distance;
        AxisAlignedBB search = player.func_174813_aQ().func_72321_a(look.field_72450_a * distance, look.field_72448_b * distance, look.field_72449_c * distance).func_186662_g(1.0);
        List entities = world.func_72839_b((Entity)player, search);
        for (Entity e : entities) {
            double d;
            if (!e.func_70067_L()) continue;
            float border = e.func_70111_Y();
            AxisAlignedBB aabb = e.func_174813_aQ().func_186662_g((double)border);
            RayTraceResult intercept = aabb.func_72327_a(start, end);
            if (intercept == null || !((d = start.func_72438_d(intercept.field_72307_f)) < best)) continue;
            pointed = e;
            best = d;
        }
        if (pointed instanceof EntityLivingBase && (double)player.func_70032_d(pointed) <= 8.0) {
            EntityLivingBase target = (EntityLivingBase)pointed;
            Vec3d dir = new Vec3d(target.field_70165_t - player.field_70165_t, 0.0, target.field_70161_v - player.field_70161_v).func_72432_b();
            if (!world.field_72995_K) {
                player.func_70634_a(target.field_70165_t - dir.field_72450_a, target.func_174813_aQ().field_72338_b, target.field_70161_v - dir.field_72449_c);
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 18.0f);
                target.func_70653_a((Entity)player, 1.5f, player.field_70165_t - target.field_70165_t, player.field_70161_v - target.field_70161_v);
                target.field_70181_x = 0.0;
                target.field_70133_I = true;
            }
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)"item.taijutsu6.desc1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.taijutsu6.desc2", (Object[])new Object[0]));
    }

    @Override
    protected int getChakraCost() {
        return 0;
    }

    @Override
    protected int getCooldown() {
        return 900;
    }
}

