/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.jutsu.taijutsu;

import com.f1njo.sre.chakra.api.IChakra;
import com.f1njo.sre.chakra.impl.ChakraProvider;
import com.f1njo.sre.items.jutsu.ItemJutsu;
import com.f1njo.sre.items.jutsu.taijutsu.ITaijutsuRequirement;
import com.f1njo.sre.main.ShinobiTab;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemTaijutsu7
extends ItemJutsu
implements ITaijutsuRequirement {
    private static int getRequiredTaijutsu(int gate) {
        return 325 + (gate - 1) * 25;
    }

    @Override
    public int getRequiredTaijutsu() {
        return ItemTaijutsu7.getRequiredTaijutsu(1);
    }

    public ItemTaijutsu7() {
        this.func_77637_a(ShinobiTab.INSTANCE);
        this.func_77625_d(1);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        this.ensureOwner(stack, player);
        if (!this.isOwner(stack, player)) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"tooltip.owner", (Object[])new Object[]{this.getOwnerName(stack)})));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        int level = player.getEntityData().func_74762_e("eightGatesLevel");
        if (player.func_70093_af()) {
            if (level > 0 && level < 8) {
                player.getEntityData().func_74768_a("eightGatesLevel", 0);
                player.getEntityData().func_74768_a("eightGatesTime", 0);
                if (!world.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.eightgates.close", (Object[])new Object[0])));
                    player.func_184811_cZ().func_185145_a((Item)this, this.getExitCooldown(level));
                }
            }
            player.func_184609_a(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        int required = ItemTaijutsu7.getRequiredTaijutsu(level + 1);
        if (stats == null || stats.getTaijutsu() < required) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.not_enough_skill", (Object[])new Object[0])));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        this.performJutsu(world, player);
        if (!world.field_72995_K) {
            this.onJutsuUsed(player);
        }
        player.func_184609_a(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    protected void performJutsu(World world, EntityPlayer player) {
        List entities;
        double radius;
        NBTTagCompound data = player.getEntityData();
        int level = data.func_74762_e("eightGatesLevel");
        if (level >= 8) {
            return;
        }
        data.func_74768_a("eightGatesLevel", ++level);
        data.func_74768_a("eightGatesTime", 0);
        if (level == 7 || level == 8) {
            data.func_74768_a("shockwaveProgress", 0);
        }
        if (level == 7) {
            if (!world.field_72995_K) {
                radius = 25.0;
                entities = world.func_72872_a(EntityLivingBase.class, player.func_174813_aQ().func_186662_g(radius));
                for (EntityLivingBase target : entities) {
                    if (target == player) continue;
                    target.func_70653_a((Entity)player, 1.0f, player.field_70165_t - target.field_70165_t, player.field_70161_v - target.field_70161_v);
                }
            } else {
                this.spawnShockwaveParticles(world, player);
            }
        }
        if (level == 8) {
            if (!world.field_72995_K) {
                radius = 25.0;
                entities = world.func_72872_a(EntityLivingBase.class, player.func_174813_aQ().func_186662_g(radius));
                for (EntityLivingBase target : entities) {
                    if (target == player) continue;
                    target.func_70653_a((Entity)player, 2.0f, player.field_70165_t - target.field_70165_t, player.field_70161_v - target.field_70161_v);
                }
            } else {
                this.spawnShockwaveParticles(world, player);
            }
        }
        if (!world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)("message.eightgates.open" + level), (Object[])new Object[0])));
        }
    }

    @Override
    protected void onJutsuUsed(EntityPlayer player) {
        IChakra chakra = (IChakra)player.getCapability(ChakraProvider.CHAKRA_CAP, null);
        if (chakra != null) {
            chakra.consumeChakra(this.getChakraCost());
        }
        if (!player.field_70170_p.field_72995_K) {
            player.func_184811_cZ().func_185145_a((Item)this, this.getCooldown());
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)"item.taijutsu7.desc1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.taijutsu7.desc2", (Object[])new Object[0]));
    }

    @Override
    protected int getChakraCost() {
        return 0;
    }

    @Override
    protected int getCooldown() {
        return 20;
    }

    private void spawnShockwaveParticles(World world, EntityPlayer player) {
        double radius = 25.0;
        int points = 72;
        for (int i = 0; i < points; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)points;
            double x = player.field_70165_t + Math.cos(angle) * radius;
            double z = player.field_70161_v + Math.sin(angle) * radius;
            world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, x, player.field_70163_u + 0.1, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private int getExitCooldown(int level) {
        switch (level) {
            case 1: {
                return 200;
            }
            case 2: {
                return 300;
            }
            case 3: {
                return 500;
            }
            case 4: {
                return 800;
            }
            case 5: {
                return 1200;
            }
            case 6: {
                return 2400;
            }
            case 7: {
                return 4200;
            }
        }
        return this.getCooldown();
    }
}

