/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.jutsu.windrelease;

import com.f1njo.sre.entities.jutsu.windrelease.EntityRasengan;
import com.f1njo.sre.items.jutsu.windrelease.ItemWindJutsuBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemWindJutsu5
extends ItemWindJutsuBase {
    private static final String NBT_OWNER_UUID = "OwnerUUID";
    private static final String NBT_OWNER_NAME = "OwnerName";
    private static final int CHARGE_TIME = 60;

    public int func_77626_a(ItemStack stack) {
        return 60;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        this.ensureOwner(stack, player);
        if (!this.isOwner(stack, player)) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"tooltip.owner", (Object[])new Object[]{this.getOwnerName(stack)})));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (!this.hasRequiredElement(player)) {
            if (!world.field_72995_K) {
                TextComponentString missMsg = new TextComponentString(I18n.func_135052_a((String)"message.missing_element", (Object[])new Object[]{String.valueOf((Object)this.getRequiredElement())}));
                missMsg.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)missMsg);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (this.canUseJutsu(player)) {
            player.func_184598_c(hand);
        } else if (!world.field_72995_K) {
            TextComponentString chakraMsg = new TextComponentString(I18n.func_135052_a((String)"message.not_enough_chakra", (Object[])new Object[0]));
            chakraMsg.func_150256_b().func_150238_a(TextFormatting.RED);
            player.func_145747_a((ITextComponent)chakraMsg);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (!world.field_72995_K && entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (!this.hasRequiredElement(player)) {
                TextComponentString missMsg2 = new TextComponentString(I18n.func_135052_a((String)"message.missing_element", (Object[])new Object[]{String.valueOf((Object)this.getRequiredElement())}));
                missMsg2.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)missMsg2);
            } else if (this.canUseJutsu(player)) {
                this.performJutsu(world, player);
                this.onJutsuUsed(player);
            } else {
                TextComponentString chakraMsg2 = new TextComponentString(I18n.func_135052_a((String)"message.not_enough_chakra", (Object[])new Object[0]));
                chakraMsg2.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)chakraMsg2);
            }
        }
        return stack;
    }

    @Override
    protected void performJutsu(World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            EntityRasengan r = new EntityRasengan(world, player);
            Vec3d look = player.func_70040_Z();
            Vec3d right = look.func_72431_c(new Vec3d(0.0, 1.0, 0.0)).func_72432_b();
            double x = player.field_70165_t + right.field_72450_a * 0.4 + look.field_72450_a * 0.4;
            double y = player.field_70163_u + (double)player.func_70047_e() - 0.9 + look.field_72448_b * 0.2;
            double z = player.field_70161_v + right.field_72449_c * 0.4 + look.field_72449_c * 0.4;
            r.func_70107_b(x, y, z);
            world.func_72838_d((Entity)r);
            player.getEntityData().func_74768_a("RasenganID", r.func_145782_y());
        }
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayer) {
            int id;
            Entity e;
            EntityPlayer player = (EntityPlayer)attacker;
            if (!player.field_70170_p.field_72995_K && player.getEntityData().func_74764_b("RasenganID") && (e = player.field_70170_p.func_73045_a(id = player.getEntityData().func_74762_e("RasenganID"))) instanceof EntityRasengan) {
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 50.0f);
                float sin = MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180)));
                float cos = -MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)));
                target.func_70653_a((Entity)player, 5.0f, (double)sin, (double)cos);
                ((EntityRasengan)e).expire();
                return true;
            }
        }
        return super.func_77644_a(stack, target, attacker);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)"item.wind_jutsu_5.desc1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.wind_jutsu_5.desc2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tooltip.chakra_cost", (Object[])new Object[]{String.valueOf(this.getChakraCost())}));
    }

    @Override
    protected int getChakraCost() {
        return 150;
    }

    @Override
    protected int getRequiredMastery() {
        return 80;
    }

    @Override
    public String getJutsuName() {
        return super.getJutsuName();
    }

    @Override
    protected int getCooldown() {
        return 1200;
    }

    @Override
    protected void ensureOwner(ItemStack stack, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_186854_a(NBT_OWNER_UUID, player.func_110124_au());
            tag.func_74778_a(NBT_OWNER_NAME, player.func_70005_c_());
            stack.func_77982_d(tag);
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_186855_b(NBT_OWNER_UUID)) {
            tag.func_186854_a(NBT_OWNER_UUID, player.func_110124_au());
            tag.func_74778_a(NBT_OWNER_NAME, player.func_70005_c_());
        }
    }

    @Override
    protected boolean isOwner(ItemStack stack, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_186855_b(NBT_OWNER_UUID)) {
            return false;
        }
        return tag.func_186857_a(NBT_OWNER_UUID).equals(player.func_110124_au());
    }

    @Override
    protected String getOwnerName(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_OWNER_NAME)) {
            return stack.func_77978_p().func_74779_i(NBT_OWNER_NAME);
        }
        return "-";
    }
}

