/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.misc;

import com.f1njo.sre.core.ModItems;
import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.Element;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDNA
extends Item {
    private static final String KEY_IDENTIFIED = "Identified";
    private static final String KEY_ELEMENT = "Element";
    private static final String KEY_DAMAGED = "Damaged";

    public ItemDNA() {
        this.func_77637_a(null);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        EnumActionResult result = EnumActionResult.SUCCESS;
        if (this.isDamaged(stack)) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.dna.damaged", (Object[])new Object[0])));
            }
            result = EnumActionResult.FAIL;
        } else if (!this.isIdentified(stack)) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.dna.requires_scholars_desk", (Object[])new Object[0])));
            }
            result = EnumActionResult.FAIL;
        } else if (!world.field_72995_K) {
            Element element = this.getElement(stack);
            if (element == null) {
                result = EnumActionResult.FAIL;
            } else {
                IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
                if (stats == null) {
                    result = EnumActionResult.FAIL;
                } else if (stats.hasElement(element)) {
                    player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.dna.already_has", (Object[])new Object[]{element.name()})));
                    result = EnumActionResult.FAIL;
                } else {
                    ItemStack reward;
                    stats.addElement(element);
                    player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.element_gain", (Object[])new Object[]{element.name()})));
                    Item scroll = this.getScrollForElement(element);
                    if (scroll != null && !player.field_71071_by.func_70441_a(reward = new ItemStack(scroll))) {
                        player.func_71019_a(reward, false);
                    }
                    if (player instanceof EntityPlayerMP) {
                        ModNetwork.sendTo(new MessageSyncStats(stats), (EntityPlayerMP)player);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                }
            }
        }
        return new ActionResult(result, (Object)stack);
    }

    public void identify(ItemStack stack, Element element) {
        NBTTagCompound tag = stack.func_190925_c("dnaData");
        tag.func_74757_a(KEY_IDENTIFIED, true);
        tag.func_74778_a(KEY_ELEMENT, element.name());
        tag.func_74757_a(KEY_DAMAGED, false);
    }

    public void markDamaged(ItemStack stack) {
        NBTTagCompound tag = stack.func_190925_c("dnaData");
        tag.func_74757_a(KEY_IDENTIFIED, false);
        tag.func_74757_a(KEY_DAMAGED, true);
        tag.func_82580_o(KEY_ELEMENT);
    }

    public boolean isIdentified(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("dnaData");
        return tag != null && tag.func_74767_n(KEY_IDENTIFIED);
    }

    public boolean isDamaged(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("dnaData");
        return tag != null && tag.func_74767_n(KEY_DAMAGED);
    }

    public boolean isProcessed(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("dnaData");
        return tag != null && (tag.func_74767_n(KEY_IDENTIFIED) || tag.func_74767_n(KEY_DAMAGED));
    }

    public Element getElement(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("dnaData");
        if (tag == null || tag.func_74767_n(KEY_DAMAGED)) {
            return null;
        }
        String name = tag.func_74779_i(KEY_ELEMENT);
        try {
            return Element.valueOf(name);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    private Item getScrollForElement(Element element) {
        switch (element) {
            case FIRE: {
                return ModItems.FIRE_SCROLL;
            }
            case WIND: {
                return ModItems.WIND_SCROLL;
            }
            case LIGHTNING: {
                return ModItems.LIGHTNING_SCROLL;
            }
            case EARTH: {
                return ModItems.EARTH_SCROLL;
            }
            case WATER: {
                return ModItems.WATER_SCROLL;
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        if (this.isDamaged(stack)) {
            return I18n.func_135052_a((String)"item.dna.damaged.name", (Object[])new Object[0]);
        }
        if (!this.isIdentified(stack)) {
            return I18n.func_135052_a((String)"item.dna.unidentified.name", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"item.dna.name", (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.isDamaged(stack)) {
            tooltip.add(I18n.func_135052_a((String)"item.dna.description.damaged", (Object[])new Object[0]));
            return;
        }
        if (!this.isIdentified(stack)) {
            tooltip.add(I18n.func_135052_a((String)"item.dna.description.unidentified", (Object[])new Object[0]));
            return;
        }
        Element element = this.getElement(stack);
        if (element != null) {
            tooltip.add(I18n.func_135052_a((String)("item.dna.description." + element.name().toLowerCase()), (Object[])new Object[0]));
        }
    }
}

