/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.misc;

import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.missions.DRankMission;
import com.f1njo.sre.missions.MissionRank;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemDRankMissionScroll
extends Item {
    private static final String TAG_MISSION_ID = "DRankMissionId";
    private static final String TAG_MISSION_AMOUNT = "DRankMissionAmount";

    public ItemDRankMissionScroll() {
        this.func_77637_a(null);
        this.func_77625_d(64);
    }

    public int getItemStackLimit(ItemStack stack) {
        return ItemDRankMissionScroll.hasMission(stack) ? 1 : super.getItemStackLimit(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!ItemDRankMissionScroll.hasMission(stack)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        int missionId = ItemDRankMissionScroll.getMissionId(stack);
        int requiredAmount = ItemDRankMissionScroll.getMissionAmount(stack);
        DRankMission mission = DRankMission.getById(missionId);
        if (mission == null) {
            ItemDRankMissionScroll.clearMission(stack);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (requiredAmount <= 0) {
            requiredAmount = mission.getRandomAmount(world.field_73012_v);
            ItemDRankMissionScroll.setMission(stack, mission.getId(), requiredAmount);
        }
        boolean completed = mission.isCompleted(player, requiredAmount);
        if (!world.field_72995_K && completed) {
            int reward = 25 + world.field_73012_v.nextInt(26);
            IPlayerStats stats = PlayerStatsProvider.get(player);
            if (stats != null && player instanceof EntityPlayerMP) {
                stats.addExp(reward, (EntityPlayerMP)player);
                stats.setMissionCount(MissionRank.D, stats.getMissionCount(MissionRank.D) + 1);
                ModNetwork.sendTo(new MessageSyncStats(stats), (EntityPlayerMP)player);
            }
            mission.consumeItems(player, requiredAmount);
            ItemDRankMissionScroll.clearMission(stack);
            stack.func_190918_g(1);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(completed ? EnumActionResult.SUCCESS : EnumActionResult.FAIL, (Object)stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!ItemDRankMissionScroll.hasMission(stack)) {
            tooltip.add(I18n.func_135052_a((String)"item.mission_scroll.read", (Object[])new Object[0]));
            return;
        }
        DRankMission mission = DRankMission.getById(ItemDRankMissionScroll.getMissionId(stack));
        if (mission != null) {
            int requiredAmount = ItemDRankMissionScroll.getMissionAmount(stack);
            tooltip.add(I18n.func_135052_a((String)"tooltip.d_rank_mission_scroll.title", (Object[])new Object[]{I18n.func_135052_a((String)mission.getTitle(), (Object[])new Object[]{requiredAmount})}));
            tooltip.add(I18n.func_135052_a((String)"tooltip.d_rank_mission_scroll.description", (Object[])new Object[]{I18n.func_135052_a((String)mission.getDescription(), (Object[])new Object[]{requiredAmount})}));
        }
    }

    public int func_77626_a(ItemStack stack) {
        return ItemDRankMissionScroll.hasMission(stack) ? 0 : 60;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        DRankMission mission;
        if (!(entityLiving instanceof EntityPlayer) || ItemDRankMissionScroll.hasMission(stack)) {
            return stack;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        if (!worldIn.field_72995_K && (mission = DRankMission.getRandom(worldIn.field_73012_v)) != null) {
            int requiredAmount = mission.getRandomAmount(worldIn.field_73012_v);
            if (player.field_71075_bZ.field_75098_d || stack.func_190916_E() <= 1) {
                ItemDRankMissionScroll.setMission(stack, mission.getId(), requiredAmount);
                mission.onAssigned(player, requiredAmount);
            } else {
                ItemStack missionStack = stack.func_77946_l();
                missionStack.func_190920_e(1);
                ItemDRankMissionScroll.setMission(missionStack, mission.getId(), requiredAmount);
                mission.onAssigned(player, requiredAmount);
                stack.func_190918_g(1);
                if (!player.func_191521_c(missionStack)) {
                    player.func_71019_a(missionStack, false);
                }
            }
        }
        return stack;
    }

    private static NBTTagCompound getOrCreateTag(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag;
    }

    private static boolean hasMission(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_74764_b(TAG_MISSION_ID) && tag.func_74764_b(TAG_MISSION_AMOUNT);
    }

    private static void setMission(ItemStack stack, int id, int amount) {
        NBTTagCompound tag = ItemDRankMissionScroll.getOrCreateTag(stack);
        tag.func_74768_a(TAG_MISSION_ID, id);
        tag.func_74768_a(TAG_MISSION_AMOUNT, amount);
    }

    private static int getMissionId(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null ? tag.func_74762_e(TAG_MISSION_ID) : -1;
    }

    private static int getMissionAmount(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null ? tag.func_74762_e(TAG_MISSION_AMOUNT) : 0;
    }

    private static void clearMission(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            tag.func_82580_o(TAG_MISSION_ID);
            tag.func_82580_o(TAG_MISSION_AMOUNT);
        }
    }
}

