/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.misc;

import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.items.jutsu.ItemJutsu;
import com.f1njo.sre.items.jutsu.taijutsu.ITaijutsuRequirement;
import com.f1njo.sre.items.misc.ItemTaijutsuScroll;
import com.f1njo.sre.main.ShinobiTab;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemElementScroll
extends Item {
    private final Item[] jutsuItems;
    private static final int[] LEVEL_REQUIREMENTS = new int[]{50, 150, 250, 350, 500};
    private static final int SP_COST = 25;

    public ItemElementScroll(Item[] jutsuItems) {
        this.jutsuItems = jutsuItems;
        this.func_77637_a(ShinobiTab.INSTANCE);
        this.func_77625_d(1);
        this.func_77656_e(jutsuItems.length);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        int stage;
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && (stage = stack.func_77952_i()) < this.jutsuItems.length) {
            ItemStack reward;
            Item item = this.jutsuItems[stage];
            IPlayerStats stats = (IPlayerStats)playerIn.getCapability(PlayerStatsProvider.STATS_CAP, null);
            if (this instanceof ItemTaijutsuScroll) {
                ITaijutsuRequirement req;
                int requiredTaijutsu;
                int taijutsu;
                if (item instanceof ITaijutsuRequirement && (taijutsu = stats != null ? stats.getTaijutsu() : 0) < (requiredTaijutsu = (req = (ITaijutsuRequirement)item).getRequiredTaijutsu())) {
                    TextComponentString msg = new TextComponentString(I18n.func_135052_a((String)"message.not_enough_skill", (Object[])new Object[0]));
                    msg.func_150256_b().func_150238_a(TextFormatting.RED);
                    playerIn.func_145747_a((ITextComponent)msg);
                    return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                }
            } else {
                int requiredLevel;
                int level = stats != null ? stats.getLevel() : 0;
                int n = requiredLevel = stage < LEVEL_REQUIREMENTS.length ? LEVEL_REQUIREMENTS[stage] : 0;
                if (level < requiredLevel) {
                    TextComponentString lvlMsg = new TextComponentString(I18n.func_135052_a((String)"message.not_enough_level", (Object[])new Object[]{requiredLevel}));
                    lvlMsg.func_150256_b().func_150238_a(TextFormatting.RED);
                    playerIn.func_145747_a((ITextComponent)lvlMsg);
                    return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                }
            }
            if (stats == null || stats.getSkillPoints() < 25) {
                TextComponentString spMsg = new TextComponentString(I18n.func_135052_a((String)"message.not_enough_sp", (Object[])new Object[]{25}));
                spMsg.func_150256_b().func_150238_a(TextFormatting.RED);
                playerIn.func_145747_a((ITextComponent)spMsg);
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            stats.setSkillPoints(stats.getSkillPoints() - 25);
            if (playerIn instanceof EntityPlayerMP) {
                ModNetwork.sendTo(new MessageSyncStats(stats), (EntityPlayerMP)playerIn);
            }
            if (!playerIn.field_71071_by.func_70441_a(reward = new ItemStack(item))) {
                playerIn.func_71019_a(reward, false);
            }
            String name = item instanceof ItemJutsu ? ((ItemJutsu)item).getJutsuName() : reward.func_82833_r();
            TextComponentString learnedMsg = new TextComponentString(I18n.func_135052_a((String)"message.element_scroll.learned", (Object[])new Object[]{name}));
            learnedMsg.func_150256_b().func_150238_a(TextFormatting.YELLOW);
            playerIn.func_145747_a((ITextComponent)learnedMsg);
            stack.func_77972_a(1, (EntityLivingBase)playerIn);
            if (!playerIn.field_71075_bZ.field_75098_d && stage + 1 >= this.jutsuItems.length) {
                stack.func_190918_g(1);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

