/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.misc;

import com.f1njo.sre.core.ModItems;
import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.Clan;
import com.f1njo.sre.stats.Element;
import com.f1njo.sre.stats.ElementRandomizer;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.Locations;
import com.f1njo.sre.stats.PlayerStatsProvider;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemInfoScroll
extends Item {
    public ItemInfoScroll() {
        this.func_77637_a(null);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats != null && stats.isShinobi()) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (stats != null) {
            stats.setShinobi(true);
            player.getEntityData().func_74778_a("shinobi", "1");
        }
        if (!world.field_72995_K && stats != null) {
            Clan[] clans = Clan.values();
            Locations[] locations = Locations.values();
            Clan clan = clans[1 + world.field_73012_v.nextInt(clans.length - 1)];
            Locations location = locations[1 + world.field_73012_v.nextInt(locations.length - 1)];
            stats.setClan(clan);
            stats.setLocation(location);
            this.giveClanScroll(player, clan);
            for (Element element : ElementRandomizer.getRandomElements(clan, world.field_73012_v)) {
                stats.addElement(element);
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.element_gain", (Object[])new Object[]{element.name()})));
                Item scroll = this.getScrollForElement(element);
                if (scroll == null) continue;
                ItemStack reward = new ItemStack(scroll);
                if (!player.field_71071_by.func_70441_a(reward)) {
                    player.func_71019_a(reward, false);
                }
                String string = element.name().substring(0, 1) + element.name().substring(1).toLowerCase();
            }
            ModNetwork.sendTo(new MessageSyncStats(stats), (EntityPlayerMP)player);
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.info_scroll.gain", (Object[])new Object[0])));
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private void giveClanScroll(EntityPlayer player, Clan clan) {
        ItemStack reward;
        Item scroll = this.getScrollForClan(clan);
        if (scroll != null && !player.field_71071_by.func_70441_a(reward = new ItemStack(scroll))) {
            player.func_71019_a(reward, false);
        }
    }

    private Item getScrollForClan(Clan clan) {
        switch (clan) {
            case UCHIHA: {
                return ModItems.SHARINGAN_SCROLL;
            }
            case HYUGA: 
            case OTSUTSUKI: {
                return ModItems.BYAKUGAN_SCROLL;
            }
        }
        return null;
    }

    private Item getScrollForElement(Element element) {
        switch (element) {
            case FIRE: {
                return ModItems.FIRE_SCROLL;
            }
            case WIND: {
                return ModItems.WIND_SCROLL;
            }
            case LIGHTNING: {
                return ModItems.LIGHTNING_SCROLL;
            }
            case EARTH: {
                return ModItems.EARTH_SCROLL;
            }
            case WATER: {
                return ModItems.WATER_SCROLL;
            }
        }
        return null;
    }
}

