/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.misc;

import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.main.ShinobiTab;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemIntelligenceScroll
extends Item {
    private final int min;
    private final int max;
    private final int cooldown;

    public ItemIntelligenceScroll(int min, int max, int cooldown) {
        this.min = min;
        this.max = max;
        this.cooldown = cooldown;
        this.func_77637_a(ShinobiTab.INSTANCE);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        IPlayerStats stats;
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_184811_cZ().func_185141_a((Item)this)) {
            if (!worldIn.field_72995_K) {
                TextComponentTranslation cdMsg = new TextComponentTranslation("message.intelligence_scroll.cooldown", new Object[0]);
                cdMsg.func_150256_b().func_150238_a(TextFormatting.RED);
                playerIn.func_145747_a((ITextComponent)cdMsg);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (!worldIn.field_72995_K && (stats = (IPlayerStats)playerIn.getCapability(PlayerStatsProvider.STATS_CAP, null)) != null) {
            int intel = stats.getIntelligence();
            if (intel < this.min) {
                TextComponentTranslation lowMsg = new TextComponentTranslation("message.intelligence_scroll.low", new Object[0]);
                lowMsg.func_150256_b().func_150238_a(TextFormatting.RED);
                playerIn.func_145747_a((ITextComponent)lowMsg);
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            if (intel >= this.max) {
                TextComponentTranslation highMsg = new TextComponentTranslation("message.intelligence_scroll.high", new Object[0]);
                highMsg.func_150256_b().func_150238_a(TextFormatting.RED);
                playerIn.func_145747_a((ITextComponent)highMsg);
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
        }
        int duration = this.func_77626_a(stack);
        playerIn.getEntityData().func_74757_a("intelligenceReading", true);
        playerIn.getEntityData().func_74772_a("intelligenceStart", System.currentTimeMillis());
        playerIn.getEntityData().func_74768_a("intelligenceDuration", duration);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public int func_77626_a(ItemStack stack) {
        return 300;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            entityLiving.getEntityData().func_74757_a("intelligenceReading", false);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        int intel;
        EntityPlayer player;
        IPlayerStats stats;
        if (entityLiving instanceof EntityPlayer) {
            entityLiving.getEntityData().func_74757_a("intelligenceReading", false);
        }
        if (!worldIn.field_72995_K && entityLiving instanceof EntityPlayer && (stats = (IPlayerStats)(player = (EntityPlayer)entityLiving).getCapability(PlayerStatsProvider.STATS_CAP, null)) != null && (intel = stats.getIntelligence()) >= this.min && intel < this.max) {
            stats.setIntelligence(intel + 1);
            if (player instanceof EntityPlayerMP) {
                ModNetwork.sendTo(new MessageSyncStats(stats), (EntityPlayerMP)player);
            }
            player.func_184811_cZ().func_185145_a((Item)this, this.cooldown);
            TextComponentTranslation gainMsg = new TextComponentTranslation("message.intelligence_gain", new Object[0]);
            gainMsg.func_150256_b().func_150238_a(TextFormatting.YELLOW);
            player.func_145747_a((ITextComponent)gainMsg);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        return stack;
    }
}

