/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.weapon;

import com.f1njo.sre.entities.weapon.EntityThrownFumaShuriken;
import com.f1njo.sre.items.weapon.BukijutsuWeaponUtil;
import com.f1njo.sre.items.weapon.IBukijutsuWeapon;
import com.f1njo.sre.main.ShinobiTab;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemFumaShuriken
extends Item
implements IBukijutsuWeapon {
    private static final int REQUIRED_BUKIJUTSU = 90;
    private static final float ATTACK_DAMAGE = 6.0f;
    private static final float ATTACK_SPEED = -2.6f;
    private static final int REQUIRED_SHURIKENJUTSU = 80;

    public ItemFumaShuriken() {
        this.func_77637_a(ShinobiTab.INSTANCE);
        this.func_77625_d(1);
        this.func_77656_e(300);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap modifiers = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            modifiers.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 6.0, 0));
            modifiers.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.6f, 0));
        }
        return modifiers;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        int shurikenjutsu;
        ItemStack stack = playerIn.func_184586_b(handIn);
        IPlayerStats stats = (IPlayerStats)playerIn.getCapability(PlayerStatsProvider.STATS_CAP, null);
        int n = shurikenjutsu = stats != null ? stats.getShurikenjutsu() : 0;
        if (shurikenjutsu < 80) {
            if (!worldIn.field_72995_K) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.cant_throw", (Object[])new Object[0])));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (!playerIn.field_71075_bZ.field_75098_d) {
            stack.func_77972_a(1, (EntityLivingBase)playerIn);
        }
        worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 0.6f, 0.9f);
        if (!worldIn.field_72995_K) {
            EntityThrownFumaShuriken fuma = new EntityThrownFumaShuriken(worldIn, (EntityLivingBase)playerIn);
            float velocity = 1.8f + (float)shurikenjutsu / 120.0f;
            fuma.func_184538_a((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, velocity, 0.35f);
            worldIn.func_72838_d((Entity)fuma);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String key;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        BukijutsuWeaponUtil.addBukijutsuRequirementTooltip(tooltip, 90);
        int i = 1;
        while (I18n.func_188566_a((String)(key = "item.fuma_shuriken.desc" + i))) {
            tooltip.add(I18n.func_135052_a((String)key, (Object[])new Object[0]));
            ++i;
        }
    }

    @Override
    public int getRequiredBukijutsu() {
        return 90;
    }
}

