/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.weapon;

import com.f1njo.sre.entities.weapon.EntityThrownKunai;
import com.f1njo.sre.items.weapon.IBukijutsuWeapon;
import com.f1njo.sre.main.ShinobiTab;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class ItemKunai
extends Item
implements IBukijutsuWeapon {
    private static final int REQUIRED_BUKIJUTSU = 25;
    private final float attackDamage = 4.0f;
    private final float attackSpeed = -2.4f;

    public ItemKunai() {
        this.func_77637_a(ShinobiTab.INSTANCE);
        this.func_77625_d(16);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 4.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        int shurikenjutsu = stats != null ? stats.getShurikenjutsu() : 0;
        int required = 15;
        if (shurikenjutsu < 15) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.cant_throw", (Object[])new Object[0])));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        if (!world.field_72995_K) {
            EntityThrownKunai kunai = new EntityThrownKunai(world, (EntityLivingBase)player);
            float velocity = 1.5f + (float)shurikenjutsu / 50.0f;
            kunai.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, velocity, 1.0f);
            world.func_72838_d((Entity)kunai);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)"item.kunai.desc1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.kunai.desc2", (Object[])new Object[0]));
    }

    @Override
    public int getRequiredBukijutsu() {
        return 25;
    }
}

