/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.missions;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public enum DRankMission {
    COBBLESTONE(0, "mission.d.cobblestone.title", "mission.d.cobblestone.desc", Item.func_150898_a((Block)Blocks.field_150347_e), 12, 64),
    WHEAT(1, "mission.d.wheat.title", "mission.d.wheat.desc", Items.field_151015_O, 4, 24),
    FISHING(2, "mission.d.fishing.title", "mission.d.fishing.desc", Items.field_151115_aP, 4, 8),
    EGGS(3, "mission.d.eggs.title", "mission.d.eggs.desc", Items.field_151110_aK, 3, 12),
    MUSHROOMS(4, "mission.d.mushrooms.title", "mission.d.mushrooms.desc", Item.func_150898_a((Block)Blocks.field_150338_P), 6, 12),
    MUSHROOM_SOUP(5, "mission.d.mushroom_soup.title", "mission.d.mushroom_soup.desc", Items.field_151009_A, 1, 3),
    PAPER(6, "mission.d.paper.title", "mission.d.paper.desc", Items.field_151121_aF, 6, 12),
    SUGAR(7, "mission.d.sugar.title", "mission.d.sugar.desc", Items.field_151102_aT, 12, 20),
    FEATHERS(8, "mission.d.feathers.title", "mission.d.feathers.desc", Items.field_151008_G, 2, 8),
    PLANKS(9, "mission.d.planks.title", "mission.d.planks.desc", Item.func_150898_a((Block)Blocks.field_150344_f), 12, 64),
    WHEAT_SEEDS(10, "mission.d.wheat_seeds.title", "mission.d.wheat_seeds.desc", Items.field_151014_N, 16, 32),
    CLAY(11, "mission.d.clay.title", "mission.d.clay.desc", Items.field_151119_aD, 4, 12),
    BRICKS(12, "mission.d.bricks.title", "mission.d.bricks.desc", Items.field_151118_aC, 12, 24),
    MILK(13, "mission.d.milk.title", "mission.d.milk.desc", Items.field_151117_aB, 1, 1){

        @Override
        public void onAssigned(EntityPlayer player, int requiredAmount) {
            ItemStack bucket = new ItemStack(Items.field_151133_ar);
            if (!player.field_71071_by.func_70441_a(bucket)) {
                player.func_71019_a(bucket, false);
            }
        }
    };

    private final int id;
    private final String title;
    private final String description;
    private final Item requiredItem;
    private final int minAmount;
    private final int maxAmount;

    private DRankMission(int id, String title, String description, Item requiredItem, int minAmount, int maxAmount) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.requiredItem = requiredItem;
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
    }

    public int getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public void onAssigned(EntityPlayer player, int requiredAmount) {
    }

    public boolean isCompleted(EntityPlayer player, int requiredAmount) {
        if (this.requiredItem == null) {
            return false;
        }
        return this.countItems(player, this.requiredItem) >= requiredAmount;
    }

    public void consumeItems(EntityPlayer player, int requiredAmount) {
        if (this.requiredItem == null || requiredAmount <= 0) {
            return;
        }
        int remaining = this.removeFromList((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, this.requiredItem, requiredAmount);
        if (remaining > 0) {
            this.removeFromList((NonNullList<ItemStack>)player.field_71071_by.field_184439_c, this.requiredItem, remaining);
        }
    }

    private int removeFromList(NonNullList<ItemStack> list, Item target, int amountToRemove) {
        int remaining = amountToRemove;
        for (int i = 0; i < list.size() && remaining > 0; ++i) {
            ItemStack stack = (ItemStack)list.get(i);
            if (stack.func_190926_b() || stack.func_77973_b() != target) continue;
            int remove = Math.min(remaining, stack.func_190916_E());
            stack.func_190918_g(remove);
            if (stack.func_190916_E() <= 0) {
                list.set(i, (Object)ItemStack.field_190927_a);
            }
            remaining -= remove;
        }
        return remaining;
    }

    private int countItems(EntityPlayer player, Item target) {
        int total = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || stack.func_77973_b() != target) continue;
            total += stack.func_190916_E();
        }
        for (ItemStack stack : player.field_71071_by.field_184439_c) {
            if (stack.func_190926_b() || stack.func_77973_b() != target) continue;
            total += stack.func_190916_E();
        }
        return total;
    }

    public int getRandomAmount(Random random) {
        if (this.maxAmount <= this.minAmount) {
            return this.minAmount;
        }
        return this.minAmount + random.nextInt(this.maxAmount - this.minAmount + 1);
    }

    public static DRankMission getById(int id) {
        for (DRankMission mission : DRankMission.values()) {
            if (mission.id != id) continue;
            return mission;
        }
        return null;
    }

    public static DRankMission getRandom(Random random) {
        DRankMission[] missions = DRankMission.values();
        if (missions.length == 0) {
            return null;
        }
        return missions[random.nextInt(missions.length)];
    }
}

