/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.network.chakra;

import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageGainChakraControl
implements IMessage {
    private int amount;

    public MessageGainChakraControl() {
    }

    public MessageGainChakraControl(int amount) {
        this.amount = amount;
    }

    public void fromBytes(ByteBuf buf) {
        this.amount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.amount);
    }

    public static class Handler
    implements IMessageHandler<MessageGainChakraControl, IMessage> {
        public IMessage onMessage(MessageGainChakraControl message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                IPlayerStats stats = PlayerStatsProvider.get((EntityPlayer)player);
                if (stats != null) {
                    int nextLevel;
                    int requirement;
                    int progress = player.getEntityData().func_74762_e("chakraControlProgress");
                    progress += message.amount;
                    while (stats.getChakraControl() < 100 && progress >= (requirement = Handler.getChakraRequirement(nextLevel = stats.getChakraControl() + 1))) {
                        progress -= requirement;
                        stats.setChakraControl(nextLevel);
                        ModNetwork.sendTo(new MessageSyncStats(stats), player);
                    }
                    player.getEntityData().func_74768_a("chakraControlProgress", progress);
                }
            });
            return null;
        }

        private static int getChakraRequirement(int level) {
            if (level <= 5) {
                return 50;
            }
            if (level <= 10) {
                return 75;
            }
            if (level <= 15) {
                return 100;
            }
            if (level <= 20) {
                return 125;
            }
            if (level <= 25) {
                return 150;
            }
            if (level <= 50) {
                return 250;
            }
            if (level <= 75) {
                return 350;
            }
            if (level <= 85) {
                return 500;
            }
            if (level <= 90) {
                return 1000;
            }
            if (level <= 95) {
                return 2000;
            }
            return 7500;
        }
    }
}

