/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.network.jutsu;

import com.f1njo.sre.chakra.api.IChakra;
import com.f1njo.sre.chakra.impl.ChakraProvider;
import com.f1njo.sre.entities.misc.EntitySummonSign;
import com.f1njo.sre.entities.npc.SummonBeast;
import com.f1njo.sre.stats.IOwnedSummon;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSummonCompanion
implements IMessage {
    public void toBytes(ByteBuf buf) {
    }

    public void fromBytes(ByteBuf buf) {
    }

    public static class Handler
    implements IMessageHandler<MessageSummonCompanion, IMessage> {
        private static final double SEARCH_RADIUS = 64.0;
        private static final int SUMMON_DELAY_TICKS = 60;

        public IMessage onMessage(MessageSummonCompanion message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                IPlayerStats stats = PlayerStatsProvider.get((EntityPlayer)player);
                if (stats == null) {
                    return;
                }
                if (stats.getKuchiyose() < 100) {
                    TextComponentString warn = new TextComponentString(I18n.func_135052_a((String)"message.summon.requirement", (Object[])new Object[]{100}));
                    warn.func_150256_b().func_150238_a(TextFormatting.RED);
                    player.func_145747_a((ITextComponent)warn);
                    return;
                }
                SummonBeast beast = stats.getSummonBeast();
                if (beast == null) {
                    TextComponentString warn = new TextComponentString(I18n.func_135052_a((String)"message.summon.none", (Object[])new Object[0]));
                    warn.func_150256_b().func_150238_a(TextFormatting.RED);
                    player.func_145747_a((ITextComponent)warn);
                    return;
                }
                IChakra chakra = (IChakra)player.getCapability(ChakraProvider.CHAKRA_CAP, null);
                int chakraCost = beast.getChakraCost();
                if (chakra == null || chakra.getChakra() < chakraCost) {
                    TextComponentString warn = new TextComponentString(I18n.func_135052_a((String)"message.not_enough_chakra", (Object[])new Object[0]));
                    warn.func_150256_b().func_150238_a(TextFormatting.RED);
                    player.func_145747_a((ITextComponent)warn);
                    return;
                }
                ResourceLocation entityId = beast.getEntityId();
                AxisAlignedBB searchBox = player.func_174813_aQ().func_186662_g(64.0);
                List existing = player.field_70170_p.func_72872_a(beast.getEntityClass(), searchBox);
                boolean alreadySummoned = false;
                for (EntityLiving entity : existing) {
                    if (entity.field_70128_L) continue;
                    if (beast.isOwnerBound()) {
                        if (entity instanceof IOwnedSummon) {
                            UUID ownerId = ((IOwnedSummon)entity).getOwnerId();
                            if (ownerId == null || !ownerId.equals(player.func_110124_au())) continue;
                            alreadySummoned = true;
                            break;
                        }
                        alreadySummoned = true;
                        break;
                    }
                    alreadySummoned = true;
                    break;
                }
                if (alreadySummoned) {
                    TextComponentString warn = new TextComponentString(I18n.func_135052_a((String)"message.summon.already_active", (Object[])new Object[0]));
                    warn.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                    player.func_145747_a((ITextComponent)warn);
                    return;
                }
                List signs = player.field_70170_p.func_72872_a(EntitySummonSign.class, searchBox);
                boolean summonPending = false;
                for (EntitySummonSign sign : signs) {
                    if (!sign.isSummonPendingFor(player.func_110124_au())) continue;
                    summonPending = true;
                    break;
                }
                if (summonPending) {
                    TextComponentString warn = new TextComponentString(I18n.func_135052_a((String)"message.summon.already_active", (Object[])new Object[0]));
                    warn.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                    player.func_145747_a((ITextComponent)warn);
                    return;
                }
                EntitySummonSign sign = new EntitySummonSign(player.field_70170_p);
                sign.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                UUID ownerId = beast.isOwnerBound() ? player.func_110124_au() : null;
                sign.prepareSummon(entityId, ownerId, player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A, 60);
                if (player.field_70170_p.func_72838_d((Entity)sign)) {
                    chakra.consumeChakra(chakraCost);
                    TextComponentString success = new TextComponentString(I18n.func_135052_a((String)"message.summon.success", (Object[])new Object[]{beast.getDisplayName()}));
                    success.func_150256_b().func_150238_a(TextFormatting.DARK_PURPLE);
                    player.func_145747_a((ITextComponent)success);
                }
            });
            return null;
        }
    }
}

