/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.network.stats;

import com.f1njo.sre.chakra.api.IChakra;
import com.f1njo.sre.chakra.handler.ChakraHandler;
import com.f1njo.sre.chakra.impl.ChakraProvider;
import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.network.chakra.MessageSyncChakra;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageIncreaseNinjutsu
implements IMessage {
    private int amount;

    public MessageIncreaseNinjutsu() {
    }

    public MessageIncreaseNinjutsu(int amount) {
        this.amount = amount;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.amount);
    }

    public void fromBytes(ByteBuf buf) {
        this.amount = buf.readInt();
    }

    public static class Handler
    implements IMessageHandler<MessageIncreaseNinjutsu, IMessage> {
        public IMessage onMessage(MessageIncreaseNinjutsu message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                IChakra chakra = (IChakra)player.getCapability(ChakraProvider.CHAKRA_CAP, null);
                if (chakra != null) {
                    chakra.setMaxChakra(chakra.getMaxChakra() + 5 * message.amount);
                    ModNetwork.sendTo(new MessageSyncChakra(chakra.getChakra(), chakra.getMaxChakra(), chakra.isChakraControlActive()), player);
                    IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
                    if (stats != null && stats.getSkillPoints() >= message.amount) {
                        stats.addNinjutsu(message.amount);
                        stats.setSkillPoints(stats.getSkillPoints() - message.amount);
                        ModNetwork.sendTo(new MessageSyncStats(stats), player);
                        ChakraHandler.syncChakraToNinjutsu((EntityPlayer)player);
                    }
                }
            });
            return null;
        }
    }
}

