/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.network.stats;

import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatEvents;
import com.f1njo.sre.stats.PlayerStatsProvider;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageIncreaseSpeed
implements IMessage {
    public int amount;

    public MessageIncreaseSpeed() {
    }

    public MessageIncreaseSpeed(int amount) {
        this.amount = amount;
    }

    public void fromBytes(ByteBuf buf) {
        this.amount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.amount);
    }

    public static class Handler
    implements IMessageHandler<MessageIncreaseSpeed, IMessage> {
        public IMessage onMessage(MessageIncreaseSpeed message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                int currentSpeed;
                IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
                if (stats != null && (currentSpeed = stats.getSpeed()) < 25 && stats.getSkillPoints() >= message.amount) {
                    int newSpeed = Math.min(25, currentSpeed + message.amount);
                    stats.setSpeed(newSpeed);
                    stats.setSkillPoints(stats.getSkillPoints() - message.amount);
                    ModNetwork.sendTo(new MessageSyncStats(stats), player);
                    PlayerStatEvents.applySpeedToPlayer((EntityPlayer)player);
                }
            });
            return null;
        }
    }
}

