/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.network.stats;

import com.f1njo.sre.client.gui.GuiPlayerStats;
import com.f1njo.sre.entities.npc.SummonBeast;
import com.f1njo.sre.missions.MissionRank;
import com.f1njo.sre.stats.ByakuganStage;
import com.f1njo.sre.stats.Clan;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.Locations;
import com.f1njo.sre.stats.PlayerStatEvents;
import com.f1njo.sre.stats.PlayerStatsProvider;
import com.f1njo.sre.stats.Rank;
import com.f1njo.sre.stats.SharinganStage;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSyncStats
implements IMessage {
    private int ninjutsu;
    private int taijutsu;
    private int genjutsu;
    private int bukijutsu;
    private int shurikenjutsu;
    private int kinjutsu;
    private int fuinjutsu;
    private int kuchiyose;
    private int iryo;
    private int speed;
    private int intelligence;
    private int chakraControl;
    private int elements;
    private int[] elementMastery;
    private int[] missions;
    private String clan;
    private String location;
    private String rank;
    private int exp;
    private int level;
    private int skillPoints;
    private String eyeTexture;
    private String summonBeast;
    private boolean shinobi;
    private boolean sharinganActive;
    private int sharinganStage;
    private boolean byakuganActive;
    private int byakuganStage;

    public MessageSyncStats() {
    }

    public MessageSyncStats(IPlayerStats stats) {
        this.ninjutsu = stats.getNinjutsu();
        this.taijutsu = stats.getTaijutsu();
        this.genjutsu = stats.getGenjutsu();
        this.bukijutsu = stats.getBukijutsu();
        this.shurikenjutsu = stats.getShurikenjutsu();
        this.kinjutsu = stats.getKinjutsu();
        this.fuinjutsu = stats.getFuinjutsu();
        this.kuchiyose = stats.getKuchiyose();
        this.iryo = stats.getIryo();
        this.speed = stats.getSpeed();
        this.intelligence = stats.getIntelligence();
        this.chakraControl = stats.getChakraControl();
        this.clan = stats.getClan().name();
        this.elements = stats.getElements();
        this.elementMastery = stats.getElementMasteries();
        MissionRank[] ranks = MissionRank.values();
        this.missions = new int[ranks.length];
        for (int i = 0; i < ranks.length; ++i) {
            this.missions[i] = stats.getMissionCount(ranks[i]);
        }
        this.location = stats.getLocation().name();
        this.rank = stats.getRank().name();
        this.exp = stats.getExp();
        this.level = stats.getLevel();
        this.skillPoints = stats.getSkillPoints();
        this.eyeTexture = stats.getEyeTexture();
        this.sharinganActive = stats.isSharinganActive();
        this.sharinganStage = stats.getSharinganStage().ordinal();
        this.byakuganActive = stats.isByakuganActive();
        this.byakuganStage = stats.getByakuganStage().ordinal();
        this.shinobi = stats.isShinobi();
        SummonBeast beast = stats.getSummonBeast();
        this.summonBeast = beast != null ? beast.name() : "NONE";
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.ninjutsu);
        buf.writeInt(this.taijutsu);
        buf.writeInt(this.genjutsu);
        buf.writeInt(this.bukijutsu);
        buf.writeInt(this.shurikenjutsu);
        buf.writeInt(this.kinjutsu);
        buf.writeInt(this.fuinjutsu);
        buf.writeInt(this.kuchiyose);
        buf.writeInt(this.iryo);
        buf.writeInt(this.speed);
        buf.writeInt(this.intelligence);
        buf.writeInt(this.chakraControl);
        buf.writeInt(this.elements);
        buf.writeInt(this.elementMastery.length);
        for (int val : this.elementMastery) {
            buf.writeInt(val);
        }
        buf.writeInt(this.missions.length);
        for (int missionCount : this.missions) {
            buf.writeInt(missionCount);
        }
        this.writeString(buf, this.clan);
        this.writeString(buf, this.location);
        this.writeString(buf, this.rank);
        buf.writeInt(this.exp);
        buf.writeInt(this.level);
        buf.writeInt(this.skillPoints);
        this.writeString(buf, this.eyeTexture);
        this.writeString(buf, this.summonBeast != null ? this.summonBeast : "NONE");
        buf.writeBoolean(this.sharinganActive);
        buf.writeInt(this.sharinganStage);
        buf.writeBoolean(this.byakuganActive);
        buf.writeInt(this.byakuganStage);
        buf.writeBoolean(this.shinobi);
    }

    public void fromBytes(ByteBuf buf) {
        this.ninjutsu = buf.readInt();
        this.taijutsu = buf.readInt();
        this.genjutsu = buf.readInt();
        this.bukijutsu = buf.readInt();
        this.shurikenjutsu = buf.readInt();
        this.kinjutsu = buf.readInt();
        this.fuinjutsu = buf.readInt();
        this.kuchiyose = buf.readInt();
        this.iryo = buf.readInt();
        this.speed = buf.readInt();
        this.intelligence = buf.readInt();
        this.chakraControl = buf.readInt();
        this.elements = buf.readInt();
        int masteryLen = buf.readInt();
        this.elementMastery = new int[masteryLen];
        for (int i = 0; i < masteryLen; ++i) {
            this.elementMastery[i] = buf.readInt();
        }
        int missionsLen = buf.readInt();
        this.missions = new int[missionsLen];
        for (int i = 0; i < missionsLen; ++i) {
            this.missions[i] = buf.readInt();
        }
        this.clan = this.readString(buf);
        this.location = this.readString(buf);
        this.rank = this.readString(buf);
        this.exp = buf.readInt();
        this.level = buf.readInt();
        this.skillPoints = buf.readInt();
        this.eyeTexture = this.readString(buf);
        this.summonBeast = this.readString(buf);
        this.sharinganActive = buf.readBoolean();
        this.sharinganStage = buf.readInt();
        this.byakuganActive = buf.readBoolean();
        this.byakuganStage = buf.readInt();
        this.shinobi = buf.readBoolean();
    }

    private void writeString(ByteBuf buf, String string) {
        byte[] bytes = string.getBytes();
        buf.writeInt(bytes.length);
        buf.writeBytes(bytes);
    }

    private String readString(ByteBuf buf) {
        int len = buf.readInt();
        byte[] bytes = new byte[len];
        buf.readBytes(bytes);
        return new String(bytes);
    }

    public static class Handler
    implements IMessageHandler<MessageSyncStats, IMessage> {
        public IMessage onMessage(MessageSyncStats message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
                if (stats != null) {
                    stats.setNinjutsu(message.ninjutsu);
                    stats.setTaijutsu(message.taijutsu);
                    stats.setGenjutsu(message.genjutsu);
                    stats.setBukijutsu(message.bukijutsu);
                    stats.setShurikenjutsu(message.shurikenjutsu);
                    stats.setKinjutsu(message.kinjutsu);
                    stats.setFuinjutsu(message.fuinjutsu);
                    stats.setSpeed(message.speed);
                    stats.setKuchiyose(message.kuchiyose);
                    stats.setIryo(message.iryo);
                    stats.setIntelligence(message.intelligence);
                    stats.setChakraControl(message.chakraControl);
                    stats.setElements(message.elements);
                    stats.setElementMasteries(message.elementMastery);
                    stats.setLocation(Locations.valueOf(message.location));
                    stats.setRank(Rank.valueOf(message.rank));
                    stats.setExp(message.exp);
                    stats.setLevel(message.level);
                    stats.setSkillPoints(message.skillPoints);
                    stats.setEyeTexture(message.eyeTexture);
                    SummonBeast beast = null;
                    if (message.summonBeast != null && !message.summonBeast.isEmpty() && !"NONE".equalsIgnoreCase(message.summonBeast)) {
                        try {
                            beast = SummonBeast.valueOf(message.summonBeast);
                        }
                        catch (IllegalArgumentException ignored) {
                            beast = null;
                        }
                    }
                    stats.setSummonBeast(beast);
                    stats.setSharinganActive(message.sharinganActive);
                    SharinganStage[] sharinganStages = SharinganStage.values();
                    if (message.sharinganStage >= 0 && message.sharinganStage < sharinganStages.length) {
                        stats.setSharinganStage(sharinganStages[message.sharinganStage]);
                    }
                    stats.setByakuganActive(message.byakuganActive);
                    stats.setByakuganStage(ByakuganStage.values()[message.byakuganStage]);
                    stats.setShinobi(message.shinobi);
                    if (message.shinobi) {
                        player.getEntityData().func_74778_a("shinobi", "1");
                    } else {
                        player.getEntityData().func_82580_o("shinobi");
                    }
                    MissionRank[] ranks = MissionRank.values();
                    for (int i = 0; i < Math.min(ranks.length, message.missions.length); ++i) {
                        stats.setMissionCount(ranks[i], message.missions[i]);
                    }
                    try {
                        stats.setClan(Clan.valueOf(message.clan));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    PlayerStatEvents.applySpeedToPlayer((EntityPlayer)player);
                    PlayerStatEvents.applyHealthToPlayer((EntityPlayer)player);
                    if (Minecraft.func_71410_x().field_71462_r instanceof GuiPlayerStats) {
                        Minecraft.func_71410_x().field_71462_r.func_73866_w_();
                    }
                }
            });
            return null;
        }
    }
}

