/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.stats;

import com.f1njo.sre.stats.Clan;
import com.f1njo.sre.stats.Element;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class ElementRandomizer {
    public static float SECOND_ELEMENT_CHANCE = 0.15f;
    public static float THIRD_ELEMENT_CHANCE = 0.05f;
    private static final Map<Clan, EnumMap<Element, Integer>> TABLE = new EnumMap<Clan, EnumMap<Element, Integer>>(Clan.class);

    private static void put(Clan clan, int fire, int wind, int lightning, int earth, int water) {
        EnumMap<Element, Integer> map = new EnumMap<Element, Integer>(Element.class);
        map.put(Element.FIRE, fire);
        map.put(Element.WIND, wind);
        map.put(Element.LIGHTNING, lightning);
        map.put(Element.EARTH, earth);
        map.put(Element.WATER, water);
        TABLE.put(clan, map);
    }

    private static Element rollElement(EnumMap<Element, Integer> map, Random rand, Set<Element> exclude) {
        int total = 0;
        for (Map.Entry<Element, Integer> e : map.entrySet()) {
            if (exclude.contains((Object)e.getKey())) continue;
            total += e.getValue().intValue();
        }
        if (total <= 0) {
            return null;
        }
        int r = rand.nextInt(total);
        for (Map.Entry<Element, Integer> e : map.entrySet()) {
            if (exclude.contains((Object)e.getKey()) || (r -= e.getValue().intValue()) >= 0) continue;
            return e.getKey();
        }
        return null;
    }

    public static List<Element> getRandomElements(Clan clan, Random rand) {
        EnumMap<Element, Integer> map = TABLE.get((Object)clan);
        if (map == null) {
            return Collections.emptyList();
        }
        int count = 1;
        if (rand.nextFloat() < SECOND_ELEMENT_CHANCE) {
            ++count;
        }
        if (rand.nextFloat() < THIRD_ELEMENT_CHANCE) {
            ++count;
        }
        ArrayList<Element> result = new ArrayList<Element>();
        HashSet<Element> used = new HashSet<Element>();
        for (int i = 0; i < count; ++i) {
            Element e = ElementRandomizer.rollElement(map, rand, used);
            if (e == null) continue;
            result.add(e);
            used.add(e);
        }
        return result;
    }

    static {
        ElementRandomizer.put(Clan.UCHIHA, 80, 0, 20, 0, 0);
        ElementRandomizer.put(Clan.UZUMAKI, 5, 40, 10, 20, 25);
        ElementRandomizer.put(Clan.ABURAME, 0, 20, 0, 50, 30);
        ElementRandomizer.put(Clan.AKIMICHI, 20, 0, 30, 50, 0);
        ElementRandomizer.put(Clan.HATAKE, 10, 5, 60, 15, 10);
        ElementRandomizer.put(Clan.HOZUKI, 0, 0, 0, 0, 100);
        ElementRandomizer.put(Clan.HYUGA, 10, 60, 0, 30, 0);
        ElementRandomizer.put(Clan.IBURI, 40, 50, 0, 10, 0);
        ElementRandomizer.put(Clan.INUZUKA, 20, 45, 0, 35, 0);
        ElementRandomizer.put(Clan.JUGO, 0, 30, 0, 40, 30);
        ElementRandomizer.put(Clan.KAGUYA, 0, 0, 0, 70, 30);
        ElementRandomizer.put(Clan.KURAMA, 70, 30, 0, 0, 0);
        ElementRandomizer.put(Clan.TSUCHIGUMO, 0, 50, 0, 50, 0);
        ElementRandomizer.put(Clan.NARA, 10, 30, 0, 40, 20);
        ElementRandomizer.put(Clan.OTSUTSUKI, 20, 20, 20, 20, 20);
        ElementRandomizer.put(Clan.HAGOROMO, 20, 20, 20, 20, 20);
        ElementRandomizer.put(Clan.NAMIKAZE, 10, 40, 40, 10, 0);
        ElementRandomizer.put(Clan.SARUTOBI, 30, 15, 15, 20, 20);
        ElementRandomizer.put(Clan.FUMA, 30, 50, 0, 20, 0);
        ElementRandomizer.put(Clan.SENJU, 10, 10, 10, 35, 35);
        ElementRandomizer.put(Clan.YUKI, 0, 50, 0, 0, 50);
        ElementRandomizer.put(Clan.YAMANAKA, 15, 30, 0, 40, 15);
        ElementRandomizer.put(Clan.LEE, 0, 0, 0, 0, 0);
        ElementRandomizer.put(Clan.CHINOIKE, 20, 0, 0, 20, 60);
        ElementRandomizer.put(Clan.SHIROGANE, 50, 30, 0, 20, 0);
        ElementRandomizer.put(Clan.AMAGIRI, 40, 40, 20, 0, 0);
        ElementRandomizer.put(Clan.FUNATO, 0, 20, 0, 10, 70);
        ElementRandomizer.put(Clan.HIRASAKA, 0, 30, 30, 40, 0);
        ElementRandomizer.put(Clan.HOSHIGAKI, 0, 0, 0, 10, 90);
        ElementRandomizer.put(Clan.IZUNO, 20, 20, 20, 20, 20);
        ElementRandomizer.put(Clan.KAGETSU, 60, 0, 0, 40, 0);
        ElementRandomizer.put(Clan.KAMIZURU, 0, 40, 0, 60, 0);
        ElementRandomizer.put(Clan.KARATACHI, 0, 0, 20, 10, 70);
        ElementRandomizer.put(Clan.KAZEKAGE, 10, 70, 0, 20, 0);
        ElementRandomizer.put(Clan.KEDOIN, 10, 30, 0, 40, 20);
        ElementRandomizer.put(Clan.KODON, 20, 20, 20, 20, 20);
        ElementRandomizer.put(Clan.KOHAKU, 20, 20, 20, 20, 20);
        ElementRandomizer.put(Clan.KUMANOI, 30, 40, 0, 30, 0);
        ElementRandomizer.put(Clan.ONIKUMA, 30, 20, 0, 50, 0);
        ElementRandomizer.put(Clan.RINHA, 20, 20, 20, 20, 20);
        ElementRandomizer.put(Clan.RYU, 0, 0, 50, 0, 50);
        ElementRandomizer.put(Clan.SENDO, 20, 20, 20, 20, 20);
        ElementRandomizer.put(Clan.SHIIN, 20, 20, 20, 20, 20);
        ElementRandomizer.put(Clan.SHIMURA, 30, 50, 0, 20, 0);
        ElementRandomizer.put(Clan.TAKETORI, 0, 40, 0, 60, 0);
        ElementRandomizer.put(Clan.TENRO, 20, 20, 20, 20, 20);
        ElementRandomizer.put(Clan.WAGARASHI, 30, 30, 0, 40, 0);
        ElementRandomizer.put(Clan.WASABI, 20, 40, 0, 20, 20);
        ElementRandomizer.put(Clan.YOTSUKI, 0, 15, 70, 15, 0);
    }
}

