/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.stats;

import com.f1njo.sre.chakra.api.IChakra;
import com.f1njo.sre.chakra.handler.ChakraHandler;
import com.f1njo.sre.chakra.impl.ChakraProvider;
import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.core.ModPotions;
import com.f1njo.sre.entities.npc.EntityWhiteZetsu;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import com.f1njo.sre.stats.SharinganStage;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityIllusionIllager;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerStatEvents {
    public static final ResourceLocation STATS_CAP_ID = new ResourceLocation("sre", "player_stats");
    public static final UUID SPEED_BOOST_UUID = UUID.fromString("cbf3b8e8-bc85-4781-b7e2-35d9a54d13df");
    public static final UUID HEALTH_BOOST_UUID = UUID.fromString("7c8b06a0-6cb4-4c02-9afe-2bea844e3ee7");

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(STATS_CAP_ID, (ICapabilityProvider)new PlayerStatsProvider());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        IPlayerStats oldStats = (IPlayerStats)event.getOriginal().getCapability(PlayerStatsProvider.STATS_CAP, null);
        IPlayerStats newStats = (IPlayerStats)event.getEntityPlayer().getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (oldStats != null && newStats != null) {
            ((PlayerStats)newStats).deserializeNBT(((PlayerStats)oldStats).serializeNBT());
            if (event.isWasDeath()) {
                newStats.setSharinganActive(false);
                newStats.setByakuganActive(false);
            }
            if (oldStats.isShinobi()) {
                event.getEntityPlayer().getEntityData().func_74778_a("shinobi", "1");
            }
            NBTTagCompound oldData = event.getOriginal().getEntityData();
            NBTTagCompound newData = event.getEntityPlayer().getEntityData();
            if (oldData.func_74764_b("elderQuestStage")) {
                newData.func_74768_a("elderQuestStage", oldData.func_74762_e("elderQuestStage"));
            }
            if (oldData.func_74764_b("elderQuestComplete")) {
                newData.func_74757_a("elderQuestComplete", oldData.func_74767_n("elderQuestComplete"));
            }
            if (oldData.func_74764_b("elderQuestGolemDone")) {
                newData.func_74757_a("elderQuestGolemDone", oldData.func_74767_n("elderQuestGolemDone"));
            }
            this.copyQuestData(oldData, newData, "toadQuestStage");
            this.copyQuestBoolean(oldData, newData, "toadQuestComplete");
            this.copyQuestData(oldData, newData, "toadQuestSlimeKills");
            this.copyQuestData(oldData, newData, "toadQuestSlimeTarget");
            this.copyQuestData(oldData, newData, "toadQuestSlimeX");
            this.copyQuestData(oldData, newData, "toadQuestSlimeY");
            this.copyQuestData(oldData, newData, "toadQuestSlimeZ");
            this.copyQuestData(oldData, newData, "toadQuestHintX");
            this.copyQuestData(oldData, newData, "toadQuestHintY");
            this.copyQuestData(oldData, newData, "toadQuestHintZ");
            this.copyQuestData(oldData, newData, "orochiQuestStage");
            this.copyQuestBoolean(oldData, newData, "orochiQuestComplete");
            this.copyQuestBoolean(oldData, newData, "orochiQuestSpiderSpawned");
            this.copyQuestBoolean(oldData, newData, "orochiQuestSpiderDelivered");
            this.copyQuestData(oldData, newData, "orochiQuestSpiderX");
            this.copyQuestData(oldData, newData, "orochiQuestSpiderY");
            this.copyQuestData(oldData, newData, "orochiQuestSpiderZ");
            this.copyQuestBoolean(oldData, newData, "orochiQuestFightStarted");
            this.copyQuestData(oldData, newData, "orochiQuestWitchesRemaining");
            this.copyQuestBoolean(oldData, newData, "orochiQuestWitchesCleared");
            this.copyQuestData(oldData, newData, "orochiQuestHintX");
            this.copyQuestData(oldData, newData, "orochiQuestHintY");
            this.copyQuestData(oldData, newData, "orochiQuestHintZ");
            this.copyQuestData(oldData, newData, "healerQuestStage");
            this.copyQuestBoolean(oldData, newData, "healerQuestComplete");
            this.copyQuestData(oldData, newData, "healerQuestHintX");
            this.copyQuestData(oldData, newData, "healerQuestHintY");
            this.copyQuestData(oldData, newData, "healerQuestHintZ");
        }
    }

    private void copyQuestData(NBTTagCompound oldData, NBTTagCompound newData, String key) {
        if (oldData.func_74764_b(key)) {
            newData.func_74768_a(key, oldData.func_74762_e(key));
        }
    }

    private void copyQuestBoolean(NBTTagCompound oldData, NBTTagCompound newData, String key) {
        if (oldData.func_74764_b(key)) {
            newData.func_74757_a(key, oldData.func_74767_n(key));
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        PlayerStatEvents.syncStats(player);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        PlayerStatEvents.syncStats(player);
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        PlayerStatEvents.syncStats(player);
    }

    private static void syncStats(EntityPlayerMP player) {
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats != null) {
            ChakraHandler.syncChakraToNinjutsu((EntityPlayer)player);
            ModNetwork.sendTo(new MessageSyncStats(stats), player);
            if (stats.isShinobi()) {
                player.getEntityData().func_74778_a("shinobi", "1");
            }
            PlayerStatEvents.applyHealthToPlayer((EntityPlayer)player);
            PlayerStatEvents.applySpeedToPlayer((EntityPlayer)player);
        }
    }

    public static void applySpeedToPlayer(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats != null) {
            double base = 0.1;
            double bonus = (double)stats.getSpeed() * 0.0015;
            IAttributeInstance attr = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
            if (attr.func_111127_a(SPEED_BOOST_UUID) != null) {
                attr.func_188479_b(SPEED_BOOST_UUID);
            }
            AttributeModifier speedMod = new AttributeModifier(SPEED_BOOST_UUID, "shinobire_speed_bonus", bonus, 0);
            attr.func_111121_a(speedMod);
        }
    }

    public static void applyHealthToPlayer(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats != null) {
            double bonus = stats.getLevel() / 25;
            IAttributeInstance attr = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
            if (attr.func_111127_a(HEALTH_BOOST_UUID) != null) {
                attr.func_188479_b(HEALTH_BOOST_UUID);
            }
            if (bonus > 0.0) {
                AttributeModifier healthMod = new AttributeModifier(HEALTH_BOOST_UUID, "shinobire_health_bonus", bonus, 0);
                attr.func_111121_a(healthMod);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        float max;
        float health;
        TextComponentString activated;
        TextComponentString awaken;
        Scoreboard scoreboard;
        ScorePlayerTeam team;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayer player = event.player;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null) {
            return;
        }
        long worldTime = player.field_70170_p.func_82737_E();
        if (stats.isByakuganActive()) {
            if (ModPotions.BYAKUGAN != null) {
                player.func_70690_d(new PotionEffect(ModPotions.BYAKUGAN, 5, 0, false, false));
            }
            if ((team = (scoreboard = player.field_70170_p.func_96441_U()).func_96508_e("byakugan_glow")) == null) {
                team = scoreboard.func_96527_f("byakugan_glow");
            }
            team.func_178774_a(TextFormatting.AQUA);
            team.func_96666_b(TextFormatting.AQUA.toString());
            team.func_96662_c(TextFormatting.RESET.toString());
            String playerId = player.func_189512_bd();
            ScorePlayerTeam currentTeam = scoreboard.func_96509_i(playerId);
            if (currentTeam == team) {
                scoreboard.func_96512_b(playerId, team);
            }
            for (Entity entity : player.field_70170_p.field_72996_f) {
                EntityLivingBase living;
                if (!(entity instanceof EntityLivingBase) || (living = (EntityLivingBase)entity) == player || !living.func_70089_S()) continue;
                living.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 5, 0, false, false));
                scoreboard.func_151392_a(living.func_189512_bd(), team.func_96661_b());
            }
        } else {
            if (ModPotions.BYAKUGAN != null) {
                player.func_184589_d(ModPotions.BYAKUGAN);
            }
            if ((team = (scoreboard = player.field_70170_p.func_96441_U()).func_96508_e("byakugan_glow")) != null) {
                for (String member : new ArrayList(team.func_96670_d())) {
                    scoreboard.func_96512_b(member, team);
                }
                scoreboard.func_96511_d(team);
            }
        }
        if (stats.getSharinganStage() == SharinganStage.T0) {
            float max2;
            float health2 = player.func_110143_aJ();
            if (health2 <= (max2 = player.func_110138_aP()) * 0.2f) {
                stats.setSharinganStage(SharinganStage.T1);
                stats.setSharinganActive(true);
                stats.setSharinganUnlockTime(worldTime + 72000L);
                awaken = new TextComponentString(I18n.func_135052_a((String)"message.sharingan.awaken", (Object[])new Object[0]));
                awaken.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)awaken);
                activated = new TextComponentString(I18n.func_135052_a((String)"message.sharingan.activated", (Object[])new Object[0]));
                activated.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)activated);
                if (ModPotions.SHARINGAN != null) {
                    int amplifier = Math.max(stats.getSharinganStage().ordinal() - SharinganStage.T1.ordinal(), 0);
                    player.func_70690_d(new PotionEffect(ModPotions.SHARINGAN, 200, amplifier, false, false));
                }
                player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 200, 0));
                if (player instanceof EntityPlayerMP) {
                    ModNetwork.sendTo(new MessageSyncStats(stats), (EntityPlayerMP)player);
                }
            }
        } else if (stats.getSharinganStage() == SharinganStage.T1) {
            float max3;
            float health3;
            if (worldTime >= stats.getSharinganUnlockTime() && (health3 = player.func_110143_aJ()) <= (max3 = player.func_110138_aP()) * 0.2f) {
                stats.setSharinganStage(SharinganStage.T2);
                stats.setSharinganActive(true);
                stats.setSharinganUnlockTime(worldTime + 120000L);
                awaken = new TextComponentString(I18n.func_135052_a((String)"message.sharingan.awaken", (Object[])new Object[0]));
                awaken.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)awaken);
                activated = new TextComponentString(I18n.func_135052_a((String)"message.sharingan.activated", (Object[])new Object[0]));
                activated.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)activated);
                if (ModPotions.SHARINGAN != null) {
                    int amplifier = Math.max(stats.getSharinganStage().ordinal() - SharinganStage.T1.ordinal(), 0);
                    player.func_70690_d(new PotionEffect(ModPotions.SHARINGAN, 200, amplifier, false, false));
                }
                player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 200, 0));
                if (player instanceof EntityPlayerMP) {
                    ModNetwork.sendTo(new MessageSyncStats(stats), (EntityPlayerMP)player);
                }
            }
        } else if (stats.getSharinganStage() == SharinganStage.T2 && worldTime >= stats.getSharinganUnlockTime() && (health = player.func_110143_aJ()) <= (max = player.func_110138_aP()) * 0.2f) {
            stats.setSharinganStage(SharinganStage.T3);
            stats.setSharinganActive(true);
            awaken = new TextComponentString(I18n.func_135052_a((String)"message.sharingan.awaken", (Object[])new Object[0]));
            awaken.func_150256_b().func_150238_a(TextFormatting.RED);
            player.func_145747_a((ITextComponent)awaken);
            activated = new TextComponentString(I18n.func_135052_a((String)"message.sharingan.activated", (Object[])new Object[0]));
            activated.func_150256_b().func_150238_a(TextFormatting.RED);
            player.func_145747_a((ITextComponent)activated);
            if (ModPotions.SHARINGAN != null) {
                int amplifier = Math.max(stats.getSharinganStage().ordinal() - SharinganStage.T1.ordinal(), 0);
                player.func_70690_d(new PotionEffect(ModPotions.SHARINGAN, 200, amplifier, false, false));
            }
            player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 200, 0));
            if (player instanceof EntityPlayerMP) {
                ModNetwork.sendTo(new MessageSyncStats(stats), (EntityPlayerMP)player);
            }
        }
        if (stats.isSharinganActive() && stats.getSharinganStage().canActivate()) {
            IChakra chakra;
            if (ModPotions.SHARINGAN != null) {
                int amplifier = Math.max(stats.getSharinganStage().ordinal() - SharinganStage.T1.ordinal(), 0);
                player.func_70690_d(new PotionEffect(ModPotions.SHARINGAN, 5, amplifier, false, false));
            }
            if ((chakra = (IChakra)player.getCapability(ChakraProvider.CHAKRA_CAP, null)) != null) {
                int tick = player.getEntityData().func_74762_e("sharinganDrainTick");
                if (++tick >= 20) {
                    int chakraDrain = 3;
                    switch (stats.getSharinganStage()) {
                        case T2: {
                            chakraDrain = 2;
                            break;
                        }
                        case T3: 
                        case MS: 
                        case EMS: {
                            chakraDrain = 1;
                            break;
                        }
                    }
                    if (chakra.getChakra() >= chakraDrain) {
                        chakra.consumeChakra(chakraDrain);
                    } else {
                        stats.setSharinganActive(false);
                        TextComponentString msg = new TextComponentString(I18n.func_135052_a((String)"message.sharingan.deactivated", (Object[])new Object[0]));
                        msg.func_150256_b().func_150238_a(TextFormatting.GRAY);
                        player.func_145747_a((ITextComponent)msg);
                        if (player instanceof EntityPlayerMP) {
                            ModNetwork.sendTo(new MessageSyncStats(stats), (EntityPlayerMP)player);
                        }
                    }
                    tick = 0;
                }
                player.getEntityData().func_74768_a("sharinganDrainTick", tick);
            }
        } else {
            if (ModPotions.SHARINGAN != null) {
                player.func_184589_d(ModPotions.SHARINGAN);
            }
            player.getEntityData().func_74768_a("sharinganDrainTick", 0);
        }
    }

    @SubscribeEvent
    public void onEntityKilled(LivingDeathEvent event) {
        if (!(event.getSource().func_76346_g() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getSource().func_76346_g();
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats != null) {
            int expGained = this.getExpForEntity(event.getEntity());
            stats.addExp(expGained, player);
        }
    }

    private int getExpForEntity(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return 5;
        }
        if (entity instanceof EntityWhiteZetsu) {
            return 15;
        }
        if (entity instanceof EntityZombie) {
            return 5;
        }
        if (entity instanceof EntityHusk) {
            return 6;
        }
        if (entity instanceof EntitySkeleton) {
            return 6;
        }
        if (entity instanceof EntityStray) {
            return 7;
        }
        if (entity instanceof EntityWitherSkeleton) {
            return 10;
        }
        if (entity instanceof EntityCreeper) {
            return 7;
        }
        if (entity instanceof EntitySpider) {
            return 4;
        }
        if (entity instanceof EntityCaveSpider) {
            return 5;
        }
        if (entity instanceof EntityEnderman) {
            return 12;
        }
        if (entity instanceof EntityBlaze) {
            return 10;
        }
        if (entity instanceof EntityMagmaCube) {
            return 8;
        }
        if (entity instanceof EntitySlime) {
            return 3;
        }
        if (entity instanceof EntityGhast) {
            return 15;
        }
        if (entity instanceof EntityWitch) {
            return 10;
        }
        if (entity instanceof EntityEvoker) {
            return 12;
        }
        if (entity instanceof EntityVindicator) {
            return 10;
        }
        if (entity instanceof EntityIllusionIllager) {
            return 12;
        }
        if (entity instanceof EntityGuardian) {
            return 10;
        }
        if (entity instanceof EntityElderGuardian) {
            return 20;
        }
        if (entity instanceof EntityShulker) {
            return 8;
        }
        if (entity instanceof EntitySilverfish) {
            return 2;
        }
        if (entity instanceof EntityEndermite) {
            return 3;
        }
        if (entity instanceof EntityWither) {
            return 150;
        }
        if (entity instanceof EntityDragon) {
            return 250;
        }
        if (entity instanceof EntityIronGolem) {
            return 15;
        }
        if (entity instanceof EntitySnowman) {
            return 3;
        }
        return 1;
    }
}

