/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.stats;

import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.entities.npc.SummonBeast;
import com.f1njo.sre.missions.MissionRank;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.ByakuganStage;
import com.f1njo.sre.stats.Clan;
import com.f1njo.sre.stats.Element;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.Locations;
import com.f1njo.sre.stats.PlayerStatEvents;
import com.f1njo.sre.stats.Rank;
import com.f1njo.sre.stats.SharinganStage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class PlayerStats
implements IPlayerStats,
INBTSerializable<NBTTagCompound> {
    private int ninjutsu = 5;
    private int taijutsu = 0;
    private int genjutsu = 0;
    private int bukijutsu = 0;
    private int shurikenjutsu = 0;
    private int kinjutsu = 0;
    private int fuinjutsu = 0;
    private int kuchiyose = 0;
    private SummonBeast summonBeast;
    private int iryo = 0;
    private int senjutsu = 0;
    private int speed = 0;
    private int intelligence = 0;
    private int chakraControl = 0;
    private int elements = 0;
    private final int[] elementMastery = new int[Element.values().length];
    private Clan clan = Clan.UNKNOWN;
    private Locations location = Locations.UNKNOWN;
    private Rank rank = Rank.ABSENT;
    private int level = 1;
    private int exp = 0;
    private int skillPoints = 0;
    private boolean byakuganActive = false;
    private ByakuganStage byakuganStage = ByakuganStage.NONE;
    private boolean sharinganActive = false;
    private SharinganStage sharinganStage = SharinganStage.NONE;
    private long sharinganUnlockTime = 0L;
    private String eyeTexture = "blue";
    private boolean shinobi = false;
    private final int[] missions = new int[MissionRank.values().length];

    @Override
    public int getNinjutsu() {
        return this.ninjutsu;
    }

    @Override
    public void setNinjutsu(int value) {
        this.ninjutsu = value;
    }

    @Override
    public void addNinjutsu(int value) {
        this.ninjutsu += value;
    }

    @Override
    public int getTaijutsu() {
        return this.taijutsu;
    }

    @Override
    public void setTaijutsu(int value) {
        this.taijutsu = value;
    }

    @Override
    public void addTaijutsu(int value) {
        this.taijutsu += value;
    }

    @Override
    public int getGenjutsu() {
        return this.genjutsu;
    }

    @Override
    public void setGenjutsu(int value) {
        this.genjutsu = value;
    }

    @Override
    public int getBukijutsu() {
        return this.bukijutsu;
    }

    @Override
    public void setBukijutsu(int value) {
        this.bukijutsu = value;
    }

    @Override
    public int getShurikenjutsu() {
        return this.shurikenjutsu;
    }

    @Override
    public void setShurikenjutsu(int value) {
        this.shurikenjutsu = value;
    }

    @Override
    public int getKinjutsu() {
        return this.kinjutsu;
    }

    @Override
    public void setKinjutsu(int value) {
        this.kinjutsu = value;
    }

    @Override
    public int getFuinjutsu() {
        return this.fuinjutsu;
    }

    @Override
    public void setFuinjutsu(int value) {
        this.fuinjutsu = value;
    }

    @Override
    public int getKuchiyose() {
        return this.kuchiyose;
    }

    @Override
    public void setKuchiyose(int value) {
        this.kuchiyose = value;
    }

    @Override
    public SummonBeast getSummonBeast() {
        return this.summonBeast;
    }

    @Override
    public void setSummonBeast(SummonBeast beast) {
        this.summonBeast = beast;
    }

    @Override
    public int getIryo() {
        return this.iryo;
    }

    @Override
    public void setIryo(int value) {
        this.iryo = value;
    }

    @Override
    public int getSenjutsu() {
        return this.senjutsu;
    }

    @Override
    public void setSenjutsu(int value) {
        this.senjutsu = value;
    }

    @Override
    public int getSpeed() {
        return this.speed;
    }

    @Override
    public void setSpeed(int value) {
        this.speed = value;
    }

    @Override
    public int getIntelligence() {
        return this.intelligence;
    }

    @Override
    public void setIntelligence(int value) {
        this.intelligence = value;
    }

    @Override
    public int getChakraControl() {
        return this.chakraControl;
    }

    @Override
    public void setChakraControl(int value) {
        this.chakraControl = value;
    }

    @Override
    public int getElements() {
        return this.elements;
    }

    @Override
    public void setElements(int mask) {
        this.elements = mask;
    }

    @Override
    public void addElement(Element element) {
        this.elements |= 1 << element.ordinal();
    }

    @Override
    public boolean hasElement(Element element) {
        return (this.elements & 1 << element.ordinal()) != 0;
    }

    @Override
    public int getElementMastery(Element element) {
        return this.elementMastery[element.ordinal()];
    }

    @Override
    public void setElementMastery(Element element, int value) {
        this.elementMastery[element.ordinal()] = value;
    }

    @Override
    public int[] getElementMasteries() {
        return this.elementMastery;
    }

    @Override
    public void setElementMasteries(int[] values) {
        System.arraycopy(values, 0, this.elementMastery, 0, Math.min(values.length, this.elementMastery.length));
    }

    @Override
    public Clan getClan() {
        return this.clan;
    }

    @Override
    public void setClan(Clan clan) {
        this.clan = clan;
        if (clan == Clan.UCHIHA && this.sharinganStage == SharinganStage.NONE) {
            this.sharinganStage = SharinganStage.T0;
        }
    }

    @Override
    public Rank getRank() {
        return this.rank;
    }

    @Override
    public void setRank(Rank rank) {
        this.rank = rank;
    }

    @Override
    public Locations getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Locations location) {
        this.location = location;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public int getExp() {
        return this.exp;
    }

    @Override
    public void setExp(int exp) {
        this.exp = exp;
    }

    @Override
    public int getExpToNextLevel() {
        return Math.max(1, this.level / 4);
    }

    @Override
    public int getSkillPoints() {
        return this.skillPoints;
    }

    @Override
    public void setSkillPoints(int skillPoints) {
        this.skillPoints = skillPoints;
    }

    public void addSkillPoints(int amount) {
        this.skillPoints += amount;
    }

    @Override
    public void addExp(int amount, EntityPlayerMP player) {
        this.exp += amount;
        while (this.exp >= this.getExpToNextLevel()) {
            this.exp -= this.getExpToNextLevel();
            ++this.level;
            ++this.skillPoints;
            if (player == null) continue;
            PlayerStatEvents.applyHealthToPlayer((EntityPlayer)player);
        }
        if (player instanceof EntityPlayerMP) {
            ModNetwork.sendTo(new MessageSyncStats(this), player);
        }
    }

    @Override
    public boolean isByakuganActive() {
        return this.byakuganActive;
    }

    @Override
    public void setByakuganActive(boolean active) {
        this.byakuganActive = active;
    }

    @Override
    public ByakuganStage getByakuganStage() {
        return this.byakuganStage;
    }

    @Override
    public void setByakuganStage(ByakuganStage stage) {
        this.byakuganStage = stage;
    }

    @Override
    public boolean isSharinganActive() {
        return this.sharinganActive;
    }

    @Override
    public void setSharinganActive(boolean active) {
        this.sharinganActive = active;
    }

    @Override
    public SharinganStage getSharinganStage() {
        return this.sharinganStage;
    }

    @Override
    public void setSharinganStage(SharinganStage stage) {
        this.sharinganStage = stage;
    }

    @Override
    public long getSharinganUnlockTime() {
        return this.sharinganUnlockTime;
    }

    @Override
    public void setSharinganUnlockTime(long time) {
        this.sharinganUnlockTime = time;
    }

    @Override
    public String getEyeTexture() {
        return this.eyeTexture;
    }

    @Override
    public void setEyeTexture(String texture) {
        this.eyeTexture = texture;
    }

    @Override
    public int getMissionCount(MissionRank rank) {
        return this.missions[rank.ordinal()];
    }

    @Override
    public void setMissionCount(MissionRank rank, int value) {
        this.missions[rank.ordinal()] = value;
    }

    @Override
    public boolean isShinobi() {
        return this.shinobi;
    }

    @Override
    public void setShinobi(boolean value) {
        this.shinobi = value;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Ninjutsu", this.ninjutsu);
        tag.func_74768_a("Taijutsu", this.taijutsu);
        tag.func_74768_a("Genjutsu", this.genjutsu);
        tag.func_74768_a("Bukijutsu", this.bukijutsu);
        tag.func_74768_a("Shurikenjutsu", this.shurikenjutsu);
        tag.func_74768_a("Kinjutsu", this.kinjutsu);
        tag.func_74768_a("Fuinjutsu", this.fuinjutsu);
        tag.func_74768_a("Kuchiyose", this.kuchiyose);
        tag.func_74778_a("SummonBeast", this.summonBeast != null ? this.summonBeast.name() : "NONE");
        tag.func_74768_a("Iryo", this.iryo);
        tag.func_74768_a("Senjutsu", this.senjutsu);
        tag.func_74768_a("Speed", this.speed);
        tag.func_74768_a("Intelligence", this.intelligence);
        tag.func_74768_a("ChakraControl", this.chakraControl);
        tag.func_74768_a("Elements", this.elements);
        tag.func_74783_a("ElementMastery", this.elementMastery);
        tag.func_74778_a("Clan", this.clan.name());
        tag.func_74778_a("Location", this.location.name());
        tag.func_74778_a("Rank", this.rank.name());
        tag.func_74768_a("Level", this.level);
        tag.func_74768_a("Exp", this.exp);
        tag.func_74768_a("SkillPoints", this.skillPoints);
        tag.func_74757_a("ByakuganActive", this.byakuganActive);
        tag.func_74768_a("ByakuganStage", this.byakuganStage.ordinal());
        tag.func_74757_a("SharinganActive", this.sharinganActive);
        tag.func_74768_a("SharinganStage", this.sharinganStage.ordinal());
        tag.func_74772_a("SharinganUnlockTime", this.sharinganUnlockTime);
        tag.func_74778_a("EyeTexture", this.eyeTexture);
        tag.func_74757_a("Shinobi", this.shinobi);
        for (MissionRank rank : MissionRank.values()) {
            tag.func_74768_a("Missions" + rank.name(), this.missions[rank.ordinal()]);
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.ninjutsu = nbt.func_74762_e("Ninjutsu");
        this.taijutsu = nbt.func_74762_e("Taijutsu");
        this.genjutsu = nbt.func_74762_e("Genjutsu");
        this.bukijutsu = nbt.func_74762_e("Bukijutsu");
        this.shurikenjutsu = nbt.func_74762_e("Shurikenjutsu");
        this.kinjutsu = nbt.func_74762_e("Kinjutsu");
        this.fuinjutsu = nbt.func_74762_e("Fuinjutsu");
        this.kuchiyose = nbt.func_74762_e("Kuchiyose");
        if (nbt.func_74764_b("SummonBeast")) {
            String storedBeast = nbt.func_74779_i("SummonBeast");
            if ("NONE".equalsIgnoreCase(storedBeast)) {
                this.summonBeast = null;
            } else {
                try {
                    this.summonBeast = SummonBeast.valueOf(storedBeast);
                }
                catch (IllegalArgumentException ignored) {
                    this.summonBeast = null;
                }
            }
        }
        this.iryo = nbt.func_74762_e("Iryo");
        this.senjutsu = nbt.func_74762_e("Senjutsu");
        this.speed = nbt.func_74762_e("Speed");
        this.intelligence = nbt.func_74762_e("Intelligence");
        this.chakraControl = nbt.func_74762_e("ChakraControl");
        this.elements = nbt.func_74762_e("Elements");
        int[] masteryArr = nbt.func_74759_k("ElementMastery");
        for (int i = 0; i < this.elementMastery.length && i < masteryArr.length; ++i) {
            this.elementMastery[i] = masteryArr[i];
        }
        if (nbt.func_74764_b("Clan")) {
            try {
                this.clan = Clan.valueOf(nbt.func_74779_i("Clan"));
            }
            catch (IllegalArgumentException ignored) {
                this.clan = Clan.UNKNOWN;
            }
        }
        if (nbt.func_74764_b("Rank")) {
            try {
                this.rank = Rank.valueOf(nbt.func_74779_i("Rank"));
            }
            catch (IllegalArgumentException ignored) {
                this.rank = Rank.ABSENT;
            }
        }
        if (nbt.func_74764_b("Location")) {
            try {
                this.location = Locations.valueOf(nbt.func_74779_i("Location"));
            }
            catch (IllegalArgumentException ignored) {
                this.location = Locations.UNKNOWN;
            }
        }
        this.level = nbt.func_74762_e("Level");
        this.exp = nbt.func_74762_e("Exp");
        this.skillPoints = nbt.func_74762_e("SkillPoints");
        this.byakuganActive = nbt.func_74767_n("ByakuganActive");
        if (nbt.func_74764_b("ByakuganStage")) {
            int stage = nbt.func_74762_e("ByakuganStage");
            this.byakuganStage = ByakuganStage.values()[stage % ByakuganStage.values().length];
        }
        this.sharinganActive = nbt.func_74767_n("SharinganActive");
        if (nbt.func_74764_b("SharinganStage")) {
            int stage = nbt.func_74762_e("SharinganStage");
            this.sharinganStage = SharinganStage.values()[stage % SharinganStage.values().length];
        } else if (nbt.func_74764_b("SharinganLevel")) {
            int stage = nbt.func_74762_e("SharinganLevel");
            this.sharinganStage = SharinganStage.values()[stage % SharinganStage.values().length];
        }
        if (nbt.func_74764_b("SharinganUnlockTime")) {
            this.sharinganUnlockTime = nbt.func_74763_f("SharinganUnlockTime");
        }
        if (nbt.func_74764_b("EyeTexture")) {
            this.eyeTexture = nbt.func_74779_i("EyeTexture");
        }
        this.shinobi = nbt.func_74767_n("Shinobi");
        for (MissionRank rank : MissionRank.values()) {
            this.missions[rank.ordinal()] = nbt.func_74762_e("Missions" + rank.name());
        }
    }
}

