/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.world;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class ElderWorldData
extends WorldSavedData {
    private static final String DATA_NAME = "sreElders";
    private final Set<Long> elderPositions = new HashSet<Long>();

    public ElderWorldData() {
        super(DATA_NAME);
    }

    public ElderWorldData(String name) {
        super(name);
    }

    public static ElderWorldData get(World world) {
        MapStorage storage = world.getPerWorldStorage();
        ElderWorldData data = (ElderWorldData)storage.func_75742_a(ElderWorldData.class, DATA_NAME);
        if (data == null) {
            data = new ElderWorldData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)data);
        }
        return data;
    }

    public boolean hasElderNearby(BlockPos pos, double radius) {
        double radiusSq = radius * radius;
        for (long l : this.elderPositions) {
            BlockPos p = BlockPos.func_177969_a((long)l);
            if (!(p.func_177951_i((Vec3i)pos) <= radiusSq)) continue;
            return true;
        }
        return false;
    }

    public void addElder(BlockPos pos) {
        this.elderPositions.add(pos.func_177986_g());
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.elderPositions.clear();
        NBTTagList list = nbt.func_150295_c("elders", 4);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            long l = ((NBTTagLong)list.func_179238_g(i)).func_150291_c();
            this.elderPositions.add(l);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (long l : this.elderPositions) {
            list.func_74742_a((NBTBase)new NBTTagLong(l));
        }
        compound.func_74782_a("elders", (NBTBase)list);
        return compound;
    }
}

