/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Map;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.misc.InvPlacer;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.IRopeConnection;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.utils.RopeHelper;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.DecoBlocksCompat;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1820;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2358;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4770;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_9062;

public abstract class AbstractRopeBlock
extends WaterBlock
implements IRopeConnection {
    public static final class_265 COLLISION_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    public static final class_2746 KNOT = ModBlockProperties.KNOT;
    private final Map<class_2680, class_265> shapes;

    public AbstractRopeBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)KNOT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapes = this.makeShapes();
    }

    public boolean method_22358(class_2680 state, class_3611 fluid) {
        return false;
    }

    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return this.shapes.getOrDefault(state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)), class_259.method_1077());
    }

    protected abstract Map<class_2680, class_265> makeShapes();

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED, KNOT});
    }

    public boolean isLadder(class_2680 state, class_4538 world, class_2338 pos, class_1309 entity) {
        return this.hasConnection(class_2350.field_11033, state) && (this.hasConnection(class_2350.field_11036, state) || entity.method_19538().method_10214() - (double)pos.method_10264() < 0.8125);
    }

    public abstract boolean hasConnection(class_2350 var1, class_2680 var2);

    public abstract class_2680 setConnection(class_2350 var1, class_2680 var2, boolean var3);

    public class_265 method_9549(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        class_3727 ec;
        if (!CommonConfigs.Functional.ROPE_HORIZONTAL.get().booleanValue()) {
            return class_259.method_1073();
        }
        return !this.hasConnection(class_2350.field_11036, state) && (context.method_16192(COLLISION_SHAPE, pos, true) || !this.hasConnection(class_2350.field_11033, state)) || !(context instanceof class_3727) || !((ec = (class_3727)context).method_32480() instanceof class_1309) ? this.method_9530(state, worldIn, pos, context) : class_259.method_1073();
    }

    public boolean shouldConnectToDir(class_2680 thisState, class_2338 currentPos, class_4538 world, class_2350 dir) {
        if (dir.method_10166().method_10179() && !CommonConfigs.Functional.ROPE_HORIZONTAL.get().booleanValue()) {
            return false;
        }
        class_2338 facingPos = currentPos.method_10093(dir);
        return this.shouldConnectToFace(thisState, world.method_8320(facingPos), facingPos, dir, world);
    }

    public class_2680 method_9559(class_2680 stateIn, class_2350 facing, class_2680 facingState, class_1936 worldIn, class_2338 currentPos, class_2338 facingPos) {
        super.method_9559(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (!worldIn.method_8608()) {
            worldIn.method_39279(currentPos, (class_2248)this, 1);
        }
        if (facing == class_2350.field_11036) {
            stateIn = this.setConnection(class_2350.field_11033, stateIn, this.shouldConnectToDir(stateIn, currentPos, (class_4538)worldIn, class_2350.field_11033));
        }
        stateIn = this.setConnection(facing, stateIn, this.shouldConnectToDir(stateIn, currentPos, (class_4538)worldIn, facing));
        if (facing == class_2350.field_11033 && !worldIn.method_8608() && CompatHandler.DECO_BLOCKS) {
            DecoBlocksCompat.tryConvertingRopeChandelier(facingState, worldIn, facingPos);
        }
        return (class_2680)stateIn.method_11657((class_2769)KNOT, (Comparable)Boolean.valueOf(this.hasMiddleKnot(stateIn)));
    }

    public class_2680 method_9605(class_1750 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        boolean hasWater = context.method_8045().method_8316(pos).method_15772() == class_3612.field_15910;
        class_2680 state = this.method_9564();
        for (class_2350 dir : class_2350.values()) {
            state = this.setConnection(dir, state, this.shouldConnectToDir(state, pos, (class_4538)world, dir));
        }
        state = (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(hasWater));
        state = (class_2680)state.method_11657((class_2769)KNOT, (Comparable)Boolean.valueOf(this.hasMiddleKnot(state)));
        return state;
    }

    public void method_9615(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 oldState, boolean isMoving) {
        if (!worldIn.field_9236) {
            worldIn.method_39279(pos, (class_2248)this, 1);
            if (CompatHandler.DECO_BLOCKS) {
                class_2338 down = pos.method_10074();
                DecoBlocksCompat.tryConvertingRopeChandelier(worldIn.method_8320(down), (class_1936)worldIn, down);
            }
        }
    }

    public boolean hasMiddleKnot(class_2680 state) {
        boolean up = this.hasConnection(class_2350.field_11036, state);
        boolean down = this.hasConnection(class_2350.field_11033, state);
        boolean north = this.hasConnection(class_2350.field_11043, state);
        boolean east = this.hasConnection(class_2350.field_11034, state);
        boolean south = this.hasConnection(class_2350.field_11035, state);
        boolean west = this.hasConnection(class_2350.field_11039, state);
        return !(up && down && !north && !south && !east && !west || !up && !down && north && south && !east && !west || !up && !down && !north && !south && east && west);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338.class_2339 mutable = pos.method_25503().method_10098(class_2350.field_11036);
        class_2680 upstate = world.method_8320((class_2338)mutable);
        if (upstate.method_27852((class_2248)this)) {
            return true;
        }
        if (IRopeConnection.isSupportingCeiling((class_2338)mutable, world)) {
            return true;
        }
        if (CommonConfigs.Functional.ROPE_HORIZONTAL.get().booleanValue()) {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2338.class_2339 facingPos = mutable.method_25505((class_2382)pos, direction);
                class_2680 sideState = world.method_8320((class_2338)facingPos);
                class_2248 b = sideState.method_26204();
                if (b instanceof AbstractRopeBlock) {
                    return true;
                }
                if (!this.shouldConnectToFace(this.method_9564(), sideState, (class_2338)facingPos, direction, world)) continue;
                return true;
            }
        }
        return false;
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 rand) {
        if (!this.method_9558(state, (class_4538)level, pos)) {
            level.method_22352(pos, true);
            return;
        }
        for (class_2350 dir : class_2350.values()) {
            if (dir == class_2350.field_11036 || !level.method_8320(pos.method_10093(dir)).method_26164(class_3481.field_21952)) continue;
            level.method_39279(pos.method_10093(dir), class_2246.field_10036, 2 + level.field_9229.method_43048(1));
            for (class_2350 d2 : class_2350.class_2353.field_11062) {
                class_2338 fp = pos.method_10093(d2);
                if (!class_4770.method_30032((class_1937)level, (class_2338)fp, (class_2350)d2.method_10153())) continue;
                class_2680 fireState = class_4770.method_24416((class_1922)level, (class_2338)fp);
                if (fireState.method_28498((class_2769)class_2358.field_11092)) {
                    fireState = (class_2680)fireState.method_11657((class_2769)class_2358.field_11092, (Comparable)Integer.valueOf(14));
                }
                level.method_8501(fp, fireState);
                level.method_39279(pos.method_10093(dir), class_2246.field_10036, 2 + level.field_9229.method_43048(1));
            }
            return;
        }
    }

    private static boolean findConnectedPulley(class_1937 world, class_2338 pos, class_1657 player, int it, class_2470 rot) {
        class_2680 state = world.method_8320(pos);
        class_2248 b = state.method_26204();
        if (b instanceof AbstractRopeBlock) {
            return AbstractRopeBlock.findConnectedPulley(world, pos.method_10084(), player, it + 1, rot);
        }
        if (b instanceof PulleyBlock) {
            PulleyBlock pulley = (PulleyBlock)b;
            if (it != 0) {
                return pulley.windPulley(state, pos, (class_1936)world, rot, null);
            }
        }
        return false;
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1792 i = stack.method_7909();
        if (i == this.method_8389()) {
            if (hit.method_17780().method_10166() == class_2350.class_2351.field_11052 || this.hasConnection(class_2350.field_11033, state)) {
                if (this.hasConnection(class_2350.field_11036, state) && !this.hasConnection(class_2350.field_11033, state)) {
                    state = this.setConnection(class_2350.field_11033, state, true);
                    level.method_8652(pos, state, 0);
                }
                if (RopeHelper.addRopeDown(pos.method_10074(), level, player, hand, (class_2248)this)) {
                    class_2498 soundtype = state.method_26231();
                    level.method_8396(player, pos, soundtype.method_10598(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
                    if (!player.method_31549().field_7477) {
                        stack.method_7934(1);
                    }
                    return class_9062.method_55644((boolean)level.field_9236);
                }
            }
            return class_9062.field_47731;
        }
        if (stack.method_7960()) {
            if (this.hasConnection(class_2350.field_11036, state) && AbstractRopeBlock.findConnectedPulley(level, pos, player, 0, player.method_5715() ? class_2470.field_11465 : class_2470.field_11463)) {
                return class_9062.method_55644((boolean)level.field_9236);
            }
            if (!player.method_5715() && hand == class_1268.field_5808 && (level.method_8320(pos.method_10074()).method_27852((class_2248)this) || level.method_8320(pos.method_10084()).method_27852((class_2248)this)) && RopeHelper.removeRopeDown(pos.method_10074(), level, (class_2248)this)) {
                level.method_8396(player, pos, class_3417.field_15062, class_3419.field_15245, 1.0f, 0.6f);
                if (!player.method_31549().field_7477) {
                    Utils.addItemOrDrop((class_1657)player, (class_1799)new class_1799((class_1935)this), (InvPlacer)InvPlacer.handOrExistingOrAnyAvoidEmptyHand((class_1268)hand));
                }
                return class_9062.method_55644((boolean)level.field_9236);
            }
        } else if (i instanceof class_1820 && this.hasConnection(class_2350.field_11033, state)) {
            if (!level.field_9236) {
                level.method_8396(null, pos, class_3417.field_22273, player == null ? class_3419.field_15245 : class_3419.field_15248, 0.8f, 1.3f);
                class_2680 newState = (class_2680)this.setConnection(class_2350.field_11033, state, false).method_11657((class_2769)KNOT, (Comparable)Boolean.valueOf(true));
                level.method_8652(pos, newState, 3);
            }
            return class_9062.method_55644((boolean)level.field_9236);
        }
        return class_9062.field_47731;
    }

    public void method_9548(class_2680 state, class_1937 worldIn, class_2338 pos, class_1297 entityIn) {
        super.method_9548(state, worldIn, pos, entityIn);
        if (entityIn instanceof class_1667 && !worldIn.field_9236) {
            worldIn.method_8651(pos, true, entityIn);
            worldIn.method_8396(null, pos, class_3417.field_15184, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    public boolean method_9522(class_2680 pState, class_2680 pAdjacentBlockState, class_2350 pSide) {
        return pAdjacentBlockState.method_27852((class_2248)this) || super.method_9522(pState, pAdjacentBlockState, pSide);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        boolean east = this.hasConnection(class_2350.field_11034, state);
        boolean south = this.hasConnection(class_2350.field_11035, state);
        boolean west = this.hasConnection(class_2350.field_11039, state);
        boolean north = this.hasConnection(class_2350.field_11043, state);
        return switch (rotation) {
            case class_2470.field_11464 -> {
                state = this.setConnection(class_2350.field_11043, state, south);
                state = this.setConnection(class_2350.field_11034, state, west);
                state = this.setConnection(class_2350.field_11035, state, north);
                yield state = this.setConnection(class_2350.field_11039, state, east);
            }
            case class_2470.field_11465 -> {
                state = this.setConnection(class_2350.field_11043, state, east);
                state = this.setConnection(class_2350.field_11034, state, south);
                state = this.setConnection(class_2350.field_11035, state, west);
                yield state = this.setConnection(class_2350.field_11039, state, north);
            }
            case class_2470.field_11463 -> {
                state = this.setConnection(class_2350.field_11043, state, west);
                state = this.setConnection(class_2350.field_11034, state, north);
                state = this.setConnection(class_2350.field_11035, state, east);
                yield state = this.setConnection(class_2350.field_11039, state, south);
            }
            default -> state;
        };
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return switch (mirror) {
            case class_2415.field_11300 -> {
                state = this.setConnection(class_2350.field_11043, state, this.hasConnection(class_2350.field_11035, state));
                yield state = this.setConnection(class_2350.field_11035, state, this.hasConnection(class_2350.field_11043, state));
            }
            case class_2415.field_11301 -> {
                state = this.setConnection(class_2350.field_11034, state, this.hasConnection(class_2350.field_11039, state));
                yield state = this.setConnection(class_2350.field_11039, state, this.hasConnection(class_2350.field_11034, state));
            }
            default -> super.method_9569(state, mirror);
        };
    }

    @Override
    public boolean canSideAcceptConnection(class_2680 state, class_2350 direction) {
        return true;
    }
}

