/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.cannon;

import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CannonBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundRequestOpenCannonGuiMessage;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSyncCannonPacket;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public interface CannonAccess {
    public CannonBlockTile getInternalCannon();

    public TileOrEntityTarget makeNetworkTarget();

    public void applyRecoil();

    public boolean canManeuverFromGUI(class_1657 var1);

    public void syncToServer(boolean var1, boolean var2);

    public class_243 getCannonGlobalPosition(float var1);

    public float getCannonGlobalYawOffset(float var1);

    public class_243 getCannonGlobalOffset();

    public void sendOpenGuiRequest();

    public void openCannonGui(class_3222 var1);

    public boolean method_5443(class_1657 var1);

    public void updateClients();

    default public class_243 getCannonGlobalFacing(float partialTicks) {
        CannonBlockTile cannon = this.getInternalCannon();
        return class_243.method_1030((float)cannon.getPitch(partialTicks), (float)(cannon.getYaw(partialTicks) - this.getCannonGlobalYawOffset(partialTicks)));
    }

    default public void setCannonGlobalFacing(class_243 direction) {
        this.setCannonGlobalFacing(direction, false);
    }

    default public void setCannonGlobalFacing(class_243 direction, boolean ignoreIfInvalid) {
        CannonBlockTile cannon = this.getInternalCannon();
        float yaw = (float)(MthUtils.getYaw((class_243)direction) + (double)this.getCannonGlobalYawOffset(0.0f));
        float pitch = (float)MthUtils.getPitch((class_243)direction);
        float oldYaw = cannon.getYaw(0.0f);
        float oldPitch = cannon.getPitch(0.0f);
        cannon.setYaw(this, yaw);
        cannon.setPitch(this, pitch);
        if (!ignoreIfInvalid) {
            float newYaw = cannon.getYaw(0.0f);
            float newPitch = cannon.getPitch(0.0f);
            if (newYaw != yaw || newPitch != pitch) {
                cannon.setYaw(this, oldYaw);
                cannon.setPitch(this, oldPitch);
            }
        }
    }

    public Restraint getPitchAndYawRestrains();

    public class_243 getCannonGlobalVelocity();

    default public boolean shouldRotatePlayerFaceWhenManeuvering() {
        return false;
    }

    default public boolean impedePlayerMovementWhenManeuvering() {
        return true;
    }

    public static CannonAccess find(class_1937 level, TileOrEntityTarget target) {
        Object obj = target.getTarget(level);
        if (obj instanceof CannonBlockTile) {
            CannonBlockTile cannon = (CannonBlockTile)((Object)obj);
            return new Block(cannon);
        }
        if (obj instanceof CannonAccess) {
            CannonAccess cannon = (CannonAccess)obj;
            return cannon;
        }
        return null;
    }

    public static CannonAccess block(CannonBlockTile cannonBlockTile) {
        return new Block(cannonBlockTile);
    }

    public class_243 getCannonRecoil();

    public static class Block
    implements CannonAccess {
        private final CannonBlockTile cannon;

        public Block(CannonBlockTile cannon) {
            this.cannon = cannon;
        }

        @Override
        public TileOrEntityTarget makeNetworkTarget() {
            return TileOrEntityTarget.of((class_2586)this.cannon);
        }

        @Override
        public class_243 getCannonRecoil() {
            return class_243.field_1353;
        }

        @Override
        public void applyRecoil() {
        }

        @Override
        public class_243 getCannonGlobalVelocity() {
            return class_243.field_1353;
        }

        @Override
        public boolean canManeuverFromGUI(class_1657 player) {
            return true;
        }

        @Override
        public class_243 getCannonGlobalPosition(float ticks) {
            return this.cannon.method_11016().method_46558();
        }

        @Override
        public class_243 getCannonGlobalOffset() {
            return new class_243(0.5, 0.5, 0.5);
        }

        @Override
        public float getCannonGlobalYawOffset(float partialTicks) {
            return 0.0f;
        }

        @Override
        public CannonBlockTile getInternalCannon() {
            return this.cannon;
        }

        @Override
        public void updateClients() {
            class_1937 level = this.cannon.method_10997();
            level.method_8413(this.cannon.method_11016(), this.cannon.method_11010(), this.cannon.method_11010(), 3);
        }

        @Override
        public void syncToServer(boolean fire, boolean removeOwner) {
            NetworkHelper.sendToServer((class_8710)new ServerBoundSyncCannonPacket(this.cannon.getYaw(), this.cannon.getPitch(), this.cannon.getPowerLevel(), fire, removeOwner, TileOrEntityTarget.of((class_2586)this.cannon)));
        }

        @Override
        public void sendOpenGuiRequest() {
            NetworkHelper.sendToServer((class_8710)new ServerBoundRequestOpenCannonGuiMessage((class_2586)this.cannon));
        }

        @Override
        public void openCannonGui(class_3222 player) {
            Utils.openGuiIfPossible((class_2586)this.cannon, (class_3222)player, (class_1799)player.method_6047(), (class_2350)class_2350.field_11036);
        }

        @Override
        public boolean method_5443(class_1657 player) {
            class_1937 level = player.method_37908();
            return !this.cannon.method_11015() && level.method_8321(this.cannon.method_11016()) == this.cannon && this.cannon.isCloseEnoughToUse((class_1297)player, this.cannon.method_11016());
        }

        @Override
        public Restraint getPitchAndYawRestrains() {
            class_2680 state = this.cannon.method_11010();
            return switch (((class_2350)state.method_11654((class_2769)CannonBlock.field_10927)).method_10153()) {
                default -> throw new MatchException(null, null);
                case class_2350.field_11043 -> new Restraint(70.0f, 290.0f, -180.0f, 180.0f);
                case class_2350.field_11035 -> new Restraint(-110.0f, 110.0f, -180.0f, 180.0f);
                case class_2350.field_11034 -> new Restraint(-200.0f, 20.0f, -180.0f, 180.0f);
                case class_2350.field_11039 -> new Restraint(-20.0f, 200.0f, -180.0f, 180.0f);
                case class_2350.field_11036 -> new Restraint(-360.0f, 360.0f, -200.0f, 20.0f);
                case class_2350.field_11033 -> new Restraint(-360.0f, 360.0f, -20.0f, 200.0f);
            };
        }
    }

    public record Restraint(float minYaw, float maxYaw, float minPitch, float maxPitch) {
    }
}

