/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FluidOffer;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteFluid;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class FiniteFluidInteraction
implements FaucetTarget.Fluid,
FaucetSource.Fluid {
    @Override
    public Integer fill(class_1937 level, class_2338 pos, class_3610 existing, FluidOffer offer) {
        class_6880 vanillaF = offer.fluid().getVanillaFluid();
        if (vanillaF instanceof FiniteFluid) {
            FiniteFluid ff = (FiniteFluid)vanillaF;
            int oldLayers = 0;
            if (existing.method_15772().method_15780((class_3611)vanillaF.comp_349())) {
                oldLayers = existing.method_15761();
            } else if (!existing.method_15769() || !level.method_8320(pos).method_26215()) {
                return null;
            }
            int maxLayers = ff.getLayersPerBlock();
            int missingLayers = maxLayers - oldLayers;
            if (missingLayers <= 0) {
                return 0;
            }
            float offerLayers = this.bottlesToLayers(ff, 1);
            float extraLayers = Math.min((float)missingLayers, offerLayers);
            float consumed = this.layersToBottles(ff, extraLayers);
            level.method_8501(pos, ff.makeState((int)((float)oldLayers + extraLayers)).method_15759());
            return Math.min(class_3532.method_15375((float)consumed), offer.fluid().getCount());
        }
        return null;
    }

    @Override
    @Nullable
    public FluidOffer getProvidedFluid(class_1937 level, class_2338 pos, class_2350 dir, class_3610 source) {
        FiniteFluid ff;
        int amount;
        class_3611 class_36112 = source.method_15772();
        if (class_36112 instanceof FiniteFluid && (amount = this.layersToBottles(ff = (FiniteFluid)class_36112, source.method_15761())) > 0) {
            return FluidOffer.of(SoftFluidStack.fromFluid((class_3611)ff, (int)amount, (class_7225.class_7874)level.method_30349()));
        }
        return null;
    }

    @Override
    public void drain(class_1937 level, class_2338 pos, class_2350 dir, class_3610 source, int amount) {
        FiniteFluid ff = (FiniteFluid)source.method_15772();
        int drainedLayers = this.bottlesToLayers(ff, amount);
        int newLayers = Math.max(0, source.method_15761() - drainedLayers);
        if (newLayers == 0) {
            level.method_8501(pos, class_2246.field_10124.method_9564());
        } else {
            level.method_8501(pos, ff.makeState(newLayers).method_15759());
        }
    }

    private int layersToBottles(FiniteFluid ff, float layers) {
        int maxLayers = ff.getLayersPerBlock();
        float bottleToLayers = (float)maxLayers / 4.0f;
        return (int)(layers / bottleToLayers);
    }

    private int bottlesToLayers(FiniteFluid ff, int bottles) {
        int maxLayers = ff.getLayersPerBlock();
        float bottleToLayers = (float)maxLayers / 4.0f;
        return (int)((float)bottles * bottleToLayers);
    }
}

