/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.placeable_book;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.misc.MapRegistry;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.BookModelVisuals;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.BookType;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.PlaceableBookManager;
import net.minecraft.class_1091;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4309;
import net.minecraft.class_7225;

public class PlaceableBookManagerClient {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final MapRegistry<List<BookModelVisuals.VariantModelList>> bookVisuals = new MapRegistry("placeable_books_visuals");
    private static final BookModelVisuals missingModel = new BookModelVisuals(new class_1091(Supplementaries.res("missing"), "missing"), -1, 0.0f, false);

    private static void reload(class_3300 resourceManager) {
        HashMap js = new HashMap();
        class_4309.method_51148((class_3300)resourceManager, (String)"placeable_books_visuals", (Gson)GSON, js);
        bookVisuals.clear();
        JsonOps ops = JsonOps.INSTANCE;
        for (Map.Entry entry : js.entrySet()) {
            List m = (List)BookModelVisuals.VariantModelList.LIST_CODEC.parse((DynamicOps)ops, (Object)((JsonElement)entry.getValue())).getOrThrow();
            bookVisuals.register((class_2960)entry.getKey(), (Object)m);
        }
    }

    public static List<BookModelVisuals> getValidModelsForBookItem(class_7225.class_7874 level, class_1799 stack, boolean horizontal) {
        BookType type = PlaceableBookManager.get(stack.method_7909(), horizontal, level);
        if (type == null) {
            Supplementaries.LOGGER.warn("No book type found for item: {}", (Object)stack.method_7909());
            return List.of(missingModel);
        }
        List list = (List)bookVisuals.getValue(type.bookVisuals());
        if (list == null || list.isEmpty()) {
            Supplementaries.LOGGER.warn("No visuals found for book type: {}", (Object)type);
            return List.of(missingModel);
        }
        BookModelVisuals.VariantModelList modelsList = null;
        for (BookModelVisuals.VariantModelList m : list) {
            if (!m.matchesComponents(stack.method_57353())) continue;
            modelsList = m;
            break;
        }
        if (modelsList == null) {
            Supplementaries.LOGGER.warn("No visuals matched for book item: {}", (Object)stack);
            return List.of(missingModel);
        }
        return modelsList.models();
    }

    private static List<class_1091> getExtraModels() {
        ArrayList<class_1091> list = new ArrayList<class_1091>();
        for (Map.Entry entry : bookVisuals.getEntries()) {
            for (BookModelVisuals.VariantModelList model : (List)entry.getValue()) {
                for (BookModelVisuals visuals : model.models()) {
                    list.add(visuals.model());
                }
            }
        }
        return list;
    }

    public static void registerExtraModels(ClientHelper.SpecialModelEvent event) {
        PlaceableBookManagerClient.reload(class_310.method_1551().method_1478());
        PlaceableBookManagerClient.getExtraModels().forEach(arg_0 -> ((ClientHelper.SpecialModelEvent)event).register(arg_0));
    }
}

