/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.IOneUserInteractable;
import net.mehvahdjukaar.moonlight.api.block.IWaxable;
import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.screens.BlackBoardScreen;
import net.mehvahdjukaar.supplementaries.common.block.IGlowable;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.common.items.components.BlackboardData;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;

public class BlackboardBlockTile
extends class_2586
implements IOneUserInteractable,
IScreenProvider,
IWaxable,
IGlowable,
IExtraModelDataProvider {
    public static final ModelDataKey<BlackboardData> BLACKBOARD_KEY = ModBlockProperties.BLACKBOARD;
    @Nullable
    private UUID playerWhoMayEdit = null;
    private BlackboardData data = BlackboardData.EMPTY;

    public BlackboardBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.BLACKBOARD_TILE.get(), pos, state);
        this.clearPixels();
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(BLACKBOARD_KEY, (Object)this.data);
    }

    public void method_5431() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        super.method_5431();
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        if (tag.method_10545("Waxed") || tag.method_10545("Pixels")) {
            boolean waxed = tag.method_10545("Waxed") && tag.method_10577("Waxed");
            byte[][] pixels = new byte[16][16];
            if (tag.method_10545("Pixels")) {
                pixels = BlackboardData.unpackPixels(tag.method_10565("Pixels"));
            }
            this.data = new BlackboardData(pixels, false, waxed);
        } else if (tag.method_10545("values")) {
            class_6903 ops = registries.method_57093((DynamicOps)class_2509.field_11560);
            this.data = (BlackboardData)BlackboardData.CODEC.parse((DynamicOps)ops, (Object)tag).getOrThrow();
        }
        this.requestModelReload();
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        if (!this.data.equals(BlackboardData.EMPTY)) {
            class_6903 ops = registries.method_57093((DynamicOps)class_2509.field_11560);
            tag.method_10543((class_2487)BlackboardData.CODEC.encodeStart((DynamicOps)ops, (Object)this.data).getOrThrow());
        }
    }

    protected void method_57567(class_9323.class_9324 components) {
        super.method_57567(components);
        if (!this.isEmpty()) {
            components.method_57840(ModComponents.BLACKBOARD.get(), (Object)this.data);
        }
    }

    protected void method_57568(class_2586.class_9473 componentInput) {
        super.method_57568(componentInput);
        BlackboardData data = (BlackboardData)componentInput.method_58694(ModComponents.BLACKBOARD.get());
        if (data != null) {
            this.data = data;
        } else {
            this.clearPixels();
        }
        this.requestModelReload();
    }

    public void method_57569(class_2487 tag) {
        super.method_57569(tag);
        tag.method_10551("values");
        tag.method_10551("glow");
        tag.method_10551("waxed");
    }

    public void clearPixels() {
        this.data = this.data.makeCleared();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void setPixel(int x, int y, byte b) {
        this.data = this.data.withPixel(x, y, b);
    }

    public byte getPixel(int xx, int yy) {
        return this.data.getPixel(xx, yy);
    }

    public void setPixels(byte[][] pixels) {
        this.data = this.data.withPixels(pixels);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 c = this.method_38244(registries);
        if (c.method_33133()) {
            c.method_10556("Empty", true);
        }
        return c;
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)NoticeBoardBlock.FACING);
    }

    public void openScreen(class_1937 level, class_1657 player, class_2350 direction) {
        BlackBoardScreen.open(this);
    }

    public void setWaxed(boolean b) {
        this.data = this.data.withWaxed(b);
    }

    public boolean isWaxed() {
        return this.data.isWaxed();
    }

    @Override
    public void setGlowing(boolean b) {
        this.data = this.data.withGlow(b);
    }

    @Override
    public boolean isGlowing() {
        return this.data.isGlow();
    }

    public UUID getCurrentUser() {
        return this.playerWhoMayEdit;
    }

    public void setCurrentUser(UUID playerWhoMayEdit) {
        this.playerWhoMayEdit = playerWhoMayEdit;
    }

    public boolean tryAcceptingClientPixels(class_3222 player, byte[][] pixels) {
        if (!this.canBeUsedBy(this.field_11867, (class_1297)player) || this.isWaxed()) {
            Supplementaries.LOGGER.warn("Player {} just tried to change non-editable blackboard block", (Object)player.method_5477().getString());
        }
        if (!CommonConfigs.Building.BLACKBOARD_COLOR.get().booleanValue()) {
            byte black = BlackboardBlock.colorToByte(class_1767.field_7963);
            byte white = BlackboardBlock.colorToByte(class_1767.field_7952);
            byte[][] byArray = pixels;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte[] pixel;
                for (byte b : pixel = byArray[i]) {
                    if (b == black || b == white) continue;
                    Supplementaries.LOGGER.warn("Player {} just tried to change blackboard block with colored pixels", (Object)player.method_5477().getString());
                    return false;
                }
            }
        }
        if (!this.data.hasSamePixels(pixels)) {
            this.field_11863.method_8396(null, this.field_11867, ModSounds.BLACKBOARD_DRAW.get(), class_3419.field_15245, 1.0f, 1.0f);
            this.setCurrentUser(null);
            this.setPixels(pixels);
            return true;
        }
        return false;
    }
}

