/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FaucetBlock;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetItemSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FluidOffer;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class FaucetBlockTile
extends class_2586
implements IExtraModelDataProvider {
    public static final ModelDataKey<class_5321<SoftFluid>> FLUID = ModBlockProperties.FLUID;
    public static final ModelDataKey<Integer> FLUID_COLOR = ModBlockProperties.FLUID_COLOR;
    public static final int COOLDOWN_PER_BOTTLE = 20;
    private int transferCooldown = 0;
    public final SoftFluidTank tempFluidHolder = SoftFluidTank.create((int)5, (class_7225.class_7874)Utils.hackyGetRegistryAccess());
    public static final Predicate<class_1297> NON_PLAYER = e -> e.method_5805() && !(e instanceof class_1657);

    public FaucetBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.FAUCET_TILE.get(), pos, state);
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        if (this.field_11863 != null && !this.tempFluidHolder.isEmpty()) {
            int color = this.tempFluidHolder.getCachedFlowingColor((class_1920)this.field_11863, this.field_11867);
            builder.with(FLUID, (Object)((class_5321)this.tempFluidHolder.getFluid().getHolder().method_40230().get()));
            builder.with(FLUID_COLOR, (Object)color);
        }
    }

    public void updateLight() {
        if (this.field_11863 == null) {
            return;
        }
        int light = this.tempFluidHolder.getFluidValue().getLuminosity();
        if (light != 0) {
            light = (int)class_3532.method_15363((float)((float)light / 2.0f), (float)1.0f, (float)7.0f);
        }
        if (light != (Integer)this.method_11010().method_11654((class_2769)FaucetBlock.LIGHT_LEVEL)) {
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)FaucetBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(light)), 2);
        }
    }

    public static void serverTick(class_1937 pLevel, class_2338 pPos, class_2680 pState, FaucetBlockTile tile) {
        if (tile.transferCooldown > 0) {
            --tile.transferCooldown;
        } else if (tile.isOpen()) {
            int cooldown = tile.tryExtract((class_3218)pLevel, false);
            tile.transferCooldown += cooldown;
        }
    }

    public boolean updateContainedFluidVisuals(class_3218 serverLevel) {
        SoftFluidStack previous = this.tempFluidHolder.getFluid().copy();
        boolean r = this.tryExtract(serverLevel, true) != 0;
        this.updateLight();
        if (previous.isSameFluidSameComponents(this.tempFluidHolder.getFluid())) {
            this.method_5431();
            serverLevel.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
        return r;
    }

    private int tryExtract(class_3218 level, boolean simulate) {
        class_2680 state = this.method_11010();
        class_2350 dir = (class_2350)state.method_11654((class_2769)FaucetBlock.FACING);
        class_2338 behind = this.field_11867.method_10093(dir.method_10153());
        class_2680 backState = level.method_8320(behind);
        if (backState.method_26215() || backState.method_26164(ModTags.FAUCET_CANT_INTERACT)) {
            return 0;
        }
        FaucetBehaviorsManager behaviors = FaucetBehaviorsManager.getInstance((class_1937)level);
        Integer filledAmount = this.runInteractions(behaviors.getBlockInteractions(), (class_1937)level, dir, behind, backState, simulate);
        if (filledAmount != null) {
            return filledAmount;
        }
        class_2586 tileBack = level.method_8321(behind);
        if (tileBack != null && (filledAmount = this.runInteractions(behaviors.getTileInteractions(), (class_1937)level, dir, behind, tileBack, simulate)) != null) {
            return filledAmount;
        }
        if (!this.isConnectedBelow() && !simulate && (CommonConfigs.Redstone.FAUCET_DROP_ITEMS.get().booleanValue() || CommonConfigs.Redstone.FAUCET_FILL_ENTITIES.get().booleanValue())) {
            for (FaucetItemSource bi : behaviors.getItemInteractions()) {
                class_1799 removed = bi.tryExtractItem((class_1937)level, behind, backState, dir, tileBack);
                if (removed.method_7960()) continue;
                if (!(CommonConfigs.Redstone.FAUCET_FILL_ENTITIES.get().booleanValue() && this.fillEntityBelow(removed) || !CommonConfigs.Redstone.FAUCET_DROP_ITEMS.get().booleanValue())) {
                    this.drop(removed);
                }
                return 20;
            }
        }
        class_3610 fluidState = level.method_8316(behind);
        filledAmount = this.runInteractions(behaviors.getSourceFluidInteractions(), (class_1937)level, dir, behind, fluidState, simulate);
        if (filledAmount != null) {
            return filledAmount;
        }
        return 0;
    }

    @Nullable
    private <T, S extends FaucetSource<T>> Integer runInteractions(Iterable<S> interactions, class_1937 level, class_2350 dir, class_2338 pos, T source, boolean justVisual) {
        for (FaucetSource inter : interactions) {
            FluidOffer fluid = inter.getProvidedFluid(level, pos, dir, source);
            if (fluid == null) continue;
            if (justVisual) {
                this.tempFluidHolder.setFluid(fluid.fluid());
                return 20;
            }
            Integer amountFilled = this.tryFillingBlockBelow(fluid);
            if (amountFilled == null) continue;
            if (amountFilled == 0) {
                return 0;
            }
            inter.drain(level, pos, dir, source, amountFilled);
            return amountFilled * 20;
        }
        return null;
    }

    private Integer tryFillingBlockBelow(FluidOffer offer) {
        class_2338 below = this.field_11867.method_10074();
        class_2680 belowState = this.field_11863.method_8320(below);
        FaucetBehaviorsManager behaviors = FaucetBehaviorsManager.getInstance(this.field_11863);
        for (FaucetTarget.BlState blState : behaviors.getTargetBlockInteractions()) {
            Integer res = blState.fill(this.field_11863, below, belowState, offer);
            if (res == null) continue;
            return res;
        }
        class_2586 tileBelow = this.field_11863.method_8321(below);
        if (tileBelow != null) {
            for (FaucetTarget.Tile bi : behaviors.getTargetTileInteractions()) {
                Integer res = bi.fill(this.field_11863, below, tileBelow, offer);
                if (res == null) continue;
                return res;
            }
        }
        class_3610 class_36102 = belowState.method_26227();
        for (FaucetTarget.Fluid bi : behaviors.getTargetFluidInteractions()) {
            Integer res = bi.fill(this.field_11863, below, class_36102, offer);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public boolean isOpen() {
        return (Boolean)this.method_11010().method_11654((class_2769)class_2741.field_12484) ^ (Boolean)this.method_11010().method_11654((class_2769)class_2741.field_12515);
    }

    public boolean hasWater() {
        return (Boolean)this.method_11010().method_11654((class_2769)FaucetBlock.HAS_WATER);
    }

    public boolean isConnectedBelow() {
        return (Boolean)this.method_11010().method_11654((class_2769)FaucetBlock.CONNECTED);
    }

    private void drop(class_1799 extracted) {
        class_2338 pos = this.field_11867;
        class_1542 drop = new class_1542(this.field_11863, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, extracted);
        drop.method_18799(new class_243(0.0, 0.0, 0.0));
        this.field_11863.method_8649((class_1297)drop);
        float f = (this.field_11863.field_9229.method_43057() - 0.5f) / 4.0f;
        this.field_11863.method_8396(null, pos, class_3417.field_15219, class_3419.field_15245, 0.3f, 0.5f + f);
    }

    private boolean fillEntityBelow(class_1799 stack) {
        List list = this.field_11863.method_8333((class_1297)null, new class_238(this.field_11867).method_989(0.0, -0.75, 0.0), NON_PLAYER);
        Collections.shuffle(list);
        for (class_1297 entity : list) {
            if (!(stack = ItemsUtil.tryAddingItem(stack, this.field_11863, entity)).method_7960()) continue;
            return true;
        }
        return false;
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.transferCooldown = tag.method_10550("TransferCooldown");
        this.tempFluidHolder.load(tag, registries);
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10569("TransferCooldown", this.transferCooldown);
        this.tempFluidHolder.save(tag, registries);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    @FunctionalInterface
    public static interface FillAction {
        public int tryExecute(int var1);
    }
}

