/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Locale;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.ClockBlock;
import net.mehvahdjukaar.supplementaries.common.items.AbstractMobContainerItem;
import net.mehvahdjukaar.supplementaries.common.items.components.MobContainerView;
import net.mehvahdjukaar.supplementaries.common.items.components.SoftFluidTankView;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.IMobContainerProvider;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class JarBlockTile
extends ItemDisplayTile
implements IMobContainerProvider,
ISoftFluidTankProvider,
IExtraModelDataProvider {
    public static final ModelDataKey<class_5321<SoftFluid>> FLUID = ModBlockProperties.FLUID;
    public static final ModelDataKey<Float> FILL_LEVEL = ModBlockProperties.FILL_LEVEL;
    public final MobContainer mobContainer;
    public final SoftFluidTank fluidHolder;

    public JarBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.JAR_TILE.get(), pos, state, 12);
        int capacity = CommonConfigs.Functional.JAR_CAPACITY.get();
        this.fluidHolder = SoftFluidTank.create((int)capacity, (class_7225.class_7874)Utils.hackyGetRegistryAccess());
        AbstractMobContainerItem item = (AbstractMobContainerItem)state.method_26204().method_8389();
        this.mobContainer = new MobContainer(item.getMobContainerWidth(), item.getMobContainerHeight(), true);
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        if (!this.fluidHolder.isEmpty()) {
            builder.with(FLUID, (Object)((class_5321)this.fluidHolder.getFluid().getHolder().method_40230().get())).with(FILL_LEVEL, (Object)Float.valueOf(this.fluidHolder.getHeight(1.0f)));
        }
    }

    protected void method_57568(class_2586.class_9473 componentInput) {
        MobContainerView mobView;
        super.method_57568(componentInput);
        SoftFluidTankView fluidView = (SoftFluidTankView)componentInput.method_58694(ModComponents.SOFT_FLUID_CONTENT.get());
        if (fluidView != null) {
            fluidView.apply(this.fluidHolder);
        }
        if ((mobView = (MobContainerView)componentInput.method_58694(ModComponents.MOB_HOLDER_CONTENT.get())) != null) {
            mobView.apply(this.mobContainer);
        }
    }

    protected void method_57567(class_9323.class_9324 components) {
        super.method_57567(components);
        if (!this.fluidHolder.isEmpty()) {
            components.method_57840(ModComponents.SOFT_FLUID_CONTENT.get(), (Object)SoftFluidTankView.of(this.fluidHolder));
        }
        if (!this.mobContainer.isEmpty()) {
            components.method_57840(ModComponents.MOB_HOLDER_CONTENT.get(), (Object)MobContainerView.of(this.mobContainer));
        }
    }

    public void method_57569(class_2487 tag) {
        super.method_57569(tag);
        tag.method_10551("fluid");
        tag.method_10551("MobHolder");
        tag.method_10551("BucketHolder");
    }

    public void updateTileOnInventoryChanged() {
        this.field_11863.method_8452(this.field_11867, this.method_11010().method_26204());
        int light = this.fluidHolder.getFluidValue().getLuminosity();
        if (light != (Integer)this.method_11010().method_11654((class_2769)ModBlockProperties.LIGHT_LEVEL_0_15)) {
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)ModBlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 2);
        }
    }

    public void updateClientVisualsOnLoad() {
        super.updateClientVisualsOnLoad();
        this.requestModelReload();
    }

    public boolean handleInteraction(class_1657 player, class_1268 hand, class_1937 level, class_2338 pos) {
        class_1799 handStack = player.method_5998(hand);
        class_1799 displayedStack = this.getDisplayedItem();
        if (this.canInteractWithSoftFluidTank() && this.fluidHolder.interactWithPlayer(player, hand, level, pos)) {
            return true;
        }
        if (this.tryAddingItem(handStack, player, hand)) {
            return true;
        }
        if (this.method_5442() && this.fluidHolder.isEmpty() && this.mobContainer.interactWithBucket(handStack, level, player.method_24515(), player, hand)) {
            return true;
        }
        if (!player.method_5715() && CommonConfigs.Functional.JAR_EAT.get().booleanValue()) {
            if (this.fluidHolder.tryDrinkUpFluid(player, level)) {
                return true;
            }
            if (displayedStack.method_57826(class_9334.field_50075) && player.method_7332(false) && !player.method_7337()) {
                player.method_60492(level, displayedStack);
                return true;
            }
        }
        return this.handleExtractItem(player, hand);
    }

    public class_1799 extractItem() {
        for (int j = this.method_5439() - 1; j >= 0; --j) {
            class_1799 s = this.method_5438(j);
            if (s.method_7960()) continue;
            this.method_5441(j);
            return s;
        }
        return class_1799.field_8037;
    }

    public boolean handleExtractItem(class_1657 player, class_1268 hand) {
        if (!player.method_5998(hand).method_7960()) {
            return false;
        }
        class_1799 extracted = this.extractItem();
        if (!extracted.method_7960()) {
            Utils.swapItem((class_1657)player, (class_1268)hand, (class_1799)extracted);
            return true;
        }
        return false;
    }

    public boolean tryAddingItem(class_1799 stack, @Nullable class_1657 player, class_1268 handIn) {
        class_1799 handStack = stack.method_7972();
        handStack.method_7939(1);
        if (this.tryAddingItem(handStack)) {
            if (player != null) {
                class_1799 returnStack = class_1799.field_8037;
                class_1937 level = player.method_37908();
                level.method_8396(player, this.field_11867, ModSounds.JAR_COOKIE.get(), class_3419.field_15245, 1.0f, 0.9f + level.field_9229.method_43057() * 0.1f);
                player.method_7259(class_3468.field_15372.method_14956((Object)handStack.method_7909()));
                if (!player.method_7337()) {
                    Utils.swapItem((class_1657)player, (class_1268)handIn, (class_1799)returnStack);
                }
            }
            return true;
        }
        return false;
    }

    public boolean tryAddingItem(class_1799 itemstack) {
        for (int i = 0; i < this.method_11282().size(); ++i) {
            if (!this.method_5437(i, itemstack)) continue;
            this.method_5447(i, itemstack);
            return true;
        }
        return false;
    }

    public void clearAllContents() {
        this.fluidHolder.clear();
        this.mobContainer.clear();
        this.method_11281(class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037));
    }

    public boolean isPonyJar() {
        if (this.method_16914()) {
            class_2561 c = this.method_5797();
            return c != null && c.getString().toLowerCase(Locale.ROOT).contains("cum");
        }
        return false;
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.fluidHolder.load(tag, registries);
        this.mobContainer.load(tag, registries);
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        this.fluidHolder.save(tag, registries);
        this.mobContainer.save(tag, registries);
    }

    public boolean hasContent() {
        return !this.method_5442() || !this.mobContainer.isEmpty() || !this.fluidHolder.isEmpty();
    }

    public boolean isFull() {
        return this.method_11282().stream().noneMatch(class_1799::method_7960);
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        return this.method_5437(index, stack);
    }

    public boolean method_5437(int index, class_1799 stack) {
        if (this.method_5438(index).method_7947() < this.method_5444() && CommonConfigs.Functional.JAR_COOKIES.get().booleanValue() && this.fluidHolder.isEmpty() && this.mobContainer.isEmpty()) {
            return stack.method_31573(ModTags.COOKIES);
        }
        return false;
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return true;
    }

    @Override
    public MobContainer getMobContainer() {
        return this.mobContainer;
    }

    @Override
    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)ClockBlock.FACING);
    }

    public static void tick(class_1937 pLevel, class_2338 pPos, class_2680 pState, JarBlockTile tile) {
        tile.mobContainer.tick(pLevel, pPos);
    }

    public SoftFluidTank getSoftFluidTank() {
        return this.fluidHolder;
    }

    public boolean canInteractWithSoftFluidTank() {
        return CommonConfigs.Functional.JAR_LIQUIDS.get() != false && this.method_5442() && (this.mobContainer.isEmpty() || this.isPonyJar());
    }
}

