/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Pair;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.StatueBlock;
import net.mehvahdjukaar.supplementaries.common.utils.Credits;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3489;
import net.minecraft.class_5544;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class StatueBlockTile
extends ItemDisplayTile {
    @Nullable
    private class_9296 playerSkin = null;
    private StatuePose pose = StatuePose.STANDING;
    private boolean isWaving = false;
    private class_2680 candle = null;

    public StatueBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.STATUE_TILE.get(), pos, state);
    }

    protected void method_57568(class_2586.class_9473 componentInput) {
        super.method_57568(componentInput);
        if (componentInput.method_58694(class_9334.field_49631) != null) {
            this.updateSkin();
        }
    }

    public StatuePose getPose() {
        return this.pose;
    }

    public boolean isWaving() {
        return this.isWaving;
    }

    public class_2680 hasCandle() {
        return this.candle;
    }

    @Nullable
    public class_9296 getPlayerSkin() {
        return this.playerSkin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayerSkin(@Nullable class_9296 owner) {
        StatueBlockTile statueBlockTile = this;
        synchronized (statueBlockTile) {
            this.playerSkin = owner;
        }
        if (this.playerSkin != null && !this.playerSkin.method_57511()) {
            this.playerSkin.method_57507().thenAcceptAsync(resolvableProfile -> {
                this.playerSkin = resolvableProfile;
                this.method_5431();
            }, class_2631.field_45147);
        } else {
            this.method_5431();
        }
    }

    private void updateSkin() {
        if (this.method_16914()) {
            String name = this.method_5797().getString().toLowerCase(Locale.ROOT);
            Pair<UUID, String> profile = Credits.INSTANCE.statues().get(name);
            if (profile != null) {
                this.setPlayerSkin(new class_9296(Optional.empty(), Optional.of((UUID)profile.getFirst()), new PropertyMap()));
            }
        } else {
            this.playerSkin = null;
        }
    }

    public void updateClientVisualsOnLoad() {
        this.updateSkin();
        class_1799 stack = this.getDisplayedItem();
        this.pose = StatuePose.getPose(stack);
        this.isWaving = (Boolean)this.method_11010().method_11654((class_2769)StatueBlock.POWERED);
        if (this.pose == StatuePose.CANDLE) {
            class_2248 b = ((class_1747)stack.method_7909()).method_7711();
            if (!(b instanceof class_5544)) {
                b = class_2246.field_27099;
            }
            this.candle = (class_2680)b.method_9564().method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(true));
        }
    }

    public void updateTileOnInventoryChanged() {
        boolean flag;
        boolean bl = flag = StatuePose.getPose(this.getDisplayedItem()) == StatuePose.CANDLE;
        if (flag != (Boolean)this.method_11010().method_11654((class_2769)StatueBlock.LIT)) {
            this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)StatueBlock.LIT, (Comparable)Boolean.valueOf(flag)));
        }
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        return this.method_5437(index, stack);
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return true;
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)NoticeBoardBlock.FACING);
    }

    public static enum StatuePose {
        STANDING,
        HOLDING,
        CANDLE,
        SWORD,
        TOOL,
        GLOBE,
        SEPIA_GLOBE;


        public static StatuePose getPose(class_1799 stack) {
            if (stack.method_7960()) {
                return STANDING;
            }
            class_1792 i = stack.method_7909();
            if (MiscUtils.isSword(i)) {
                return SWORD;
            }
            if (MiscUtils.isTool(i)) {
                return TOOL;
            }
            if (i == ModRegistry.GLOBE_ITEM.get()) {
                return GLOBE;
            }
            if (i == ModRegistry.GLOBE_SEPIA_ITEM.get()) {
                return SEPIA_GLOBE;
            }
            return stack.method_31573(class_3489.field_26989) ? CANDLE : HOLDING;
        }

        public boolean isGlobe() {
            return this == GLOBE || this == SEPIA_GLOBE;
        }
    }
}

