/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.components;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_5632;
import net.minecraft.class_9299;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class SelectableContainerContent<M extends Mut<?>>
implements class_5632,
class_9299 {
    protected final class_2371<class_1799> stacks;
    protected final int selectedSlot;
    protected final int selectedItemCount;
    protected final boolean empty;

    public SelectableContainerContent(List<class_1799> stacks, int selected) {
        this.stacks = class_2371.method_10213((int)stacks.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < stacks.size(); ++i) {
            this.stacks.set(i, (Object)stacks.get(i));
        }
        this.selectedSlot = selected;
        this.selectedItemCount = SelectableContainerContent.computeSelectedItemCount(stacks, selected);
        this.empty = stacks.stream().allMatch(class_1799::method_7960);
    }

    public abstract M toMutable();

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    public int getSelectedItemCount() {
        return this.selectedItemCount;
    }

    public List<class_1799> getContentCopy() {
        return this.stacks.stream().map(class_1799::method_7972).toList();
    }

    @ApiStatus.Internal
    public List<class_1799> getContentUnsafe() {
        return this.stacks;
    }

    public class_1799 getSelectedUnsafe() {
        return (class_1799)this.stacks.get(this.selectedSlot);
    }

    public class_1799 getSelected() {
        return ((class_1799)this.stacks.get(this.selectedSlot)).method_7972();
    }

    public class_1792 getSelectedItem() {
        return ((class_1799)this.stacks.get(this.selectedSlot)).method_7909();
    }

    public int getSelectedCount() {
        return ((class_1799)this.stacks.get(this.selectedSlot)).method_7947();
    }

    public class_1799 getStackInSlot(int slot) {
        SelectableContainerContent.validateSlotIndex(slot, this.stacks);
        return ((class_1799)this.stacks.get(slot)).method_7972();
    }

    public int getSize() {
        return this.stacks.size();
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltipAdder, class_1836 tooltipFlag) {
        if (this.selectedItemCount != 0) {
            tooltipAdder.accept((class_2561)class_2561.method_43469((String)"message.supplementaries.quiver.tooltip", (Object[])new Object[]{this.getSelectedItem().method_7848(), this.selectedItemCount}).method_27692(class_124.field_1080));
        }
    }

    private static int computeSelectedItemCount(List<class_1799> stacks, int sel) {
        class_1799 selected = stacks.get(sel);
        int amount = 0;
        for (class_1799 item : stacks) {
            if (!class_1799.method_31577((class_1799)selected, (class_1799)item)) continue;
            amount += item.method_7947();
        }
        return amount;
    }

    protected static void validateSlotIndex(int slot, List<?> list) {
        if (slot < 0 || slot >= list.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + list.size() + ")");
        }
    }

    public int getBarSize() {
        return Math.min(1 + 12 * this.selectedItemCount / (((class_1799)this.stacks.get(this.selectedSlot)).method_7914() * this.getSize()), 13);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectableContainerContent that = (SelectableContainerContent)o;
        return this.selectedSlot == that.selectedSlot && this.selectedItemCount == that.selectedItemCount && class_1799.method_57362(this.stacks, that.stacks);
    }

    public int hashCode() {
        return Objects.hash(class_1799.method_57361(this.stacks), this.selectedSlot);
    }

    public static abstract class Mut<T extends SelectableContainerContent<?>> {
        protected final class_2371<class_1799> stacks;
        protected int selectedSlot;

        protected Mut(SelectableContainerContent<?> original) {
            this.stacks = class_2371.method_10213((int)original.stacks.size(), (Object)class_1799.field_8037);
            for (int i = 0; i < original.stacks.size(); ++i) {
                this.stacks.set(i, (Object)((class_1799)original.stacks.get(i)).method_7972());
            }
            this.selectedSlot = original.selectedSlot;
        }

        public abstract T toImmutable();

        public void setStackInSlot(int slot, class_1799 stack) {
            SelectableContainerContent.validateSlotIndex(slot, this.stacks);
            this.stacks.set(slot, (Object)stack);
        }

        public class_1799 getStackInSlot(int slot) {
            SelectableContainerContent.validateSlotIndex(slot, this.stacks);
            return (class_1799)this.stacks.get(slot);
        }

        public class_1799 getSelected() {
            return (class_1799)this.stacks.get(this.selectedSlot);
        }

        public List<class_1799> getStacks() {
            return this.stacks;
        }

        public int getSlots() {
            return this.stacks.size();
        }

        protected void updateSelectedIfNeeded() {
            this.cycle(0);
        }

        public boolean setSelectedSlot(int selectedSlot) {
            SelectableContainerContent.validateSlotIndex(selectedSlot, this.stacks);
            if (!((class_1799)this.stacks.get(selectedSlot)).method_7960()) {
                this.selectedSlot = selectedSlot;
                return true;
            }
            return false;
        }

        public int getSelectedSlot() {
            return this.selectedSlot;
        }

        @Nullable
        public class_1799 tryRemovingOne() {
            int i = 0;
            for (class_1799 s : this.stacks) {
                if (!s.method_7960()) {
                    class_1799 extracted = this.extractItem(i, s.method_7947(), false);
                    this.updateSelectedIfNeeded();
                    return extracted;
                }
                ++i;
            }
            return null;
        }

        public boolean isItemValid(class_1799 stack) {
            return this.isItemValid(0, stack);
        }

        public abstract boolean isItemValid(int var1, class_1799 var2);

        public class_1799 tryAdding(class_1799 toInsert, boolean onlyOnExisting) {
            if (toInsert.method_7960()) {
                return toInsert;
            }
            if (onlyOnExisting) {
                int finalCount = toInsert.method_7947();
                for (int i = 0; i < this.getSlots() && finalCount > 0; ++i) {
                    class_1799 s = this.getStackInSlot(i);
                    if (!class_1799.method_31577((class_1799)s, (class_1799)toInsert)) continue;
                    int newCount = Math.min(s.method_7914(), s.method_7947() + finalCount);
                    int increment = newCount - s.method_7947();
                    finalCount -= increment;
                    s.method_7933(increment);
                }
                toInsert.method_7939(finalCount);
            } else {
                for (int i = 0; i < this.getSlots(); ++i) {
                    if (!(toInsert = this.insertItem(i, toInsert, false)).method_7960()) continue;
                    return class_1799.field_8037;
                }
            }
            return toInsert;
        }

        public class_1799 tryAdding(class_1799 pInsertedStack) {
            return this.tryAdding(pInsertedStack, false);
        }

        public boolean cycle() {
            return this.cycle(1);
        }

        public boolean cycle(boolean clockWise) {
            return this.cycle(clockWise ? 1 : -1);
        }

        public boolean cycle(int slotsMoved) {
            class_1799 selected;
            int originalSlot = this.selectedSlot;
            if (slotsMoved == 0 && !(selected = (class_1799)this.stacks.get(this.selectedSlot)).method_7960()) {
                return false;
            }
            int maxSlots = this.stacks.size();
            this.selectedSlot = (maxSlots + (this.selectedSlot + (slotsMoved %= maxSlots))) % maxSlots;
            for (int i = 0; i < maxSlots && (selected = (class_1799)this.stacks.get(this.selectedSlot)).method_7960(); ++i) {
                this.selectedSlot = (maxSlots + (this.selectedSlot + (slotsMoved >= 0 ? 1 : -1))) % maxSlots;
            }
            return originalSlot != this.selectedSlot;
        }

        public class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
            boolean reachedLimit;
            if (stack.method_7960()) {
                return class_1799.field_8037;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            SelectableContainerContent.validateSlotIndex(slot, this.stacks);
            class_1799 existing = (class_1799)this.stacks.get(slot);
            int limit = this.getStackLimit(slot, stack);
            if (!existing.method_7960()) {
                if (!class_1799.method_31577((class_1799)stack, (class_1799)existing)) {
                    return stack;
                }
                limit -= existing.method_7947();
            }
            if (limit <= 0) {
                return stack;
            }
            boolean bl = reachedLimit = stack.method_7947() > limit;
            if (!simulate) {
                if (existing.method_7960()) {
                    this.stacks.set(slot, (Object)(reachedLimit ? stack.method_46651(limit) : stack));
                } else {
                    existing.method_7933(reachedLimit ? limit : stack.method_7947());
                }
            }
            return reachedLimit ? stack.method_46651(stack.method_7947() - limit) : class_1799.field_8037;
        }

        public int getSlotLimit(int slot) {
            return 99;
        }

        protected int getStackLimit(int slot, class_1799 stack) {
            return Math.min(this.getSlotLimit(slot), stack.method_7914());
        }

        public class_1799 extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return class_1799.field_8037;
            }
            SelectableContainerContent.validateSlotIndex(slot, this.stacks);
            class_1799 existing = (class_1799)this.stacks.get(slot);
            if (existing.method_7960()) {
                return class_1799.field_8037;
            }
            int toExtract = Math.min(amount, existing.method_7914());
            if (existing.method_7947() <= toExtract) {
                if (!simulate) {
                    this.stacks.set(slot, (Object)class_1799.field_8037);
                    return existing;
                }
                return existing.method_7972();
            }
            if (!simulate) {
                this.stacks.set(slot, (Object)existing.method_46651(existing.method_7947() - toExtract));
            }
            return existing.method_46651(toExtract);
        }

        public void consumeSelected(int toDecrement) {
            int size = this.stacks.size();
            if (toDecrement <= 0 || size == 0) {
                return;
            }
            for (int j = 0; j < size; ++j) {
                int i = (this.selectedSlot + j) % size;
                class_1799 s = (class_1799)this.stacks.get(i);
                if (s.method_7960()) continue;
                int decrement = Math.min(toDecrement, s.method_7947());
                s.method_7934(decrement);
                if (s.method_7960()) {
                    this.setStackInSlot(i, class_1799.field_8037);
                }
                if ((toDecrement -= decrement) > 0) continue;
                return;
            }
            Supplementaries.error("Failed to consume from SelectableContainerContent, not enough items", new Object[0]);
        }
    }
}

