/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3542;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5778;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class BarnaclesMultifaceGrowthFeature
extends class_3031<Config> {
    public BarnaclesMultifaceGrowthFeature() {
        super(Config.CODEC);
    }

    public boolean method_13151(class_5821<Config> context) {
        class_5281 worldGenLevel = context.method_33652();
        class_2338 startPos = context.method_33655();
        class_5819 randomSource = context.method_33654();
        Config config = (Config)context.method_33656();
        class_2680 startState = worldGenLevel.method_8320(startPos);
        if (startState.method_27852((class_2248)config.placeBlock)) {
            config.placeBlock.method_41432().method_41450(startState, (class_1936)worldGenLevel, startPos, randomSource);
            return true;
        }
        if (!BarnaclesMultifaceGrowthFeature.isAirOrWater(startState)) {
            return false;
        }
        Collection<class_2350> allDirs = config.getShuffledDirections(randomSource);
        if (BarnaclesMultifaceGrowthFeature.placeGrowthIfPossible(worldGenLevel, startPos, worldGenLevel.method_8320(startPos), config, randomSource, allDirs)) {
            return true;
        }
        class_2338.class_2339 mutableBlockPos = startPos.method_25503();
        boolean placed = false;
        block0: for (class_2350 direction : allDirs) {
            mutableBlockPos.method_10101((class_2382)startPos);
            List<class_2350> list2 = config.getShuffledDirectionsExcept(randomSource, direction.method_10153());
            for (int i = 0; i < config.searchRange; ++i) {
                mutableBlockPos.method_25505((class_2382)startPos, direction);
                class_2680 blockState = worldGenLevel.method_8320((class_2338)mutableBlockPos);
                if (!BarnaclesMultifaceGrowthFeature.isAirOrWater(blockState) && !blockState.method_27852((class_2248)config.placeBlock)) continue block0;
                if (!BarnaclesMultifaceGrowthFeature.placeGrowthIfPossible(worldGenLevel, (class_2338)mutableBlockPos, blockState, config, randomSource, list2)) continue;
                placed = true;
                return true;
            }
        }
        return placed;
    }

    public static boolean placeGrowthIfPossible(class_5281 level, class_2338 pos, class_2680 state, Config config, class_5819 random, Collection<class_2350> directions) {
        class_2350 direction;
        class_2680 blockState;
        class_2338.class_2339 mutableBlockPos = pos.method_25503();
        Iterator<class_2350> sides = directions.iterator();
        do {
            if (sides.hasNext()) continue;
            return false;
        } while (BarnaclesMultifaceGrowthFeature.cantBePlacedOn(blockState = level.method_8320((class_2338)mutableBlockPos.method_25505((class_2382)pos, direction = sides.next())), config));
        class_2680 blockState2 = config.placeBlock.method_33362(state, (class_1922)level, pos, direction);
        if (blockState2 == null) {
            return false;
        }
        level.method_8652(pos, blockState2, 3);
        if (random.method_43057() < config.chanceOfSpreading) {
            config.placeBlock.method_41432().method_41447(blockState2, (class_1936)level, pos, direction, random, false);
        }
        return true;
    }

    private static boolean cantBePlacedOn(class_2680 state, Config config) {
        return state.method_40143(config.cantBePlacedOn) || BarnaclesMultifaceGrowthFeature.isAirOrWater(state);
    }

    private static boolean isAirOrWater(class_2680 state) {
        return state.method_26215() || state.method_27852(class_2246.field_10382);
    }

    private static boolean isCliffFace(class_2338 pos, class_1937 leve, class_2350 myFace) {
        if (myFace.method_10166().method_10178()) {
            return false;
        }
        class_2680 onBlock = leve.method_8320(pos.method_10093(myFace.method_10153()));
        return false;
    }

    public record Config(class_5778 placeBlock, int searchRange, PlacementEnvironment environment, boolean requiresWater, float chanceOfSpreading, class_6885<class_2248> cantBePlacedOn) implements class_3037
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("block").flatXmap(Config::validate, DataResult::success).orElse((Object)((class_5778)class_2246.field_28411)).forGetter(c -> c.placeBlock), (App)Codec.intRange((int)1, (int)64).optionalFieldOf("search_range", (Object)10).forGetter(c -> c.searchRange), (App)PlacementEnvironment.CODEC.optionalFieldOf("placement_environment", (Object)PlacementEnvironment.ANY).forGetter(c -> c.environment), (App)Codec.BOOL.optionalFieldOf("requires_water", (Object)false).forGetter(c -> c.requiresWater), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("chance_of_spreading", (Object)Float.valueOf(0.5f)).forGetter(c -> Float.valueOf(c.chanceOfSpreading)), (App)class_6895.method_40340((class_5321)class_7924.field_41254).fieldOf("cant_be_placed_on").forGetter(c -> c.cantBePlacedOn)).apply((Applicative)instance, Config::new));

        private static DataResult<class_5778> validate(class_2248 block) {
            if (block instanceof class_5778) {
                class_5778 multifaceBlock = (class_5778)block;
                return DataResult.success((Object)multifaceBlock);
            }
            return DataResult.error(() -> "Growth block should be a multiface block");
        }

        public List<class_2350> getShuffledDirectionsExcept(class_5819 random, class_2350 direction) {
            return class_156.method_43252(Stream.of(class_2350.values()).filter(direction2 -> direction2 != direction), (class_5819)random);
        }

        public Collection<class_2350> getShuffledDirections(class_5819 random) {
            return class_2350.method_42014((class_5819)random);
        }
    }

    private static enum PlacementEnvironment implements class_3542
    {
        ANY,
        CLIFFS;

        public static final Codec<PlacementEnvironment> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(PlacementEnvironment::values);
        }
    }
}

