/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.worldgen.LocatedStructure;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2810;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_6833;
import net.minecraft.class_6862;
import net.minecraft.class_6871;
import net.minecraft.class_6872;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7869;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class LegacyStructureLocator {
    private static final Comparator<Vector2i> COMPARATOR = (o1, o2) -> Float.compare(o1.lengthSquared(), o2.lengthSquared());

    @Nullable
    public static LocatedStruct findNearestMapFeature(class_3218 level, @NotNull class_6885<class_3195> targets, class_2338 pos, int maximumChunkDistance, boolean newlyGenerated, int maxSearches, boolean exitEarly) {
        List<LocatedStruct> found = LegacyStructureLocator.findNearestMapFeatures(level, targets, pos, maximumChunkDistance, newlyGenerated, 1, maxSearches, exitEarly);
        if (!found.isEmpty()) {
            return found.get(0);
        }
        return null;
    }

    public static List<LocatedStruct> findNearestMapFeatures(class_3218 level, @NotNull class_6862<class_3195> tagKey, class_2338 pos, int maximumChunkDistance, boolean newlyGenerated, int requiredCount, int maxSearches, boolean exitEarly) {
        class_6885 targets = level.method_30349().method_30530(class_7924.field_41246).method_40266(tagKey).orElse(null);
        return LegacyStructureLocator.findNearestMapFeatures(level, (class_6885<class_3195>)targets, pos, maximumChunkDistance, newlyGenerated, requiredCount, maxSearches, exitEarly);
    }

    public static List<LocatedStruct> findNearestMapFeatures(class_3218 level, class_6885<class_3195> taggedStructures, class_2338 pos, int maximumChunkDistance, boolean newlyGenerated, int requiredCount, int maxSearches, boolean exitEarly) {
        if (taggedStructures == null) {
            return List.of();
        }
        if (taggedStructures.method_40247() > maxSearches) {
            ArrayList list = new ArrayList(taggedStructures.method_40239().toList());
            Collections.shuffle(list);
            taggedStructures = class_6885.method_40242(list.subList(0, maxSearches));
        }
        List<LocatedStruct> foundStructures = new ArrayList<LocatedStruct>();
        if (!level.method_8503().method_27728().method_28057().method_28029()) {
            return foundStructures;
        }
        if (taggedStructures.method_40247() == 0) {
            Supplementaries.LOGGER.error("Found empty target structures for structure map. Its likely some mod broke some vanilla tag. Check your logs!");
            return foundStructures;
        }
        List selectedTargets = taggedStructures.method_40239().toList();
        class_2794 chunkGenerator = level.method_14178().method_12129();
        double maxDist = Double.MAX_VALUE;
        selectedTargets = new ArrayList(selectedTargets);
        Collections.shuffle(selectedTargets);
        Supplementaries.LOGGER.info("Searching for closest structure among {} from pos {}", (Object)Arrays.toString(selectedTargets.stream().map(class_6880::method_55840).toArray()), (Object)pos);
        Object2ObjectArrayMap reachableTargetsMap = new Object2ObjectArrayMap();
        class_7869 structureState = level.method_14178().method_46642();
        for (class_6880 holder : selectedTargets) {
            for (Object structureplacement : structureState.method_46708(holder)) {
                reachableTargetsMap.computeIfAbsent(structureplacement, placement -> new ObjectArraySet()).add(holder);
            }
        }
        if (reachableTargetsMap.isEmpty()) {
            return foundStructures;
        }
        ArrayList<Pair> list = new ArrayList<Pair>(reachableTargetsMap.size());
        int maxSpacing = 1;
        class_5138 structuremanager = level.method_27056();
        for (Map.Entry entry : reachableTargetsMap.entrySet()) {
            class_6874 placement2 = (class_6874)entry.getKey();
            if (placement2 instanceof class_6871) {
                double d1;
                class_6871 concentricringsstructureplacement = (class_6871)placement2;
                Pair foundPair = chunkGenerator.method_40148((Set)entry.getValue(), level, structuremanager, pos, newlyGenerated, concentricringsstructureplacement);
                if (foundPair == null || !((d1 = pos.method_10262((class_2382)foundPair.getFirst())) < maxDist)) continue;
                maxDist = d1;
                foundStructures.add(new LocatedStruct((Pair<class_2338, class_6880<class_3195>>)foundPair));
                continue;
            }
            if (!(placement2 instanceof class_6872)) continue;
            class_6872 randomPlacement = (class_6872)placement2;
            list.add(Pair.of((Object)randomPlacement, (Object)((Set)entry.getValue())));
            maxSpacing = Math.max(maxSpacing, randomPlacement.method_41632());
        }
        if (!list.isEmpty()) {
            int chunkX = class_4076.method_18675((int)pos.method_10263());
            int n = class_4076.method_18675((int)pos.method_10260());
            long seed = level.method_8412();
            class_5138 manager = level.method_27056();
            block3: for (int k = 0; k <= maximumChunkDistance / maxSpacing; ++k) {
                int outerRing = (k + 1) * maxSpacing;
                int innerRing = k * maxSpacing;
                TreeMap possiblePositions = new TreeMap(COMPARATOR);
                for (Pair p : list) {
                    class_6872 placement3 = (class_6872)p.getFirst();
                    int spacing = placement3.method_41632();
                    for (int r = innerRing; r < outerRing; r += spacing) {
                        LegacyStructureLocator.addAllPossibleFeatureChunksAtDistance(chunkX, n, r, seed, placement3, c -> {
                            List ll;
                            Vector2i v = new Vector2i(c.field_9181 - chunkX, c.field_9180 - chunkZ);
                            if (possiblePositions.containsKey(v)) {
                                // empty if block
                            }
                            if (!(ll = possiblePositions.computeIfAbsent(v, o -> new ArrayList())).contains(p)) {
                                ll.add(p);
                            }
                        });
                    }
                }
                boolean lessPrecision = innerRing * 16 > 2000;
                int earlyStopAt = exitEarly || lessPrecision ? requiredCount : Integer.MAX_VALUE;
                for (Map.Entry e : possiblePositions.entrySet()) {
                    Vector2i vec2i = e.getKey();
                    class_1923 chunkPos = new class_1923(vec2i.x() + chunkX, vec2i.y() + n);
                    List structuresThatCanSpawnAtChunkPos = (List)e.getValue();
                    for (Pair pp : structuresThatCanSpawnAtChunkPos) {
                        foundStructures.addAll(LegacyStructureLocator.getStructuresAtChunkPos((Set)pp.getSecond(), (class_4538)level, manager, newlyGenerated, (class_6872)pp.getFirst(), chunkPos, earlyStopAt));
                    }
                    if (foundStructures.size() < requiredCount) continue;
                    break block3;
                }
            }
        }
        foundStructures.sort(Comparator.comparingDouble(f -> pos.method_10262((class_2382)f.pos)));
        if (foundStructures.size() >= requiredCount) {
            foundStructures = (List)Lists.partition(foundStructures, (int)requiredCount).get(0);
        }
        if (newlyGenerated) {
            for (LocatedStruct locatedStruct : foundStructures) {
                if (locatedStruct.start == null || !locatedStruct.start.method_14979()) continue;
                structuremanager.method_39784(locatedStruct.start);
            }
        }
        List<LocatedStructure> newStr = foundStructures.stream().map(s -> LocatedStructure.relativeTo(s.pos, s.structure, s.start, pos)).toList();
        Supplementaries.LOGGER.info("\n Structure locator found {} structures: \n{}", (Object)foundStructures.size(), (Object)String.join((CharSequence)"\n", (CharSequence[])newStr.stream().map(LocatedStructure::toString).toArray(CharSequence[]::new)));
        return foundStructures;
    }

    private static void addAllPossibleFeatureChunksAtDistance(int chunkX, int chunkZ, int radius, long seed, class_6872 placement, Consumer<class_1923> positionConsumer) {
        for (int j = -radius; j <= radius; ++j) {
            boolean flag = j == -radius || j == radius;
            for (int k = -radius; k <= radius; ++k) {
                boolean flag1;
                boolean bl = flag1 = k == -radius || k == radius;
                if (!flag && !flag1) continue;
                int px = chunkX + j;
                int pz = chunkZ + k;
                class_1923 chunkpos = placement.method_40169(seed, px, pz);
                positionConsumer.accept(chunkpos);
            }
        }
    }

    private static Set<LocatedStruct> getStructuresAtChunkPos(Set<class_6880<class_3195>> targets, class_4538 level, class_5138 structureManager, boolean skipKnown, class_6872 placement, class_1923 chunkpos, int stopAt) {
        HashSet<LocatedStruct> foundStructures = new HashSet<LocatedStruct>();
        for (class_6880<class_3195> holder : targets) {
            class_6833 structurecheckresult = structureManager.method_39783(chunkpos, (class_3195)holder.comp_349(), (class_6874)placement, skipKnown);
            if (structurecheckresult == class_6833.field_36240) continue;
            if (!skipKnown && structurecheckresult == class_6833.field_36239) {
                foundStructures.add(new LocatedStruct(placement.method_41636(chunkpos), holder, null));
            } else {
                class_2791 chunkaccess = level.method_22342(chunkpos.field_9181, chunkpos.field_9180, class_2806.field_16423);
                class_3449 structurestart = structureManager.method_26975(class_4076.method_33705((class_2791)chunkaccess), (class_3195)holder.comp_349(), (class_2810)chunkaccess);
                if (structurestart != null && structurestart.method_16657() && (!skipKnown || structurestart.method_14979())) {
                    foundStructures.add(new LocatedStruct(placement.method_41636(structurestart.method_34000()), holder, structurestart));
                }
            }
            if (foundStructures.size() < stopAt) continue;
            break;
        }
        for (LocatedStruct foundStructures1 : foundStructures) {
            class_6880<class_3195> class_68802 = foundStructures1.structure;
        }
        return foundStructures;
    }

    @Nullable
    private static Set<LocatedStruct> getNearestGeneratedStructureAtDistance(Set<class_6880<class_3195>> targets, class_4538 level, class_5138 featureManager, int x, int z, int distance, boolean newChunk, long seed, class_6872 placement) {
        int i = placement.method_41632();
        for (int j = -distance; j <= distance; ++j) {
            boolean flag = j == -distance || j == distance;
            for (int k = -distance; k <= distance; ++k) {
                boolean flag1;
                boolean bl = flag1 = k == -distance || k == distance;
                if (!flag && !flag1) continue;
                int px = x + i * j;
                int pz = z + i * k;
                class_1923 chunkpos = placement.method_40169(seed, px, pz);
                return LegacyStructureLocator.getStructuresAtChunkPos(targets, level, featureManager, newChunk, placement, chunkpos, Integer.MAX_VALUE);
            }
        }
        return null;
    }

    @Nullable
    public class_2338 findRandomMapFeature(class_6862<class_3195> tagKey, class_2338 pos, int radius, boolean unexplored, class_3218 level) {
        if (!level.method_8503().method_27728().method_28057().method_28029()) {
            return null;
        }
        Optional optional = level.method_30349().method_30530(class_7924.field_41246).method_40266(tagKey);
        if (optional.isEmpty()) {
            return null;
        }
        class_6885.class_6888 set = (class_6885.class_6888)optional.get();
        List list = set.method_40239().toList();
        class_6880 chosen = (class_6880)list.get(level.field_9229.method_43048(list.size()));
        Pair pair = level.method_14178().method_12129().method_12103(level, (class_6885)class_6885.method_40246((class_6880[])new class_6880[]{chosen}), pos, radius, unexplored);
        return pair != null ? (class_2338)pair.getFirst() : null;
    }

    public record LocatedStruct(class_2338 pos, class_6880<class_3195> structure, @Nullable class_3449 start) {
        public LocatedStruct(Pair<class_2338, class_6880<class_3195>> pair) {
            this((class_2338)pair.getFirst(), (class_6880<class_3195>)((class_6880)pair.getSecond()), null);
        }
    }
}

