/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2382;
import net.minecraft.class_5699;
import net.minecraft.class_6872;
import net.minecraft.class_6873;
import net.minecraft.class_6874;
import net.minecraft.class_7869;

public class RandomSpreadStructurePlacementWithExclusion
extends class_6872 {
    private final List<class_6874.class_7152> exclusionZones;
    public static final MapCodec<RandomSpreadStructurePlacementWithExclusion> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)class_2382.method_39677((int)16).optionalFieldOf("locate_offset", (Object)class_2382.field_11176).forGetter(rec$ -> ((RandomSpreadStructurePlacementWithExclusion)((Object)((Object)((Object)rec$)))).method_41642()), (App)class_6874.class_7154.field_37786.optionalFieldOf("frequency_reduction_method", (Object)class_6874.class_7154.field_37782).forGetter(rec$ -> ((RandomSpreadStructurePlacementWithExclusion)((Object)((Object)((Object)rec$)))).method_41643()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(rec$ -> Float.valueOf(((RandomSpreadStructurePlacementWithExclusion)((Object)((Object)((Object)rec$)))).method_41644())), (App)class_5699.field_33441.fieldOf("salt").forGetter(rec$ -> ((RandomSpreadStructurePlacementWithExclusion)((Object)((Object)((Object)rec$)))).method_41645()), (App)class_6874.class_7152.field_37781.listOf().optionalFieldOf("exclusion_zones", List.of()).forGetter(RandomSpreadStructurePlacementWithExclusion::exclusionZones), (App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(class_6872::method_41632), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(class_6872::method_41633), (App)class_6873.field_36423.optionalFieldOf("spread_type", (Object)class_6873.field_36421).forGetter(class_6872::method_41634)).apply((Applicative)i, RandomSpreadStructurePlacementWithExclusion::new)).validate(RandomSpreadStructurePlacementWithExclusion::validate);

    public RandomSpreadStructurePlacementWithExclusion(class_2382 locateOffset, class_6874.class_7154 frequencyReductionMethod, float frequency, int salt, List<class_6874.class_7152> exclusionZones, int spacing, int separation, class_6873 spreadType) {
        super(locateOffset, frequencyReductionMethod, frequency, salt, Optional.empty(), spacing, separation, spreadType);
        this.exclusionZones = exclusionZones;
    }

    static boolean isPlacementForbidden(class_6874.class_7152 zone, class_7869 structureState, int x, int z) {
        return structureState.method_46709(zone.comp_574(), x, z, zone.comp_575());
    }

    public boolean method_56576(class_7869 structureState, int x, int z) {
        for (class_6874.class_7152 zone : this.exclusionZones) {
            if (!RandomSpreadStructurePlacementWithExclusion.isPlacementForbidden(zone, structureState, x, z)) continue;
            return false;
        }
        return true;
    }

    public List<class_6874.class_7152> exclusionZones() {
        return this.exclusionZones;
    }

    private static DataResult<RandomSpreadStructurePlacementWithExclusion> validate(RandomSpreadStructurePlacementWithExclusion placement) {
        return placement.method_41632() <= placement.method_41633() ? DataResult.error(() -> "Spacing has to be larger than separation") : DataResult.success((Object)((Object)placement));
    }
}

