/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.supplementaries.common.entities.CannonBoatEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1690;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3785;
import net.minecraft.class_3818;
import net.minecraft.class_3825;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5821;
import net.minecraft.class_7265;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class SpawnEntityWithPassengersFeature
extends class_3031<Config> {
    public SpawnEntityWithPassengersFeature() {
        super(Config.CODEC);
    }

    public boolean method_13151(class_5821<Config> context) {
        Config config = (Config)context.method_33656();
        class_2338 blockPos = context.method_33655();
        class_5281 level = context.method_33652();
        class_3218 serverLevel = level.method_8410();
        for (int i = 0; i < config.attempts + 5; ++i) {
            class_2338 groundPos;
            int dx = context.method_33654().method_39332(-config.spread, config.spread);
            int dz = context.method_33654().method_39332(-config.spread, config.spread);
            class_2338 spawnPos = blockPos.method_10069(dx, 0, dz);
            if (config.projection == class_3785.class_3786.field_16686) {
                int y = level.method_8624(class_2902.class_2903.field_13194, blockPos.method_10263(), blockPos.method_10260());
                spawnPos = spawnPos.method_33096(y);
            }
            if (!level.method_22347(spawnPos) || !config.groundRule.method_16768(level.method_8320(groundPos = spawnPos.method_10074()), context.method_33654()) || !SpawnEntityWithPassengersFeature.trySpawningAt(context, config, serverLevel, spawnPos, level)) continue;
            return true;
        }
        return false;
    }

    private static boolean trySpawningAt(class_5821<Config> context, Config config, class_3218 serverLevel, class_2338 blockPos, class_5281 worldgenLevel) {
        class_1297 boat = config.entity.method_5883((class_1937)serverLevel);
        if (boat == null) {
            return false;
        }
        if (boat instanceof class_1690) {
            class_1690 b = (class_1690)boat;
            if (config.data.boatType.isPresent()) {
                b.method_47884(config.data.boatType.get().toVanillaBoat());
                if (boat instanceof CannonBoatEntity) {
                    CannonBoatEntity cb = (CannonBoatEntity)boat;
                    cb.setWoodType(config.data.boatType.get());
                }
            }
        }
        if (boat instanceof class_7265) {
            class_7265 cb = (class_7265)boat;
            if (config.data.lootTable.isPresent()) {
                cb.method_42275(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)config.data.lootTable.get()));
            }
        }
        boat.method_5808((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264(), (double)blockPos.method_10260() + 0.5, 360.0f * context.method_33654().method_43057(), 0.0f);
        for (class_1299<?> passengerType : config.passengers) {
            class_1297 passenger = passengerType.method_5883((class_1937)serverLevel);
            if (passenger == null) continue;
            passenger.method_5804(boat);
        }
        for (class_1297 e : boat.method_24204().toList()) {
            if (!(e instanceof class_1308)) continue;
            class_1308 m = (class_1308)e;
            if (config.persistent) {
                m.method_5971();
            }
            m.method_5943((class_5425)worldgenLevel, worldgenLevel.method_8404(blockPos), class_3730.field_16474, null);
        }
        if (!worldgenLevel.method_22340(blockPos) || !worldgenLevel.method_17892(boat)) {
            return false;
        }
        serverLevel.method_30771(boat);
        return true;
    }

    public record Config(class_1299<?> entity, List<class_1299<?>> passengers, int spread, class_3785.class_3786 projection, int attempts, class_3825 groundRule, boolean persistent, ExtraData data) implements class_3037
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41177.method_39673().fieldOf("entity").forGetter(Config::entity), (App)class_7923.field_41177.method_39673().listOf().optionalFieldOf("passengers", List.of()).forGetter(Config::passengers), (App)Codec.INT.optionalFieldOf("spread", (Object)0).forGetter(Config::spread), (App)class_3785.class_3786.field_24956.optionalFieldOf("projection", (Object)class_3785.class_3786.field_16687).forGetter(Config::projection), (App)Codec.INT.optionalFieldOf("attempts", (Object)1).forGetter(Config::attempts), (App)class_3825.field_25012.optionalFieldOf("ground_rule", (Object)class_3818.field_16868).forGetter(Config::groundRule), (App)Codec.BOOL.optionalFieldOf("persistent", (Object)true).forGetter(Config::persistent), (App)ExtraData.CODEC.optionalFieldOf("data", (Object)ExtraData.EMPTY).forGetter(Config::data)).apply((Applicative)instance, Config::new));
    }

    record ExtraData(Optional<WoodType> boatType, Optional<class_2960> lootTable) {
        private static final Codec<ExtraData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)WoodType.CODEC.optionalFieldOf("boat_type").forGetter(ExtraData::boatType), (App)class_2960.field_25139.optionalFieldOf("loot_table").forGetter(ExtraData::lootTable)).apply((Applicative)instance, ExtraData::new));
        public static final ExtraData EMPTY = new ExtraData(Optional.empty(), Optional.empty());
    }
}

