/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicServerResourceProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.PackGenerationStrategy;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1972;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_6908;
import net.minecraft.class_7924;

public class ModServerDynamicResources
extends DynamicServerResourceProvider {
    public static final Map<class_2960, class_3298> TAG_TRANSLATION_HACK = new HashMap<class_2960, class_3298>();

    public ModServerDynamicResources() {
        super(Supplementaries.res("generated_pack"), PlatHelper.isDev() ? PackGenerationStrategy.CACHED : CommonConfigs.General.DYNAMIC_ASSETS_GEN_MODE.get().toStrategy());
    }

    public boolean needsToRegenerate() {
        return super.needsToRegenerate() || PlatHelper.isDev();
    }

    protected Collection<String> gatherSupportedNamespaces() {
        return List.of();
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        executor.accept((manager, sink) -> {
            SimpleTagBuilder builder = SimpleTagBuilder.of((class_2960)Supplementaries.res("way_signs"));
            builder.addEntries(ModRegistry.WAY_SIGN_ITEMS.values());
            sink.addTag(builder, class_7924.field_41197);
            builder = SimpleTagBuilder.of((class_2960)Supplementaries.res("cannon_boats"));
            builder.addEntries(ModRegistry.CANNON_BOAT_ITEMS.values());
            sink.addTag(builder, class_7924.field_41197);
            if (CommonConfigs.Building.WAY_SIGN_ENABLED.get().booleanValue()) {
                this.addSignPostRecipes(manager, sink);
            }
            if (CommonConfigs.Functional.CANNON_BOAT_ENABLED.get().booleanValue()) {
                this.addCannonBoatRecipes(manager, sink);
            }
            builder = SimpleTagBuilder.of(ModTags.HAS_ROAD_SIGNS);
            if (CommonConfigs.Building.ROAD_SIGN_ENABLED.get().booleanValue()) {
                builder.addTag(class_6908.field_37393);
            }
            sink.addTag(builder, class_7924.field_41236);
            builder = SimpleTagBuilder.of(ModTags.HAS_GALLEONS);
            if (CommonConfigs.Functional.GALLEONS_ENABLED.get().booleanValue()) {
                builder.addTag(class_6908.field_36509);
            }
            sink.addTag(builder, class_7924.field_41236);
            if (PlatHelper.getPlatform().isForge()) {
                builder = SimpleTagBuilder.of(ModTags.HAS_CAVE_URNS);
                if (CommonConfigs.Functional.URN_PILE_ENABLED.get().booleanValue()) {
                    builder.addTag(class_6908.field_37393);
                }
                sink.addTag(builder, class_7924.field_41236);
                builder = SimpleTagBuilder.of(ModTags.HAS_BARNACLES);
                if (CommonConfigs.Building.BARNACLES_ENABLED.get().booleanValue()) {
                    builder.addTag(class_6908.field_36509);
                    builder.add(class_1972.field_9419.method_29177());
                    builder.addTag(class_6908.field_36510);
                }
                sink.addTag(builder, class_7924.field_41236);
                builder = SimpleTagBuilder.of(ModTags.HAS_WILD_FLAX);
                if (CommonConfigs.Functional.WILD_FLAX_ENABLED.get().booleanValue()) {
                    builder.addTag(class_6908.field_37393);
                }
                sink.addTag(builder, class_7924.field_41236);
                builder = SimpleTagBuilder.of(ModTags.HAS_BASALT_ASH);
                if (CommonConfigs.Building.BASALT_ASH_ENABLED.get().booleanValue()) {
                    builder.add(class_1972.field_23859.method_29177());
                    builder.method_34891(class_2960.method_60654((String)"incendium:volcanic_deltas"));
                }
                sink.addTag(builder, class_7924.field_41236);
            }
        });
    }

    private void addCannonBoatRecipes(class_3300 manager, ResourceSink sink) {
        ModRegistry.CANNON_BOAT_ITEMS.forEach((w, i) -> {
            if (w.getChild("boat") == null) {
                Supplementaries.LOGGER.warn("Could not find Boat for wood {}. Does this item even exist? It should! Skipping cannon boat generation", w);
                return;
            }
            try {
                sink.addBlockTypeSwapRecipe(manager, Supplementaries.res("cannon_boat_oak"), (BlockType)VanillaWoodTypes.OAK, (BlockType)w, Supplementaries.res("cannon_boat"));
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error("Failed to generate recipe for cannon boat {}:", (Object)i, (Object)e);
            }
        });
    }

    private void addSignPostRecipes(class_3300 manager, ResourceSink sink) {
        WoodType oak = VanillaWoodTypes.OAK;
        ModRegistry.WAY_SIGN_ITEMS.forEach((w, i) -> {
            if (w.getChild("sign") == null) {
                Supplementaries.LOGGER.warn("Could not find Sign for wood {}. Does this block even exist? It should! Skipping way sign recipe generation", w);
                return;
            }
            try {
                sink.addBlockTypeSwapRecipe(manager, Supplementaries.res("way_sign_oak"), (BlockType)VanillaWoodTypes.OAK, (BlockType)w, Supplementaries.res("way_sign"));
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error("Failed to generate recipe for sign post {}:", (Object)i, (Object)e);
            }
        });
    }
}

