/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.blocks;

import com.wenxin2.warp_pipes.blocks.ClearWarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.WarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.warp_pipes.registries.ConfigRegistry;
import com.wenxin2.warp_pipes.registries.ModRegistry;
import com.wenxin2.warp_pipes.registries.TagRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WaterSpoutBlock
extends Block
implements BucketPickup {
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    public static final VoxelShape SPOUT = Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0).optimize(), (VoxelShape[])new VoxelShape[0]);
    public static final VoxelShape SPOUT_TOP = Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0).optimize(), (VoxelShape[])new VoxelShape[0]);

    public WaterSpoutBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TOP, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{TOP});
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        Player player;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = ((EntityCollisionContext)context).getEntity()) instanceof Player && ((player = (Player)entity).hasPermissions(1) && player.isCreative() && (Boolean)ConfigRegistry.DEBUG_WATER_SPOUT_SELECTION_BOX.get() != false || player.getItemInHand(player.getUsedItemHand()).getItem() instanceof BucketItem && (Boolean)ConfigRegistry.WATER_SPOUTS_BUCKETABLE.get() != false || player.getItemInHand(player.getUsedItemHand()).is(TagRegistry.CAN_SELECT_WATER_SPOUTS))) {
            if (((Boolean)state.getValue((Property)TOP)).booleanValue()) {
                return SPOUT_TOP;
            }
            return SPOUT;
        }
        return Shapes.box((double)8.0, (double)8.0, (double)8.0, (double)8.00001, (double)8.00001, (double)8.00001);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor worldAccessor, BlockPos pos, BlockPos neighborPos) {
        super.updateShape(state, direction, neighborState, worldAccessor, pos, neighborPos);
        BlockState stateAbove = worldAccessor.getBlockState(pos.above());
        BlockState stateBelow = worldAccessor.getBlockState(pos.below());
        if (stateBelow.getBlock() instanceof WarpPipeBlock && (((Boolean)stateBelow.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() || stateBelow.getValue((Property)WarpPipeBlock.FACING) != Direction.UP || !((Boolean)stateBelow.getValue((Property)WarpPipeBlock.WATER_SPOUT)).booleanValue())) {
            worldAccessor.destroyBlock(pos, true);
            return Blocks.AIR.defaultBlockState();
        }
        if (stateBelow.getBlock() instanceof ClearWarpPipeBlock && (((Boolean)stateBelow.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() || stateBelow.getValue((Property)WarpPipeBlock.FACING) != Direction.UP || !((Boolean)stateBelow.getValue((Property)ClearWarpPipeBlock.WATERLOGGED)).booleanValue() || !((Boolean)stateBelow.getValue((Property)WarpPipeBlock.WATER_SPOUT)).booleanValue())) {
            worldAccessor.destroyBlock(pos, true);
            return Blocks.AIR.defaultBlockState();
        }
        if (!(stateBelow.getBlock() instanceof WarpPipeBlock) && !(stateBelow.getBlock() instanceof WaterSpoutBlock)) {
            worldAccessor.destroyBlock(pos, true);
            return Blocks.AIR.defaultBlockState();
        }
        if (stateAbove.getBlock() != ModRegistry.WATER_SPOUT.get()) {
            return (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.TRUE);
        }
        return (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.FALSE);
    }

    public boolean canSurvive(BlockState state, LevelReader worldReader, BlockPos pos) {
        BlockState stateBelow = worldReader.getBlockState(pos.below());
        if (stateBelow.is((Block)ModRegistry.WATER_SPOUT.get())) {
            return true;
        }
        if (stateBelow.is(Blocks.WATER) && stateBelow.getFluidState().getAmount() >= 8 && stateBelow.getFluidState().isSource()) {
            return true;
        }
        if (stateBelow.getBlock() instanceof WarpPipeBlock && stateBelow.getValue((Property)WarpPipeBlock.FACING) == Direction.UP && !((Boolean)stateBelow.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() && ((Boolean)stateBelow.getValue((Property)WarpPipeBlock.WATER_SPOUT)).booleanValue() && !(stateBelow.getBlock() instanceof ClearWarpPipeBlock)) {
            return true;
        }
        return stateBelow.getBlock() instanceof ClearWarpPipeBlock && stateBelow.getValue((Property)WarpPipeBlock.FACING) == Direction.UP && (Boolean)stateBelow.getValue((Property)WarpPipeBlock.CLOSED) == false && (Boolean)stateBelow.getValue((Property)WarpPipeBlock.WATER_SPOUT) != false && (Boolean)stateBelow.getValue((Property)ClearWarpPipeBlock.WATERLOGGED) != false;
    }

    public static boolean canExistIn(LevelAccessor worldAccessor, BlockPos pos) {
        return worldAccessor.getBlockState(pos).is((Block)ModRegistry.WATER_SPOUT.get()) || worldAccessor.getBlockState(pos).isAir();
    }

    public static BlockState setBlockState(BlockState state, LevelAccessor worldAccessor, BlockPos pos) {
        BlockState stateAbove = worldAccessor.getBlockState(pos.above());
        if (state.isAir() || state.is((Block)ModRegistry.WATER_SPOUT.get()) || state.getBlock() instanceof WarpPipeBlock && ((Boolean)state.getValue((Property)WarpPipeBlock.WATER_SPOUT)).booleanValue() && !((Boolean)state.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue()) {
            if (state.is((Block)ModRegistry.WATER_SPOUT.get())) {
                if (!stateAbove.is((Block)ModRegistry.WATER_SPOUT.get())) {
                    return (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.TRUE);
                }
                return (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.FALSE);
            }
            if (state.getBlock() instanceof WarpPipeBlock && state.getValue((Property)WarpPipeBlock.FACING) == Direction.UP && ((Boolean)state.getValue((Property)WarpPipeBlock.WATER_SPOUT)).booleanValue() && !((Boolean)state.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue()) {
                if (!stateAbove.is((Block)ModRegistry.WATER_SPOUT.get())) {
                    return (BlockState)((Block)ModRegistry.WATER_SPOUT.get()).defaultBlockState().setValue((Property)TOP, (Comparable)Boolean.TRUE);
                }
                return (BlockState)((Block)ModRegistry.WATER_SPOUT.get()).defaultBlockState().setValue((Property)TOP, (Comparable)Boolean.FALSE);
            }
        }
        return Blocks.AIR.defaultBlockState();
    }

    public void addParticles(Level world, ParticleOptions particleOptions, double xPos, double yPos, double zPos, int amt, double xMotion, double yMotion, double zMotion, double speed) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.sendParticles(particleOptions, xPos, yPos, zPos, amt, xMotion, yMotion, zMotion, speed);
        }
    }

    public void addAlwaysVisibleParticles(Level world, ParticleOptions particleOptions, double xPos, double yPos, double zPos, double xMotion, double yMotion, double zMotion) {
        if (world.isClientSide) {
            world.addAlwaysVisibleParticle(particleOptions, xPos, yPos, zPos, xMotion, yMotion, zMotion);
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        double randomNum = -1.0 + random.nextDouble();
        double x = pos.getX();
        double y = pos.getY();
        double z = pos.getZ();
        if (world.getBlockState(pos.above()).isAir()) {
            for (int i = 0; i < 75; ++i) {
                this.addAlwaysVisibleParticles(world, (ParticleOptions)ParticleTypes.SPLASH, x + random.nextDouble(), y + 1.0, z + random.nextDouble(), randomNum, 0.04, randomNum);
            }
        }
        if (random.nextInt(20) == 0) {
            world.playLocalSound(x, y, z, SoundEvents.BUBBLE_COLUMN_UPWARDS_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
        }
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockState stateAbove = world.getBlockState(pos.above());
        if (stateAbove.isAir()) {
            if (entity instanceof Boat) {
                Boat boat = (Boat)entity;
                boat.onAboveBubbleCol(Boolean.FALSE.booleanValue());
            } else {
                this.onAboveUpBubbleCol(entity);
            }
            if (!world.isClientSide) {
                serverWorld = (ServerLevel)world;
                for (i = 0; i < 2; ++i) {
                    this.addParticles((Level)serverWorld, (ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + world.random.nextDouble(), pos.getY() + 1, (double)pos.getZ() + world.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                    this.addParticles((Level)serverWorld, (ParticleOptions)ParticleTypes.BUBBLE, (double)pos.getX() + world.random.nextDouble(), pos.getY() + 1, (double)pos.getZ() + world.random.nextDouble(), 1, 0.0, 0.01, 0.0, 0.2);
                }
            }
        } else {
            this.onInsideUpBubbleColumn(entity);
            if (!world.isClientSide) {
                serverWorld = (ServerLevel)world;
                for (i = 0; i < 2; ++i) {
                    this.addParticles((Level)serverWorld, (ParticleOptions)ParticleTypes.SPLASH, (double)pos.getX() + world.random.nextDouble(), pos.getY() + 1, (double)pos.getZ() + world.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                    this.addParticles((Level)serverWorld, (ParticleOptions)ParticleTypes.BUBBLE, (double)pos.getX() + world.random.nextDouble(), pos.getY() + 1, (double)pos.getZ() + world.random.nextDouble(), 1, 0.0, 0.01, 0.0, 0.2);
                }
            }
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!world.isClientSide && livingEntity.canDrownInFluidType(Fluids.WATER.getFluidType())) {
                int refillAmount = 1;
                int newAir = Math.min(livingEntity.getAirSupply() + refillAmount, livingEntity.getMaxAirSupply());
                livingEntity.setAirSupply(newAir);
            }
        }
    }

    public void onAboveUpBubbleCol(Entity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        double d0 = Math.min(1.8, vec3.y + 0.1);
        entity.setDeltaMovement(vec3.x, d0, vec3.z);
    }

    public void onInsideUpBubbleColumn(Entity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        double d0 = Math.min(0.5, vec3.y + 0.04);
        entity.setDeltaMovement(vec3.x, d0 + 0.05, vec3.z);
        entity.resetFallDistance();
    }

    public void tick(BlockState state, ServerLevel serverWorld, BlockPos pos, RandomSource random) {
        WarpPipeBlockEntity pipeBlockEntity = (WarpPipeBlockEntity)serverWorld.getBlockEntity(pos.below());
        if (pipeBlockEntity != null && ((Boolean)pipeBlockEntity.getBlockState().getValue((Property)WarpPipeBlock.WATER_SPOUT)).booleanValue()) {
            WaterSpoutBlock.repeatColumnUp((LevelAccessor)serverWorld, pos, state, serverWorld.getBlockState(pos.below()), pipeBlockEntity.spoutHeight);
        } else {
            WaterSpoutBlock.repeatColumnUp((LevelAccessor)serverWorld, pos, state, serverWorld.getBlockState(pos.below()), 0);
        }
    }

    public static void repeatColumnUp(LevelAccessor worldAccessor, BlockPos pos, BlockState state, int spoutHeight) {
        WaterSpoutBlock.repeatColumnUp(worldAccessor, pos, worldAccessor.getBlockState(pos), state, spoutHeight);
    }

    public static void repeatColumnUp(LevelAccessor worldAccessor, BlockPos pos, BlockState state, BlockState neighborState, int spoutHeight) {
        if (WaterSpoutBlock.canExistIn(worldAccessor, pos) && spoutHeight != 0) {
            int initialDistance = 0;
            BlockPos.MutableBlockPos mutablePos = pos.mutable().move(Direction.UP);
            BlockState pipeColumnState = WaterSpoutBlock.setBlockState(neighborState, worldAccessor, pos);
            BlockState stateAbove = worldAccessor.getBlockState(mutablePos.above());
            if (pipeColumnState.getBlock() instanceof WaterSpoutBlock) {
                if (stateAbove.getBlock() != ModRegistry.WATER_SPOUT.get()) {
                    worldAccessor.setBlock(pos, (BlockState)pipeColumnState.setValue((Property)TOP, (Comparable)Boolean.TRUE), 2);
                } else {
                    worldAccessor.setBlock(pos, (BlockState)pipeColumnState.setValue((Property)TOP, (Comparable)Boolean.FALSE), 2);
                }
            } else {
                worldAccessor.setBlock(pos, pipeColumnState, 2);
            }
            worldAccessor.scheduleTick(pos, (Block)ModRegistry.WATER_SPOUT.get(), 3);
            while (WaterSpoutBlock.canExistIn(worldAccessor, (BlockPos)mutablePos) && initialDistance < spoutHeight - 1) {
                if (!worldAccessor.setBlock((BlockPos)mutablePos, pipeColumnState, 2)) {
                    return;
                }
                mutablePos.move(Direction.UP);
                ++initialDistance;
                pipeColumnState = WaterSpoutBlock.setBlockState(pipeColumnState, worldAccessor, (BlockPos)mutablePos);
            }
        }
    }

    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor worldAccessor, BlockPos pos, BlockState state) {
        if (((Boolean)ConfigRegistry.WATER_SPOUTS_BUCKETABLE.get()).booleanValue()) {
            worldAccessor.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            return new ItemStack((ItemLike)Items.WATER_BUCKET);
        }
        return ItemStack.EMPTY;
    }

    public Optional<SoundEvent> getPickupSound() {
        return Fluids.WATER.getPickupSound();
    }
}

