/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.client.renderers.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.wenxin2.warp_pipes.blocks.ClearWarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.WarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.entities.PipeText;
import com.wenxin2.warp_pipes.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.warp_pipes.registries.ConfigRegistry;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class WarpPipeBlockEntityRenderer
implements BlockEntityRenderer<WarpPipeBlockEntity> {
    private static final float TEXT_RENDER_SCALE = 0.0125f;
    private static final int OUTLINE_RENDER_DISTANCE = Mth.square((int)16);
    private final Font font;

    public WarpPipeBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.getFont();
    }

    public void render(WarpPipeBlockEntity blockEntity, float partialTick, PoseStack stack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (!((Boolean)ConfigRegistry.DISABLE_TEXT.get()).booleanValue()) {
            this.renderPipeWithText(blockEntity, stack, buffer, packedLight);
        }
    }

    void renderPipeWithText(WarpPipeBlockEntity pipeBlockEntity, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        BlockState state = pipeBlockEntity.getBlockState();
        stack.pushPose();
        if (((Boolean)state.getValue((Property)WarpPipeBlock.ENTRANCE)).booleanValue() && state.getValue((Property)WarpPipeBlock.FACING) != Direction.NORTH && state.getValue((Property)WarpPipeBlock.FACING) != Direction.SOUTH) {
            if (pipeBlockEntity.hasTextNorth()) {
                this.renderPipeTextNorth(pipeBlockEntity, pipeBlockEntity.getBlockPos(), pipeBlockEntity.getPipeText(), stack, buffer, packedLight, pipeBlockEntity.getTextLineHeight(), pipeBlockEntity.getMaxTextLineWidth());
            }
            if (pipeBlockEntity.hasTextSouth()) {
                this.renderPipeTextSouth(pipeBlockEntity, pipeBlockEntity.getBlockPos(), pipeBlockEntity.getPipeText(), stack, buffer, packedLight, pipeBlockEntity.getTextLineHeight(), pipeBlockEntity.getMaxTextLineWidth());
            }
        }
        if (((Boolean)state.getValue((Property)WarpPipeBlock.ENTRANCE)).booleanValue() && state.getValue((Property)WarpPipeBlock.FACING) != Direction.EAST && state.getValue((Property)WarpPipeBlock.FACING) != Direction.WEST) {
            if (pipeBlockEntity.hasTextEast()) {
                this.renderPipeTextEast(pipeBlockEntity, pipeBlockEntity.getBlockPos(), pipeBlockEntity.getPipeText(), stack, buffer, packedLight, pipeBlockEntity.getTextLineHeight(), pipeBlockEntity.getMaxTextLineWidth());
            }
            if (pipeBlockEntity.hasTextWest()) {
                this.renderPipeTextWest(pipeBlockEntity, pipeBlockEntity.getBlockPos(), pipeBlockEntity.getPipeText(), stack, buffer, packedLight, pipeBlockEntity.getTextLineHeight(), pipeBlockEntity.getMaxTextLineWidth());
            }
        }
        if (((Boolean)state.getValue((Property)WarpPipeBlock.ENTRANCE)).booleanValue() && state.getValue((Property)WarpPipeBlock.FACING) != Direction.UP && state.getValue((Property)WarpPipeBlock.FACING) != Direction.DOWN) {
            if (pipeBlockEntity.hasTextAbove()) {
                this.renderPipeTextAbove(pipeBlockEntity, pipeBlockEntity.getBlockPos(), pipeBlockEntity.getPipeText(), stack, buffer, packedLight, pipeBlockEntity.getTextLineHeight(), pipeBlockEntity.getMaxTextLineWidth());
            }
            if (pipeBlockEntity.hasTextBelow()) {
                this.renderPipeTextBelow(pipeBlockEntity, pipeBlockEntity.getBlockPos(), pipeBlockEntity.getPipeText(), stack, buffer, packedLight, pipeBlockEntity.getTextLineHeight(), pipeBlockEntity.getMaxTextLineWidth());
            }
        }
        stack.popPose();
    }

    void renderPipeTextNorth(WarpPipeBlockEntity pipeBlockEntity, BlockPos pos, PipeText pipeText, PoseStack stack, MultiBufferSource buffer, int packedLight, int lineHeight, int maxWidth) {
        int packedLightL;
        boolean hasGlowingText;
        int textColor;
        BlockState state = pipeBlockEntity.getBlockState();
        Level world = pipeBlockEntity.getLevel();
        FormattedCharSequence[] pipeNameArray = pipeText.getRenderMessages(Minecraft.getInstance().isTextFilteringEnabled(), text -> {
            List list = this.font.split((FormattedText)text, maxWidth);
            return list.isEmpty() ? FormattedCharSequence.EMPTY : (FormattedCharSequence)list.get(0);
        });
        stack.pushPose();
        if (pipeText.hasGlowingText()) {
            textColor = pipeText.getColor().getTextColor();
            hasGlowingText = WarpPipeBlockEntityRenderer.isOutlineVisible(pos, textColor);
            packedLightL = 0xF000F0;
        } else {
            textColor = WarpPipeBlockEntityRenderer.getDarkColor(pipeText);
            packedLightL = 0xFFFFFF;
            hasGlowingText = false;
        }
        if (world != null) {
            stack.pushPose();
            if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.UP) {
                stack.translate(0.5, 0.825, -0.001);
                stack.mulPose(Axis.YP.rotationDegrees(180.0f));
            } else if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.DOWN) {
                stack.translate(0.5, 0.175, -0.001);
                stack.mulPose(Axis.YP.rotationDegrees(180.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            } else if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.EAST) {
                stack.translate(0.825, 0.5, -0.001);
                stack.mulPose(Axis.YP.rotationDegrees(180.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            } else if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.WEST) {
                stack.translate(0.175, 0.5, -0.001);
                stack.mulPose(Axis.YP.rotationDegrees(180.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(270.0f));
            }
            stack.scale(1.0f, -1.0f, -1.0f);
            stack.scale(0.0125f, 0.0125f, 0.0125f);
            Objects.requireNonNull(this.font);
            stack.translate(0.0, -(9.0 - 1.0) / 2.0, 0.0);
            for (int j = 0; j < 1; ++j) {
                BlockState stateNorth = world.getBlockState(pos.north());
                FormattedCharSequence pipeName = pipeNameArray[j];
                if (state.getBlock() instanceof ClearWarpPipeBlock) {
                    stack.translate((double)(-this.font.width(pipeName)) / 2.0 + 0.5, 7.0, 0.0);
                } else {
                    stack.translate((double)(-this.font.width(pipeName)) / 2.0 + 0.5, 2.0, 0.0);
                }
                if (stateNorth.isSolid() && stateNorth.isSolidRender((BlockGetter)world, pos.north()) || state.getBlock() instanceof ClearWarpPipeBlock && stateNorth.getBlock() instanceof ClearWarpPipeBlock) continue;
                if (hasGlowingText) {
                    this.font.drawInBatch8xOutline(pipeName, 0.0f, 0.0f, textColor, WarpPipeBlockEntityRenderer.getDarkColor(pipeText), stack.last().pose(), buffer, packedLightL);
                    continue;
                }
                this.font.drawInBatch(pipeName, 0.0f, 0.0f, textColor, false, stack.last().pose(), buffer, Font.DisplayMode.POLYGON_OFFSET, 0, packedLightL);
            }
            stack.popPose();
        }
        stack.popPose();
    }

    void renderPipeTextSouth(WarpPipeBlockEntity pipeBlockEntity, BlockPos pos, PipeText pipeText, PoseStack stack, MultiBufferSource buffer, int packedLight, int lineHeight, int maxWidth) {
        int packedLightL;
        boolean hasGlowingText;
        int textColor;
        BlockState state = pipeBlockEntity.getBlockState();
        Level world = pipeBlockEntity.getLevel();
        FormattedCharSequence[] pipeNameArray = pipeText.getRenderMessages(Minecraft.getInstance().isTextFilteringEnabled(), text -> {
            List list = this.font.split((FormattedText)text, maxWidth);
            return list.isEmpty() ? FormattedCharSequence.EMPTY : (FormattedCharSequence)list.get(0);
        });
        stack.pushPose();
        if (pipeText.hasGlowingText()) {
            textColor = pipeText.getColor().getTextColor();
            hasGlowingText = WarpPipeBlockEntityRenderer.isOutlineVisible(pos, textColor);
            packedLightL = 0xF000F0;
        } else {
            textColor = WarpPipeBlockEntityRenderer.getDarkColor(pipeText);
            packedLightL = 0xFFFFFF;
            hasGlowingText = false;
        }
        if (world != null) {
            stack.pushPose();
            if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.UP) {
                stack.translate(0.5, 0.825, 1.001);
                stack.mulPose(Axis.YP.rotationDegrees(0.0f));
            } else if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.DOWN) {
                stack.translate(0.5, 0.175, 1.001);
                stack.mulPose(Axis.YP.rotationDegrees(0.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            } else if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.EAST) {
                stack.translate(0.825, 0.5, 1.001);
                stack.mulPose(Axis.YP.rotationDegrees(0.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(270.0f));
            } else if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.WEST) {
                stack.translate(0.175, 0.5, 1.001);
                stack.mulPose(Axis.YP.rotationDegrees(0.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            }
            stack.scale(1.0f, -1.0f, -1.0f);
            stack.scale(0.0125f, 0.0125f, 0.0125f);
            Objects.requireNonNull(this.font);
            stack.translate(0.0, -(9.0 - 1.0) / 2.0, 0.0);
            for (int j = 0; j < 1; ++j) {
                BlockState stateSouth = world.getBlockState(pos.south());
                FormattedCharSequence pipeName = pipeNameArray[j];
                if (state.getBlock() instanceof ClearWarpPipeBlock) {
                    stack.translate((double)(-this.font.width(pipeName)) / 2.0 + 0.5, 7.0, 0.0);
                } else {
                    stack.translate((double)(-this.font.width(pipeName)) / 2.0 + 0.5, 2.0, 0.0);
                }
                if (stateSouth.isSolid() && stateSouth.isSolidRender((BlockGetter)world, pos.south()) || state.getBlock() instanceof ClearWarpPipeBlock && stateSouth.getBlock() instanceof ClearWarpPipeBlock) continue;
                if (hasGlowingText) {
                    this.font.drawInBatch8xOutline(pipeName, 0.0f, 0.0f, textColor, WarpPipeBlockEntityRenderer.getDarkColor(pipeText), stack.last().pose(), buffer, packedLightL);
                    continue;
                }
                this.font.drawInBatch(pipeName, 0.0f, 0.0f, textColor, false, stack.last().pose(), buffer, Font.DisplayMode.POLYGON_OFFSET, 0, packedLightL);
            }
            stack.popPose();
        }
        stack.popPose();
    }

    void renderPipeTextEast(WarpPipeBlockEntity pipeBlockEntity, BlockPos pos, PipeText pipeText, PoseStack stack, MultiBufferSource buffer, int packedLight, int lineHeight, int maxWidth) {
        int packedLightL;
        boolean hasGlowingText;
        int textColor;
        BlockState state = pipeBlockEntity.getBlockState();
        Level world = pipeBlockEntity.getLevel();
        FormattedCharSequence[] pipeNameArray = pipeText.getRenderMessages(Minecraft.getInstance().isTextFilteringEnabled(), text -> {
            List list = this.font.split((FormattedText)text, maxWidth);
            return list.isEmpty() ? FormattedCharSequence.EMPTY : (FormattedCharSequence)list.get(0);
        });
        stack.pushPose();
        if (pipeText.hasGlowingText()) {
            textColor = pipeText.getColor().getTextColor();
            hasGlowingText = WarpPipeBlockEntityRenderer.isOutlineVisible(pos, textColor);
            packedLightL = 0xF000F0;
        } else {
            textColor = WarpPipeBlockEntityRenderer.getDarkColor(pipeText);
            packedLightL = 0xFFFFFF;
            hasGlowingText = false;
        }
        if (world != null) {
            stack.pushPose();
            if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.UP) {
                stack.translate(1.001, 0.825, 0.5);
                stack.mulPose(Axis.YP.rotationDegrees(90.0f));
            } else if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.DOWN) {
                stack.translate(1.001, 0.175, 0.5);
                stack.mulPose(Axis.YP.rotationDegrees(90.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            } else if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.NORTH) {
                stack.translate(1.001, 0.5, 0.175);
                stack.mulPose(Axis.YP.rotationDegrees(90.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(270.0f));
            } else if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.SOUTH) {
                stack.translate(1.001, 0.5, 0.825);
                stack.mulPose(Axis.YP.rotationDegrees(90.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            }
            stack.scale(1.0f, -1.0f, -1.0f);
            stack.scale(0.0125f, 0.0125f, 0.0125f);
            Objects.requireNonNull(this.font);
            stack.translate(0.0, -(9.0 - 1.0) / 2.0, 0.0);
            for (int j = 0; j < 1; ++j) {
                BlockState stateEast = world.getBlockState(pos.east());
                FormattedCharSequence pipeName = pipeNameArray[j];
                if (state.getBlock() instanceof ClearWarpPipeBlock) {
                    stack.translate((double)(-this.font.width(pipeName)) / 2.0 + 0.5, 7.0, 0.0);
                } else {
                    stack.translate((double)(-this.font.width(pipeName)) / 2.0 + 0.5, 2.0, 0.0);
                }
                if (stateEast.isSolid() && stateEast.isSolidRender((BlockGetter)world, pos.east()) || state.getBlock() instanceof ClearWarpPipeBlock && stateEast.getBlock() instanceof ClearWarpPipeBlock) continue;
                if (hasGlowingText) {
                    this.font.drawInBatch8xOutline(pipeName, 0.0f, 0.0f, textColor, WarpPipeBlockEntityRenderer.getDarkColor(pipeText), stack.last().pose(), buffer, packedLightL);
                    continue;
                }
                this.font.drawInBatch(pipeName, 0.0f, 0.0f, textColor, false, stack.last().pose(), buffer, Font.DisplayMode.POLYGON_OFFSET, 0, packedLightL);
            }
            stack.popPose();
        }
        stack.popPose();
    }

    void renderPipeTextWest(WarpPipeBlockEntity pipeBlockEntity, BlockPos pos, PipeText pipeText, PoseStack stack, MultiBufferSource buffer, int packedLight, int lineHeight, int maxWidth) {
        int packedLightL;
        boolean hasGlowingText;
        int textColor;
        BlockState state = pipeBlockEntity.getBlockState();
        Level world = pipeBlockEntity.getLevel();
        FormattedCharSequence[] pipeNameArray = pipeText.getRenderMessages(Minecraft.getInstance().isTextFilteringEnabled(), text -> {
            List list = this.font.split((FormattedText)text, maxWidth);
            return list.isEmpty() ? FormattedCharSequence.EMPTY : (FormattedCharSequence)list.get(0);
        });
        stack.pushPose();
        if (pipeText.hasGlowingText()) {
            textColor = pipeText.getColor().getTextColor();
            hasGlowingText = WarpPipeBlockEntityRenderer.isOutlineVisible(pos, textColor);
            packedLightL = 0xF000F0;
        } else {
            textColor = WarpPipeBlockEntityRenderer.getDarkColor(pipeText);
            packedLightL = 0xFFFFFF;
            hasGlowingText = false;
        }
        if (world != null) {
            stack.pushPose();
            if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.UP) {
                stack.translate(-0.001, 0.825, 0.5);
                stack.mulPose(Axis.YP.rotationDegrees(270.0f));
            } else if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.DOWN) {
                stack.translate(-0.001, 0.175, 0.5);
                stack.mulPose(Axis.YP.rotationDegrees(270.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            } else if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.NORTH) {
                stack.translate(-0.001, 0.5, 0.175);
                stack.mulPose(Axis.YP.rotationDegrees(270.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            } else if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.SOUTH) {
                stack.translate(-0.001, 0.5, 0.825);
                stack.mulPose(Axis.YP.rotationDegrees(270.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(270.0f));
            }
            stack.scale(1.0f, -1.0f, -1.0f);
            stack.scale(0.0125f, 0.0125f, 0.0125f);
            Objects.requireNonNull(this.font);
            stack.translate(0.0, -(9.0 - 1.0) / 2.0, 0.0);
            for (int j = 0; j < 1; ++j) {
                BlockState stateWest = world.getBlockState(pos.west());
                FormattedCharSequence pipeName = pipeNameArray[j];
                if (state.getBlock() instanceof ClearWarpPipeBlock) {
                    stack.translate((double)(-this.font.width(pipeName)) / 2.0 + 0.5, 7.0, 0.0);
                } else {
                    stack.translate((double)(-this.font.width(pipeName)) / 2.0 + 0.5, 2.0, 0.0);
                }
                if (stateWest.isSolid() && stateWest.isSolidRender((BlockGetter)world, pos.west()) || state.getBlock() instanceof ClearWarpPipeBlock && stateWest.getBlock() instanceof ClearWarpPipeBlock) continue;
                if (hasGlowingText) {
                    this.font.drawInBatch8xOutline(pipeName, 0.0f, 0.0f, textColor, WarpPipeBlockEntityRenderer.getDarkColor(pipeText), stack.last().pose(), buffer, packedLightL);
                    continue;
                }
                this.font.drawInBatch(pipeName, 0.0f, 0.0f, textColor, false, stack.last().pose(), buffer, Font.DisplayMode.POLYGON_OFFSET, 0, packedLightL);
            }
            stack.popPose();
        }
        stack.popPose();
    }

    void renderPipeTextAbove(WarpPipeBlockEntity pipeBlockEntity, BlockPos pos, PipeText pipeText, PoseStack stack, MultiBufferSource buffer, int packedLight, int lineHeight, int maxWidth) {
        int packedLightL;
        boolean hasGlowingText;
        int textColor;
        BlockState state = pipeBlockEntity.getBlockState();
        Level world = pipeBlockEntity.getLevel();
        FormattedCharSequence[] pipeNameArray = pipeText.getRenderMessages(Minecraft.getInstance().isTextFilteringEnabled(), text -> {
            List list = this.font.split((FormattedText)text, maxWidth);
            return list.isEmpty() ? FormattedCharSequence.EMPTY : (FormattedCharSequence)list.get(0);
        });
        stack.pushPose();
        if (pipeText.hasGlowingText()) {
            textColor = pipeText.getColor().getTextColor();
            hasGlowingText = WarpPipeBlockEntityRenderer.isOutlineVisible(pos, textColor);
            packedLightL = 0xF000F0;
        } else {
            textColor = WarpPipeBlockEntityRenderer.getDarkColor(pipeText);
            packedLightL = 0xFFFFFF;
            hasGlowingText = false;
        }
        if (world != null) {
            stack.pushPose();
            if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.NORTH) {
                stack.translate(0.5, 1.001, 0.175);
                stack.mulPose(Axis.XP.rotationDegrees(270.0f));
            } else if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.SOUTH) {
                stack.translate(0.5, 1.001, 0.825);
                stack.mulPose(Axis.XP.rotationDegrees(270.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            } else if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.EAST) {
                stack.translate(0.825, 1.001, 0.5);
                stack.mulPose(Axis.XP.rotationDegrees(270.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(270.0f));
            } else if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.WEST) {
                stack.translate(0.175, 1.001, 0.5);
                stack.mulPose(Axis.XP.rotationDegrees(270.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            }
            stack.scale(1.0f, -1.0f, -1.0f);
            stack.scale(0.0125f, 0.0125f, 0.0125f);
            Objects.requireNonNull(this.font);
            stack.translate(0.0, -(9.0 - 1.0) / 2.0, 0.0);
            for (int j = 0; j < 1; ++j) {
                BlockState stateAbove = world.getBlockState(pos.above());
                FormattedCharSequence pipeName = pipeNameArray[j];
                if (state.getBlock() instanceof ClearWarpPipeBlock) {
                    stack.translate((double)(-this.font.width(pipeName)) / 2.0 + 0.5, 7.0, 0.0);
                } else {
                    stack.translate((double)(-this.font.width(pipeName)) / 2.0 + 0.5, 2.0, 0.0);
                }
                if (stateAbove.isSolid() && stateAbove.isSolidRender((BlockGetter)world, pos.above()) || state.getBlock() instanceof ClearWarpPipeBlock && stateAbove.getBlock() instanceof ClearWarpPipeBlock) continue;
                if (hasGlowingText) {
                    this.font.drawInBatch8xOutline(pipeName, 0.0f, 0.0f, textColor, WarpPipeBlockEntityRenderer.getDarkColor(pipeText), stack.last().pose(), buffer, packedLightL);
                    continue;
                }
                this.font.drawInBatch(pipeName, 0.0f, 0.0f, textColor, false, stack.last().pose(), buffer, Font.DisplayMode.POLYGON_OFFSET, 0, packedLightL);
            }
            stack.popPose();
        }
        stack.popPose();
    }

    void renderPipeTextBelow(WarpPipeBlockEntity pipeBlockEntity, BlockPos pos, PipeText pipeText, PoseStack stack, MultiBufferSource buffer, int packedLight, int lineHeight, int maxWidth) {
        int packedLightL;
        boolean hasGlowingText;
        int textColor;
        BlockState state = pipeBlockEntity.getBlockState();
        Level world = pipeBlockEntity.getLevel();
        FormattedCharSequence[] pipeNameArray = pipeText.getRenderMessages(Minecraft.getInstance().isTextFilteringEnabled(), text -> {
            List list = this.font.split((FormattedText)text, maxWidth);
            return list.isEmpty() ? FormattedCharSequence.EMPTY : (FormattedCharSequence)list.get(0);
        });
        stack.pushPose();
        if (pipeText.hasGlowingText()) {
            textColor = pipeText.getColor().getTextColor();
            hasGlowingText = WarpPipeBlockEntityRenderer.isOutlineVisible(pos, textColor);
            packedLightL = 0xF000F0;
        } else {
            textColor = WarpPipeBlockEntityRenderer.getDarkColor(pipeText);
            packedLightL = 0xFFFFFF;
            hasGlowingText = false;
        }
        if (world != null) {
            stack.pushPose();
            if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.NORTH) {
                stack.translate(0.5, -0.001, 0.175);
                stack.mulPose(Axis.XP.rotationDegrees(90.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            } else if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.SOUTH) {
                stack.translate(0.5, -0.001, 0.825);
                stack.mulPose(Axis.XP.rotationDegrees(90.0f));
            } else if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.EAST) {
                stack.translate(0.825, -0.001, 0.5);
                stack.mulPose(Axis.XP.rotationDegrees(90.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(270.0f));
            } else if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.WEST) {
                stack.translate(0.175, -0.001, 0.5);
                stack.mulPose(Axis.XP.rotationDegrees(90.0f));
                stack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            }
            stack.scale(1.0f, -1.0f, -1.0f);
            stack.scale(0.0125f, 0.0125f, 0.0125f);
            Objects.requireNonNull(this.font);
            stack.translate(0.0, -(9.0 - 1.0) / 2.0, 0.0);
            for (int j = 0; j < 1; ++j) {
                BlockState stateBelow = world.getBlockState(pos.below());
                FormattedCharSequence pipeName = pipeNameArray[j];
                if (state.getBlock() instanceof ClearWarpPipeBlock) {
                    stack.translate((double)(-this.font.width(pipeName)) / 2.0 + 0.5, 7.0, 0.0);
                } else {
                    stack.translate((double)(-this.font.width(pipeName)) / 2.0 + 0.5, 2.0, 0.0);
                }
                if (stateBelow.isSolid() && stateBelow.isSolidRender((BlockGetter)world, pos.below()) || state.getBlock() instanceof ClearWarpPipeBlock && stateBelow.getBlock() instanceof ClearWarpPipeBlock) continue;
                if (hasGlowingText) {
                    this.font.drawInBatch8xOutline(pipeName, 0.0f, 0.0f, textColor, WarpPipeBlockEntityRenderer.getDarkColor(pipeText), stack.last().pose(), buffer, packedLightL);
                    continue;
                }
                this.font.drawInBatch(pipeName, 0.0f, 0.0f, textColor, false, stack.last().pose(), buffer, Font.DisplayMode.POLYGON_OFFSET, 0, packedLightL);
            }
            stack.popPose();
        }
        stack.popPose();
    }

    static boolean isOutlineVisible(BlockPos pos, int textColor) {
        if (textColor == DyeColor.BLACK.getTextColor()) {
            return true;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localplayer = minecraft.player;
        if (localplayer != null && minecraft.options.getCameraType().isFirstPerson() && localplayer.isScoping()) {
            return true;
        }
        Entity entity = minecraft.getCameraEntity();
        return entity != null && entity.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) < (double)OUTLINE_RENDER_DISTANCE;
    }

    static int getDarkColor(PipeText pipeText) {
        int textColor = pipeText.getColor().getTextColor();
        if (textColor == DyeColor.BLACK.getTextColor() && pipeText.hasGlowingText()) {
            return -988212;
        }
        double d0 = 0.4;
        int j = (int)((double)FastColor.ARGB32.red((int)textColor) * 0.4);
        int k = (int)((double)FastColor.ARGB32.green((int)textColor) * 0.4);
        int l = (int)((double)FastColor.ARGB32.blue((int)textColor) * 0.4);
        return FastColor.ARGB32.color((int)0, (int)j, (int)k, (int)l);
    }
}

