/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.datagen;

import com.wenxin2.warp_pipes.blocks.ClearWarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.WarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.WaterSpoutBlock;
import com.wenxin2.warp_pipes.registries.ModRegistry;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class BlockStateGen
extends BlockStateProvider {
    public BlockStateGen(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "warp_pipes", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        String waterSpoutName = BuiltInRegistries.BLOCK.getKey((Object)((Block)ModRegistry.WATER_SPOUT.get())).getPath();
        this.pipeBubblesModel((Block)ModRegistry.PIPE_BUBBLES.get());
        this.waterSpoutModel((Block)ModRegistry.WATER_SPOUT.get(), this.modLoc("block/" + waterSpoutName + "_flow"), this.modLoc("block/" + waterSpoutName + "_still"), this.modLoc("block/" + waterSpoutName + "_splash"));
        for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : ModRegistry.WARP_PIPES.entrySet()) {
            String blockName = BuiltInRegistries.BLOCK.getKey((Object)((Block)entry.getValue().get())).getPath();
            ResourceLocation entranceTexture = this.modLoc("block/" + blockName + "_entrance_side");
            ResourceLocation sideTexture = this.modLoc("block/" + blockName + "_side");
            ResourceLocation bottomTexture = this.modLoc("block/" + blockName + "_bottom");
            ResourceLocation topTexture = this.modLoc("block/" + blockName + "_top");
            ResourceLocation topClosedTexture = this.modLoc("block/" + blockName + "_top_closed");
            this.warpPipeModel((Block)entry.getValue().get(), entranceTexture, bottomTexture, sideTexture, topTexture, topClosedTexture);
        }
    }

    private void pipeBubblesModel(Block block) {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/water"));
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
    }

    private void warpPipeModel(Block block, ResourceLocation entranceTexture, ResourceLocation bottomTexture, ResourceLocation sideTexture, ResourceLocation topTexture, ResourceLocation topClosedTexture) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, this.mcLoc("minecraft:block/cube_bottom_top"))).texture("bottom", bottomTexture)).texture("side", sideTexture)).texture("top", bottomTexture);
        ModelBuilder modelEntrance = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName + "_entrance", this.mcLoc("minecraft:block/cube_bottom_top"))).texture("bottom", bottomTexture)).texture("side", entranceTexture)).texture("top", topTexture);
        ModelBuilder modelClosed = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName + "_entrance_closed", this.mcLoc("minecraft:block/cube_bottom_top"))).texture("bottom", bottomTexture)).texture("side", entranceTexture)).texture("top", topClosedTexture);
        this.simpleBlockItem(block, (ModelFile)modelEntrance);
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        for (Direction direction : Direction.values()) {
            int xRot = this.getXRotation(direction);
            int yRot = this.getYRotation(direction);
            for (boolean entrance : new boolean[]{false, true}) {
                for (boolean closed : new boolean[]{false, true}) {
                    for (boolean bubbles : new boolean[]{false, true}) {
                        for (boolean waterSpout : new boolean[]{false, true}) {
                            ModelFile selectedModel = this.getModelForState((ModelFile)model, (ModelFile)modelEntrance, (ModelFile)modelClosed, entrance, closed);
                            variantBuilder.partialState().with((Property)WarpPipeBlock.FACING, (Comparable)direction).with((Property)WarpPipeBlock.ENTRANCE, (Comparable)Boolean.valueOf(entrance)).with((Property)WarpPipeBlock.CLOSED, (Comparable)Boolean.valueOf(closed)).with((Property)WarpPipeBlock.BUBBLES, (Comparable)Boolean.valueOf(bubbles)).with((Property)WarpPipeBlock.WATER_SPOUT, (Comparable)Boolean.valueOf(waterSpout)).addModels(new ConfiguredModel[]{new ConfiguredModel(selectedModel, xRot, yRot, false)});
                        }
                    }
                }
            }
        }
    }

    private void waterSpoutModel(Block block, ResourceLocation sideTexture, ResourceLocation topTexture, ResourceLocation splashTexture) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(modelName, this.modLoc("block/template_water_spout"))).texture("side", sideTexture);
        ModelBuilder modelTop = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName + "_top", this.modLoc("block/template_water_spout_top"))).texture("splash", splashTexture)).texture("side", sideTexture)).texture("top", topTexture);
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().with((Property)WaterSpoutBlock.TOP, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        variantBuilder.partialState().with((Property)WaterSpoutBlock.TOP, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelTop)});
    }

    private void clearWarpPipeModel(Block block) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder baseModel = this.models().withExistingParent(modelName, this.modLoc("block/clear_warp_pipe/clear_warp_pipe"));
        ModelBuilder entranceModel = this.models().withExistingParent(modelName + "_entrance", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_entrance"));
        ModelBuilder closedModel = this.models().withExistingParent(modelName + "_closed", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_closed"));
        ModelBuilder entranceClosedModel = this.models().withExistingParent(modelName + "_entrance_closed", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_entrance_closed"));
        ModelBuilder northModel = this.models().withExistingParent(modelName + "_n", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_n"));
        ModelBuilder southModel = this.models().withExistingParent(modelName + "_s", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_s"));
        ModelBuilder eastModel = this.models().withExistingParent(modelName + "_e", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_e"));
        ModelBuilder westModel = this.models().withExistingParent(modelName + "_w", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_w"));
        ModelBuilder upModel = this.models().withExistingParent(modelName + "_u", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_u"));
        ModelBuilder downModel = this.models().withExistingParent(modelName + "_d", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_d"));
        ModelBuilder nsModel = this.models().withExistingParent(modelName + "_ns", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_ns"));
        ModelBuilder ewModel = this.models().withExistingParent(modelName + "_ew", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_ew"));
        ModelBuilder udModel = this.models().withExistingParent(modelName + "_ud", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_ud"));
        ModelBuilder nsewModel = this.models().withExistingParent(modelName + "_nsew", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_nsew"));
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)baseModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.ENTRANCE, (Comparable)Boolean.valueOf(true)).with((Property)ClearWarpPipeBlock.CLOSED, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)entranceModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.ENTRANCE, (Comparable)Boolean.valueOf(true)).with((Property)ClearWarpPipeBlock.CLOSED, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)entranceClosedModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.CLOSED, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)closedModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.NORTH, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)northModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.SOUTH, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)southModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.EAST, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)eastModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.WEST, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)westModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.UP, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)upModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.DOWN, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)downModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.NORTH, (Comparable)Boolean.valueOf(true)).with((Property)ClearWarpPipeBlock.SOUTH, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)nsModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.EAST, (Comparable)Boolean.valueOf(true)).with((Property)ClearWarpPipeBlock.WEST, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)ewModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.UP, (Comparable)Boolean.valueOf(true)).with((Property)ClearWarpPipeBlock.DOWN, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)udModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.NORTH, (Comparable)Boolean.valueOf(true)).with((Property)ClearWarpPipeBlock.SOUTH, (Comparable)Boolean.valueOf(true)).with((Property)ClearWarpPipeBlock.EAST, (Comparable)Boolean.valueOf(true)).with((Property)ClearWarpPipeBlock.WEST, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)nsewModel)});
    }

    private int getXRotation(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> 0;
            case Direction.DOWN -> 180;
            case Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST -> 90;
        };
    }

    private int getYRotation(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> 0;
            case Direction.SOUTH -> 180;
            case Direction.EAST -> 90;
            case Direction.WEST -> 270;
            default -> 0;
        };
    }

    private ModelFile getModelForState(ModelFile model, ModelFile modelEntrance, ModelFile modelClosed, boolean entrance, boolean closed) {
        if (entrance) {
            return closed ? modelClosed : modelEntrance;
        }
        return model;
    }
}

