/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class RecipeUtils
extends RecipeProvider {
    public RecipeUtils(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, provider);
    }

    public void warpDisruptorRecipe(int outputAmt, ItemLike outputItem, ItemLike inputItem, TagKey<Item> inputItemTag, TagKey<Item> inputItemTag2, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('E'), inputItem).define(Character.valueOf('G'), inputItemTag).define(Character.valueOf('S'), inputItemTag2).pattern("  E").pattern(" G ").pattern("S  ").unlockedBy(RecipeUtils.getHasName((ItemLike)inputItem), RecipeUtils.has((ItemLike)inputItem)).unlockedBy("has_gold_ingot", RecipeUtils.has(inputItemTag)).unlockedBy("has_stick", RecipeUtils.has(inputItemTag2)).group("warp_pipes:" + RecipeUtils.getSimpleRecipeName((ItemLike)outputItem)).save(output);
    }

    public void warpPipeRecipe(int outputAmt, ItemLike outputItem, TagKey<Item> inputItemTag, TagKey<Item> inputItemTag2, TagKey<Item> inputItemTag3, TagKey<Item> inputItemTag4, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('I'), inputItemTag).define(Character.valueOf('D'), inputItemTag2).define(Character.valueOf('G'), inputItemTag3).define(Character.valueOf('E'), inputItemTag4).pattern("IDI").pattern("IGI").pattern("IEI").unlockedBy("has_copper_ingot", RecipeUtils.has(inputItemTag)).unlockedBy("has_dye", RecipeUtils.has(inputItemTag2)).unlockedBy("has_diamond", RecipeUtils.has(inputItemTag3)).unlockedBy("has_ender_pearl", RecipeUtils.has(inputItemTag4)).group("warp_pipes:warp_pipes").save(output);
    }

    public void wrenchRecipe(int outputAmt, ItemLike outputItem, TagKey<Item> inputItemTag, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)outputItem, (int)outputAmt).define(Character.valueOf('I'), inputItemTag).pattern("I I").pattern(" I ").pattern(" I ").unlockedBy("has_iron_ingot", RecipeUtils.has(inputItemTag)).group("warp_pipes:" + RecipeUtils.getSimpleRecipeName((ItemLike)outputItem)).save(output);
    }

    public void dyeItemRecipe(int outputAmt, String groupName, ItemLike outputItem, RecipeCategory category, Object input1, Object input2, RecipeOutput output) {
        TagKey tag;
        TagKey itemLike;
        ItemLike itemLike2;
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)outputItem, (int)outputAmt).group("warp_pipes:" + groupName);
        builder.unlockedBy(this.getUnlockName(input1), this.unlockCriterion(input1));
        builder.unlockedBy(this.getUnlockName(input2), this.unlockCriterion(input2));
        if (input1 instanceof ItemLike) {
            itemLike2 = (ItemLike)input1;
            builder.requires(itemLike2);
        } else if (input1 instanceof TagKey && (itemLike = (TagKey)input1).registry() == Registries.ITEM) {
            tag = itemLike;
            builder.requires(tag);
        }
        if (input2 instanceof ItemLike) {
            itemLike2 = (ItemLike)input2;
            builder.requires(itemLike2);
        } else if (input2 instanceof TagKey && (itemLike = (TagKey)input2).registry() == Registries.ITEM) {
            tag = itemLike;
            builder.requires(tag);
        }
        builder.save(output, "warp_pipes:" + RecipeUtils.getItemName((ItemLike)outputItem) + "_from_dye");
    }

    public void twoItemTagRecipe(int outputAmt, String groupName, String recipeName, ItemLike outputItem, RecipeCategory category, TagKey<Item> itemTag, TagKey<Item> itemTag2, RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)outputItem, (int)outputAmt).requires(itemTag).requires(itemTag2).unlockedBy("has_tag_item", RecipeUtils.has(itemTag)).unlockedBy("has_tag_item2", RecipeUtils.has(itemTag2)).group("warp_pipes:" + groupName).save(output, "warp_pipes:" + RecipeUtils.getSimpleRecipeName((ItemLike)outputItem) + recipeName);
    }

    private void defineIngredient(ShapedRecipeBuilder builder, char symbol, Object ingredient) {
        TagKey tag;
        if (ingredient instanceof ItemLike) {
            ItemLike item = (ItemLike)ingredient;
            builder.define(Character.valueOf(symbol), item);
        } else if (ingredient instanceof TagKey && (tag = (TagKey)ingredient).registry() == Registries.ITEM) {
            builder.define(Character.valueOf(symbol), tag);
        } else {
            throw new IllegalArgumentException("Unsupported ingredient type: " + String.valueOf(ingredient));
        }
    }

    private String getUnlockName(Object ingredient) {
        if (ingredient instanceof ItemLike) {
            ItemLike item = (ItemLike)ingredient;
            return RecipeUtils.getHasName((ItemLike)item);
        }
        if (ingredient instanceof TagKey) {
            TagKey tag = (TagKey)ingredient;
            return "has_" + tag.location().getPath();
        }
        throw new IllegalArgumentException("Unsupported ingredient type: " + String.valueOf(ingredient));
    }

    private Criterion<?> unlockCriterion(Object ingredient) {
        TagKey raw;
        if (ingredient instanceof ItemLike) {
            ItemLike item = (ItemLike)ingredient;
            return RecipeProvider.has((ItemLike)item);
        }
        if (ingredient instanceof TagKey && (raw = (TagKey)ingredient).registry() == Registries.ITEM) {
            TagKey tag = raw;
            return RecipeProvider.has((TagKey)tag);
        }
        throw new IllegalArgumentException("Unsupported ingredient: " + String.valueOf(ingredient));
    }
}

