/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.event_handlers;

import com.wenxin2.warp_pipes.blocks.ClearWarpPipeBlock;
import com.wenxin2.warp_pipes.registries.DataAttachmentRegistry;
import com.wenxin2.warp_pipes.registries.SoundRegistry;
import com.wenxin2.warp_pipes.sounds.FadeInAndOutSoundInstance;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="warp_pipes", value={Dist.CLIENT})
public class ClientEventHandlers {
    public static final Map<UUID, FadeInAndOutSoundInstance> ACTIVE_PIPE_SOUNDS = new HashMap<UUID, FadeInAndOutSoundInstance>();
    private static final ResourceLocation OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"warp_pipes", (String)"textures/misc/splunkin_pumpkin_blur.png");

    @SubscribeEvent
    public static void onEntityRemoved(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        UUID uuid = entity.getUUID();
        if (!(event.getLevel() instanceof ClientLevel)) {
            return;
        }
        if (ACTIVE_PIPE_SOUNDS.get(uuid) != null) {
            ACTIVE_PIPE_SOUNDS.get(uuid).startFadeOut();
            entity.setData(DataAttachmentRegistry.PLAYED_INSIDE_PIPE_SOUND, (Object)false);
        }
    }

    @SubscribeEvent
    public static void postEntityTick(EntityTickEvent.Post event) {
        boolean isEntrance;
        Entity entity = event.getEntity();
        UUID uuid = entity.getUUID();
        Level world = entity.level();
        BlockPos pos = entity.blockPosition();
        BlockState state = world.getBlockState(pos);
        boolean inClearPipe = state.getBlock() instanceof ClearWarpPipeBlock;
        boolean bl = isEntrance = state.hasProperty((Property)ClearWarpPipeBlock.ENTRANCE) && (Boolean)state.getValue((Property)ClearWarpPipeBlock.ENTRANCE) != false;
        if (!(entity.level() instanceof ClientLevel)) {
            return;
        }
        if (((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_EXIT_PIPE_SOUND)).booleanValue() && !((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_ENTER_PIPE_SOUND)).booleanValue() && inClearPipe && isEntrance) {
            entity.playSound((SoundEvent)SoundRegistry.CLEAR_PIPE_ENTER.get(), 1.0f, 1.0f);
            entity.setData(DataAttachmentRegistry.PLAYED_ENTER_PIPE_SOUND, (Object)true);
            entity.setData(DataAttachmentRegistry.PLAYED_EXIT_PIPE_SOUND, (Object)false);
        }
        if (((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_ENTER_PIPE_SOUND)).booleanValue() && !((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_EXIT_PIPE_SOUND)).booleanValue() && !inClearPipe) {
            entity.playSound((SoundEvent)SoundRegistry.CLEAR_PIPE_EXIT.get(), 1.0f, 1.0f);
            entity.setData(DataAttachmentRegistry.PLAYED_EXIT_PIPE_SOUND, (Object)true);
            entity.setData(DataAttachmentRegistry.PLAYED_ENTER_PIPE_SOUND, (Object)false);
        }
        if (((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_ENTER_PIPE_SOUND)).booleanValue() && !((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_EXIT_PIPE_SOUND)).booleanValue() && !((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_INSIDE_PIPE_SOUND)).booleanValue() && inClearPipe) {
            FadeInAndOutSoundInstance insideSound = new FadeInAndOutSoundInstance(entity, (SoundEvent)SoundRegistry.CLEAR_PIPE_INSIDE.get(), SoundSource.BLOCKS, 20.0f, 10.0f);
            ACTIVE_PIPE_SOUNDS.put(uuid, insideSound);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)insideSound);
            entity.setData(DataAttachmentRegistry.PLAYED_INSIDE_PIPE_SOUND, (Object)true);
        }
        if (((Boolean)entity.getData(DataAttachmentRegistry.PLAYED_INSIDE_PIPE_SOUND)).booleanValue() && !inClearPipe) {
            FadeInAndOutSoundInstance active = ACTIVE_PIPE_SOUNDS.get(uuid);
            if (active != null) {
                active.startFadeOut();
            }
            ACTIVE_PIPE_SOUNDS.remove(uuid);
            entity.setData(DataAttachmentRegistry.PLAYED_INSIDE_PIPE_SOUND, (Object)false);
        }
    }
}

