/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.items;

import com.wenxin2.warp_pipes.blocks.ClearWarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.WarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.entities.BaseWarpBlockEntity;
import com.wenxin2.warp_pipes.registries.ConfigRegistry;
import com.wenxin2.warp_pipes.registries.DataComponentRegistry;
import com.wenxin2.warp_pipes.registries.SoundRegistry;
import java.util.List;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LinkerItem
extends TieredItem {
    public LinkerItem(Item.Properties properties, Tier tier) {
        super(tier, properties);
    }

    private static boolean getLinkableBlock(BlockState state) {
        if (state.getBlock() instanceof WarpPipeBlock && ((Boolean)state.getValue((Property)WarpPipeBlock.ENTRANCE)).booleanValue()) {
            return true;
        }
        if (state.getBlock() instanceof WarpPipeBlock && !((Boolean)state.getValue((Property)WarpPipeBlock.ENTRANCE)).booleanValue()) {
            return false;
        }
        if (state.getBlock() instanceof ClearWarpPipeBlock) {
            return true;
        }
        return true;
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        Player player = useOnContext.getPlayer();
        Level world = useOnContext.getLevel();
        BlockPos pos = useOnContext.getClickedPos();
        BlockState state = world.getBlockState(pos);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        ItemStack stack = useOnContext.getItemInHand();
        String dimension = world.dimension().location().toString();
        if (player != null && !player.isCreative() && ((Boolean)ConfigRegistry.CREATIVE_WRENCH_LINKING.get()).booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.requires_creative")), true);
            return InteractionResult.sidedSuccess((boolean)Boolean.TRUE);
        }
        if (player != null && player.isShiftKeyDown() && blockEntity instanceof BaseWarpBlockEntity) {
            BaseWarpBlockEntity warpBE = (BaseWarpBlockEntity)blockEntity;
            if (LinkerItem.getLinkableBlock(state)) {
                UUID uuid = warpBE.getUUID();
                if (warpBE.isWaxed() && ((Boolean)ConfigRegistry.WAX_DISABLES_WARP_LINKING.get()).booleanValue()) {
                    player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.waxed"), (Object[])new Object[]{state.getBlock().getName()}).withStyle(ChatFormatting.GOLD), true);
                    return InteractionResult.sidedSuccess((boolean)true);
                }
                if (!LinkerItem.getIsBound(stack)) {
                    if (!world.isClientSide && uuid == null) {
                        uuid = UUID.randomUUID();
                        warpBE.setUUID(uuid);
                        warpBE.setChanged();
                    }
                    LinkerItem.setWarpPos(stack, pos);
                    LinkerItem.setWarpDimension(stack, dimension);
                    LinkerItem.setWarpUUID(stack, uuid);
                    LinkerItem.setIsBound(stack, true);
                    player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.bound"), (Object[])new Object[]{state.getBlock().getName()}).withStyle(ChatFormatting.GREEN), true);
                    this.spawnParticles(world, pos, (ParticleOptions)ParticleTypes.ENCHANT);
                    this.playSound(world, pos, (SoundEvent)SoundRegistry.WRENCH_BOUND.get(), SoundSource.PLAYERS, 1.0f, 0.1f);
                } else {
                    if (!world.isClientSide && uuid == null) {
                        uuid = UUID.randomUUID();
                        warpBE.setUUID(uuid);
                        warpBE.setChanged();
                    }
                    BlockPos firstPos = LinkerItem.getWarpPos(stack);
                    BlockState firstState = world.getBlockState(firstPos);
                    String firstDim = LinkerItem.getWarpDimension(stack);
                    BlockEntity firstBE = world.getBlockEntity(firstPos);
                    if (firstBE instanceof BaseWarpBlockEntity) {
                        BaseWarpBlockEntity firstWarpBE = (BaseWarpBlockEntity)firstBE;
                        this.link(stack, firstWarpBE, warpBE);
                        player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.linked_warp_block"), (Object[])new Object[]{state.getBlock().getName(), firstState.getBlock().getName()}).withStyle(ChatFormatting.GOLD), true);
                        this.spawnParticles(world, pos, (ParticleOptions)ParticleTypes.ENCHANT);
                        this.playSound(world, pos, (SoundEvent)SoundRegistry.PIPES_LINKED.get(), SoundSource.BLOCKS, 1.0f, 0.1f);
                    }
                    LinkerItem.setIsBound(stack, false);
                }
                return InteractionResult.sidedSuccess((boolean)Boolean.TRUE);
            }
        }
        return super.useOn(useOnContext);
    }

    public void link(ItemStack stack, BaseWarpBlockEntity firstPipeBlockEntity, BaseWarpBlockEntity secondPipeBlockEntity) {
        UUID firstUuid = firstPipeBlockEntity.getUUID();
        UUID secondUuid = secondPipeBlockEntity.getUUID();
        BlockPos firstPos = firstPipeBlockEntity.getBlockPos();
        BlockPos secondPos = secondPipeBlockEntity.getBlockPos();
        ResourceKey<Level> firstDim = firstPipeBlockEntity.getDestinationDim();
        ResourceKey<Level> secondDim = secondPipeBlockEntity.getDestinationDim();
        firstPipeBlockEntity.setDestinationPos(secondPos);
        secondPipeBlockEntity.setDestinationPos(firstPos);
        if (secondDim != null) {
            firstPipeBlockEntity.setDestinationDim(secondDim);
        }
        if (firstDim != null) {
            secondPipeBlockEntity.setDestinationDim(firstDim);
        }
        if (firstUuid != null) {
            secondPipeBlockEntity.setWarpUuid(firstUuid);
        }
        if (secondUuid != null) {
            firstPipeBlockEntity.setWarpUuid(secondUuid);
        }
        firstPipeBlockEntity.markUpdated();
        secondPipeBlockEntity.markUpdated();
        this.clearItemComponents(stack);
    }

    public void clearItemComponents(ItemStack stack) {
        LinkerItem.setWarpPos(stack, null);
        LinkerItem.setWarpDimension(stack, "");
        LinkerItem.setWarpUUID(stack, null);
    }

    public static boolean getIsBound(ItemStack stack) {
        return (Boolean)stack.getOrDefault((DataComponentType)DataComponentRegistry.IS_BOUND.get(), (Object)Boolean.FALSE);
    }

    public static void setIsBound(ItemStack stack, boolean isBound) {
        stack.set((DataComponentType)DataComponentRegistry.IS_BOUND.get(), (Object)isBound);
    }

    public static BlockPos getWarpPos(ItemStack stack) {
        return (BlockPos)stack.getOrDefault(DataComponentRegistry.WARP_POS, null);
    }

    public static void setWarpPos(ItemStack stack, BlockPos warpPos) {
        stack.set(DataComponentRegistry.WARP_POS, (Object)warpPos);
    }

    public static String getWarpDimension(ItemStack stack) {
        return (String)stack.getOrDefault((DataComponentType)DataComponentRegistry.WARP_DIMENSION.get(), (Object)"");
    }

    public static void setWarpDimension(ItemStack stack, String dimension) {
        stack.set((DataComponentType)DataComponentRegistry.WARP_DIMENSION.get(), (Object)dimension);
    }

    public static UUID getWarpUUID(ItemStack stack) {
        UUID uuid = UUID.randomUUID();
        return (UUID)stack.getOrDefault((DataComponentType)DataComponentRegistry.WARP_UUID.get(), null);
    }

    public static UUID setWarpUUID(ItemStack stack, UUID warpUUID) {
        stack.set((DataComponentType)DataComponentRegistry.WARP_UUID.get(), (Object)warpUUID);
        return warpUUID;
    }

    public static GlobalPos getGlobalWarpPos(ItemStack stack) {
        return (GlobalPos)stack.getOrDefault((DataComponentType)DataComponentRegistry.GLOBAL_WARP_POS.get(), null);
    }

    public static void setGlobalWarpPos(ItemStack stack, GlobalPos globalPos) {
        stack.set((DataComponentType)DataComponentRegistry.GLOBAL_WARP_POS.get(), (Object)globalPos);
    }

    public void playSound(Level world, BlockPos pos, SoundEvent soundEvent, SoundSource source, float volume, float pitch) {
        world.playSound(null, pos, soundEvent, source, volume, pitch);
    }

    public void spawnParticles(Level world, BlockPos pos, ParticleOptions particleOptions) {
        if (world.isClientSide()) {
            RandomSource random = world.getRandom();
            for (int i = 0; i < 40; ++i) {
                world.addParticle(particleOptions, (double)pos.getX() + 0.5 + 0.5 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5 + 0.5 * (double)(random.nextBoolean() ? 1 : -1), (random.nextDouble() - 0.5) * 2.0, -random.nextDouble(), (random.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltip) {
        if (LinkerItem.getIsBound(stack) && LinkerItem.getWarpPos(stack) != null) {
            list.add((Component)Component.literal((String)""));
            list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.bound"), (Object[])new Object[]{true}).withStyle(ChatFormatting.GOLD));
            list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.bound.x"), (Object[])new Object[]{LinkerItem.getWarpPos(stack).getX(), true}).withStyle(ChatFormatting.GRAY));
            list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.bound.y"), (Object[])new Object[]{LinkerItem.getWarpPos(stack).getY(), true}).withStyle(ChatFormatting.GRAY));
            list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.bound.z"), (Object[])new Object[]{LinkerItem.getWarpPos(stack).getZ(), true}).withStyle(ChatFormatting.GRAY));
        }
    }
}

