/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.network.server_bound.handler;

import com.wenxin2.warp_pipes.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.warp_pipes.network.server_bound.data.RenamePipePayload;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class RenamePipePacket {
    public static final RenamePipePacket INSTANCE = new RenamePipePacket();

    public static RenamePipePacket get() {
        return INSTANCE;
    }

    public void handle(RenamePipePayload payload, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                if (payload.pos() == null || payload.customName() == null) {
                    return;
                }
                ServerPlayer player = (ServerPlayer)context.player();
                Level world = player.level();
                BlockEntity blockEntity = world.getBlockEntity(payload.pos());
                if (blockEntity instanceof WarpPipeBlockEntity) {
                    ((WarpPipeBlockEntity)blockEntity).sendData();
                    ((WarpPipeBlockEntity)blockEntity).setCustomName((Component)Component.literal((String)payload.customName()));
                    ((WarpPipeBlockEntity)blockEntity).updateText(pipeText -> pipeText.setMessage(0, (Component)Component.literal((String)payload.customName())));
                    ((WarpPipeBlockEntity)blockEntity).markUpdated();
                }
            });
        }
    }
}

