/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.snifferreimagined.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.mariany.snifferreimagined.SnifferReimagined;
import dev.mariany.snifferreimagined.config.SRConfig;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class SRConfigHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/snifferreimagined.json5");
    private static SRConfig config = new SRConfig();

    public static SRConfig getConfig() {
        return config;
    }

    public static void loadConfig() {
        SnifferReimagined.LOGGER.info("Loading config for snifferreimagined");
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                config = (SRConfig)GSON.fromJson((Reader)reader, SRConfig.class);
            }
            catch (IOException error) {
                SnifferReimagined.LOGGER.error("Failed to load config: {}", (Object)error.getMessage());
            }
        }
        SRConfigHandler.saveConfig();
    }

    private static void saveConfig() {
        try {
            if (CONFIG_FILE.getParentFile().mkdirs()) {
                SnifferReimagined.LOGGER.info("Creating parent directory for {} config", (Object)"snifferreimagined");
            }
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
        }
        catch (IOException error) {
            SnifferReimagined.LOGGER.error("Failed to save config: {}", (Object)error.getMessage());
        }
    }
}

