/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.tab;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl3.gui.tab.TabExt;
import dev.isxander.yacl3.mixin.TabNavigationBarAccessor;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_5348;
import net.minecraft.class_7845;
import net.minecraft.class_8087;
import net.minecraft.class_8088;
import net.minecraft.class_8089;
import net.minecraft.class_8209;
import org.jetbrains.annotations.Nullable;

public class ScrollableNavigationBar
extends class_8089 {
    private static final int NAVBAR_MARGIN = 28;
    private static final class_327 font = class_310.method_1551().field_1772;
    private int scrollOffset;
    private int maxScrollOffset;
    private final TabNavigationBarAccessor accessor = (TabNavigationBarAccessor)((Object)this);

    public ScrollableNavigationBar(int width, class_8088 tabManager, Iterable<? extends class_8087> tabs) {
        super(width, tabManager, (Iterable)ImmutableList.copyOf(tabs));
        for (class_8209 tabButton : this.accessor.yacl$getTabButtons()) {
            class_8087 class_80872 = tabButton.method_49609();
            if (!(class_80872 instanceof TabExt)) continue;
            TabExt tab = (TabExt)class_80872;
            tabButton.method_47400(tab.getTooltip());
        }
    }

    public void method_49613() {
        ImmutableList<class_8209> tabButtons = this.accessor.yacl$getTabButtons();
        int noScrollWidth = this.accessor.yacl$getWidth() - 56;
        int allTabsWidth = 0;
        for (class_8209 tabButton : tabButtons) {
            int buttonWidth = font.method_27525((class_5348)tabButton.method_25369()) + 20;
            allTabsWidth += buttonWidth;
            tabButton.method_25358(buttonWidth);
        }
        if (allTabsWidth < noScrollWidth) {
            int equalWidth = noScrollWidth / tabButtons.size();
            List<class_8209> smallTabs = tabButtons.stream().filter(btn -> btn.method_25368() < equalWidth).toList();
            List<class_8209> bigTabs = tabButtons.stream().filter(btn -> btn.method_25368() >= equalWidth).toList();
            int leftoverWidth = noScrollWidth - bigTabs.stream().mapToInt(class_339::method_25368).sum();
            int equalWidthForSmallTabs = leftoverWidth / smallTabs.size();
            for (class_8209 tabButton : smallTabs) {
                tabButton.method_25358(equalWidthForSmallTabs);
            }
            allTabsWidth = noScrollWidth;
        }
        class_7845 layout = ((TabNavigationBarAccessor)((Object)this)).yacl$getLayout();
        layout.method_48222();
        layout.method_46419(0);
        this.scrollOffset = 0;
        layout.method_46421(Math.max((this.accessor.yacl$getWidth() - allTabsWidth) / 2, 28));
        this.maxScrollOffset = Math.max(0, allTabsWidth - noScrollWidth);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 10.0f);
        super.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_51448().method_22909();
    }

    public boolean method_25401(double mouseX, double mouseY, double vertical) {
        this.setScrollOffset(this.scrollOffset - (int)(vertical * 15.0));
        return true;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseY <= 24.0;
    }

    public void setScrollOffset(int scrollOffset) {
        class_7845 layout = ((TabNavigationBarAccessor)((Object)this)).yacl$getLayout();
        layout.method_46421(layout.method_46426() + this.scrollOffset);
        this.scrollOffset = class_3532.method_15340((int)scrollOffset, (int)0, (int)this.maxScrollOffset);
        layout.method_46421(layout.method_46426() - this.scrollOffset);
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public void method_25395(@Nullable class_364 child) {
        super.method_25395(child);
        if (child instanceof class_8209) {
            class_8209 tabButton = (class_8209)child;
            this.ensureVisible(tabButton);
        }
    }

    protected void ensureVisible(class_8209 tabButton) {
        if (tabButton.method_46426() < 28) {
            this.setScrollOffset(this.scrollOffset - (28 - tabButton.method_46426()));
        } else if (tabButton.method_46426() + tabButton.method_25368() > this.accessor.yacl$getWidth() - 28) {
            this.setScrollOffset(this.scrollOffset + (tabButton.method_46426() + tabButton.method_25368() - (this.accessor.yacl$getWidth() - 28)));
        }
    }

    public ImmutableList<class_8087> getTabs() {
        return this.accessor.yacl$getTabs();
    }

    public class_8088 getTabManager() {
        return this.accessor.yacl$getTabManager();
    }
}

